<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

?>
<h2>Change Master</h2>
<?php

// print "<pre>"; print_r($aSlaveStatus); print "</pre>";

// Check if Slave is completely stopped
if ( ($aSlaveStatus['Slave_IO_Running'] == 'No') && ($aSlaveStatus['Slave_IO_Running'] == 'No') ) {

	// Try to get password from master.info

	// todo it is hard coded master.info
	list($ret, $output) = catRemoteFile('root', $aNode['hostname'], $aNode['datadir'] . '/' . 'master.info');
	// master.info file not found yet.
	if ( $ret != OK ) {
		$rc = 553;
		$msg = "Error: $output (rc=$rc).";
		logMessage(LOG_ERR, $msg);
		print "<p>$msg</p>\n";
		$aSlaveStatus['Master_Password'] = '';


		// Guessing information from Mocenter settings.

		list($ret, $aMasters) = getNodesWithFilter($dbh, array('node_id' => $aNode['master_id']));

		if ( $ret == OK ) {
			$aMaster = 	array_shift($aMasters);
			$aSlaveStatus['Master_Host'] = $aMaster['hostname'];
			$aSlaveStatus['Master_Port'] = $aMaster['port'];
		}

		// Guessing repliation user
		
		list($ret, $mysqli) = openDatabaseConnection($aMaster['database_user'], $aMaster['database_user_password'], $aMaster['hostname'], $aMaster['port']);
    if ( $ret != OK ) {
      print "<p>" . $mysqli . "</p>\n";
      exit($ret);
    }
    else {

			list($ret, $aUsers) = getReplicationUsers($mysqli);
			if ( count($aUsers) > 0 ) {
			
				// Pick first user
				$repl = array_shift($aUsers);
				$aRepl = explode('@', $repl);
				$aSlaveStatus['Master_User'] = trim($aRepl[0], "'");
			}
		}
    closeDatabaseConnection($mysqli);
    
    // todo: Password could be guesse from other Slaves
    // User could also be guessed from other Slaves
	}
	else {
		$aSlaveStatus['Master_Password'] = $output[5];
	}

  ?>
  <form action="index.php" method="post">
  <table border="1" cellspacing="0" cellpadding="3">
    <tr><td>MASTER_HOST</td><td><input type="text" name="master_host" value="<?php print $aSlaveStatus['Master_Host']; ?>" /></td></tr>
    <tr><td>MASTER_PORT</td><td><input type="text" name="master_port" value="<?php print $aSlaveStatus['Master_Port']; ?>" /></td></tr>
    <tr><td>MASTER_USER</td><td><input type="text" name="master_user" value="<?php print $aSlaveStatus['Master_User']; ?>" /></td></tr>
    <tr><td>MASTER_PASSWORD</td><td><input type="text" name="master_password" value="<?php print $aSlaveStatus['Master_Password']; ?>" /></td></tr>
    <tr><td>MASTER_LOG_FILE</td><td><input type="text" name="master_log_file" value="<?php print $aSlaveStatus['Master_Log_File']; ?>" /></td></tr>
    <tr><td>MASTER_LOG_POS</td><td><input type="text" name="master_log_pos" value="<?php print $aSlaveStatus['Exec_Master_Log_Pos']; ?>" /></td></tr>
    <tr><td>&nbsp;</td><td></td></tr>
    <tr>
      <td></td>
      <td>
        <input type="submit" value="Change Master" />&nbsp;
        <input type="button" value="Back" onClick="window.history.back();" />
      </td>
    </tr>
  </table>

  <input type="hidden" name="o" value="slave" />
  <input type="hidden" name="f" value="safe" />
  <input type="hidden" name="t" value="change_master" />
  <input type="hidden" name="node_id" value="<?php print $hNodeId; ?>" />

  </form>
  <?php
}
// Slave is NOT completely stopped
// so it does not make sense to CHANGE MASTER
else {
	?>
	<p>Slave is not stopped. I cannot CHANGE MASTER. Please stop the slave first.</p>
	<?php
}

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
