<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

require_once("lib/Database.inc");

if ( $hNodeId > 0 ) {
  list($ret, $aNode) = readNodeById($hNodeId);
  list($ret, $aCluster) = getClusterOfNode($dbh, $hNodeId);
}
else {
  $rc = 145;
  print "<p>There went something terribly wrong. Node ID is 0 (rc=$rc).</p>\n";
  exit($rc);
}

list($rc, $mysqli) = openDatabaseConnection($aNode['database_user'], $aNode['database_user_password'], $aNode['hostname'], $aNode['port']);
if ( $rc != 0 ) {
  $rc = 146;
  print "<p>Open database " . $aNode['name'] . " failed (rc=$rc)\n";
}

?>
<h1>Slave <?php print $aNode['name']; ?></h1>
<?php

// ---------------------------------------------------------------------
if ( $hType == 'change_master' )
// ---------------------------------------------------------------------
{
  ?>
  <h2>Change Master</h2>

  <p>Changing Slave to new Master...</p>
  <?php

  list($rc, $msg) = setSlaveToMaster($mysqli, $_REQUEST);

  ?>
  <p><?php print $msg; ?></p>

  <p><input type="button" value="Continue" title="Operations" onClick="window.location='index.php?f=show&amp;o=replication&amp;s=operations&amp;cluster_id=<?php print $aCluster['cluster_id']; ?>'"></p>
  <?php
}
// ---------------------------------------------------------------------
else
// ---------------------------------------------------------------------
{
  $rc = 147;
  print "<p>ERROR (rc=$rc).</p>\n";
}

closeDatabaseConnection($mysqli);

?>
