<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

// print "<pre>"; print_r($_REQUEST); print "</pre>";

$lSubMenu = array(
  'stop    '      => array('title' => 'Stop Slave')
);

if ( $hFunction == 'stop' ) {
  include("page/slave.stop.php");
}
elseif ( $hFunction == 'start' ) {
  include("page/slave.start.php");
}
elseif ( $hFunction == 'skip' ) {
  include("page/slave.skip.php");
}
elseif ( $hFunction == 'show' ) {


  require_once("lib/Ssh.inc");

  if ( $hNodeId > 0 ) {
    list($rc, $aNode) = readNodeById($hNodeId);
  }
  else {
    $rc = 142;
    print "<p>ERROR: There went something terribly wrong. Node ID is 0 (rc=$rc).</p>\n";
    exit($rc);
  }

  list($rc, $mysqli) = openDatabaseConnection($aNode['database_user'], $aNode['database_user_password'], $aNode['hostname'], $aNode['port']);
  if ( $rc != 0 ) {
    $rc = 143;
    print "<p>ERROR: Open database " . $aNode['name'] . " failed (rc=$rc)\n";
  }

  list($rc, $aSlaveStatus) = getShowSlaveStatus($mysqli);

  closeDatabaseConnection($mysqli);

  ?>

  <h1>Slave <?php print $aNode['name']; ?></h1>

  <?php

  // ---------------------------------------------------------------------
  if ( $hType == 'change_master' ) {
    include("page/slave.show.change_master.php");
  }
  elseif ( $hType == 'build' ) {
    include("page/slave.show.build.php");
  }
  // ---------------------------------------------------------------------
  else
  // ---------------------------------------------------------------------
  {
    $rc = 144;
    print "<p>ERROR (rc=$rc).</p>\n";
  }
}
elseif ( $hFunction == 'safe' ) {
  include("page/slave.safe.php");
}
elseif ( $hFunction == 'reset' ) {
  include("page/slave.reset.php");
}
elseif ( $hFunction == 'build' ) {
  include("page/slave.build.php");
}
else {
  print "<p>ERROR: Unkown function $hFunction.</p>\n";
}

?>
