<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));

?>

<script src="js/slave.build.js"></script>

<?php
// print_r($_REQUEST);

// default: from Master
$hBuildSource = isset($_REQUEST['build_source']) ? intval($_REQUEST['build_source']) : 2;
// default: mysqldump
$hBackupMethod = isset($_REQUEST['backup_method']) ? intval($_REQUEST['backup_method']) : 2;
$hBoost        = isset($_REQUEST['boost']) ? true : false;
$hStartSlave   = isset($_REQUEST['start_slave']) ? true : false;

list($rc, $aSlaveNode) = getDatabaseNodeById($dbh, $hNodeId);
list($ret, $lMasterId) = getMasterOfSlave($dbh, $aSlaveNode['node_id']);
list($ret, $aMasterNode) = getDatabaseNodeById($dbh, $lMasterId);

?>

<h1>Build slave <?php print $aSlaveNode['name']; ?></h1>

<h2>Building slave <?php print $aSlaveNode['name']; ?>...</h2>

<?php

// ---------------------------------------------------------------------
// mysqldump
if ( $hBackupMethod == 2 )
// ---------------------------------------------------------------------
{

  $method = 'mysqldump';

	// buildSlaveWithMysqldump($aServer, $aSlaveNode)

	?>
	<p>Method: <?php print $method; ?></p>
	<p>This can take a while...</p>

	<div id="build-message"><img src="img/hourglass.gif" alt="hourglass.gif" title="Please wait" /></div>
	<script> document.getElementById("build-message").hidden = true; </script>

	<?php
}
// ---------------------------------------------------------------------
else
// ---------------------------------------------------------------------
{
  $rc = 135;
  print "<p>ERROR: Unknown backup method: $hBackupMethod (rc=$rc).</p>\n";
}


// list($ret, $dbh) = openRepositoryDatabase();
if ( $ret != OK ) {
  $rc = 136;
  print "<p>Cannot open configuration database (rc=$rc).</p>\n";
  return array($rc, $aSlaveNode);
}
list($ret, $aCluster) = getClusterOfNode($dbh, $aSlaveNode['node_id']);
// closeRepositoryDatabase($dbh);

?>

<p><input type="button" value="Continue" onclick="location.href='index.php?f=show&amp;o=replication&amp;s=operations&amp;cluster_id=<?php print $aCluster['cluster_id']; ?>';" /></p>

<script>

window.onload = buildSlave(<?php print $aMasterNode['node_id']; ?>, <?php print $aSlaveNode['node_id']; ?>, '<?php print $method; ?>', <?php print $hStartSlave; ?>);

</script>

<?php

logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
