<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

?>
<h1>Server overview</h1>
<?php

list($rc, $dbh) = openRepositoryDatabase();
list($ret, $aServers) = getAllServers($dbh);
list($ret, $aClusters) = getAllClusters($dbh);
closeRepositoryDatabase($dbh);

if ( count($aServers) == 0 ) {
  echo "<p>No servers found yet.</p>\n";
}
else {
  ?>
  <table border="1" cellpadding="1" cellspacing="0" width="50%">
    <tr>
      <th></th>
      <th align="left">Server name</th>
      <th align="left">IP address</th>
      <th align="left">Cluster</th>
    </tr>
    <?php
    // Print all servers
    foreach ( $aServers as $aServer ) {
      ?>
      <tr>
        <td align='center'><a href='index.php?f=edit&amp;o=server&amp;server_id=<?php echo $aServer['server_id']; ?>'><img src='img/edit.png' alt='Edit' title='Edit Server' width="8 " height="8" /></a></td>
        <td><a href='index.php?f=show&amp;o=server&amp;s=configuration&amp;server_id=<?php echo $aServer['server_id']; ?>'><?php echo $aServer['name']; ?></a></td>
        <td><?php echo $aServer['default_ip']; ?></td>
				<td>
					<?php
					if ( $aServer['cluster_id'] != 0 ) {
						print $aClusters[$aServer['cluster_id']]['name'];
					}
					?>
				</td>
      </tr>
      <?php
    }
    ?>
  </table><br />
  <?php
}

?>
<p>
<input type="button" value="Add Server" onClick="location.href='index.php?f=add&amp;o=server&amp;t=mysqld'" />
&nbsp;
<input type="button" disabled="disabled" value="Autodetect Server" onClick="location.href='index.php?o=server&amp;f=show&amp;s=autodetect'" />
</p>

<?php

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
