<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));

list($rc, $dbh) = openRepositoryDatabase();
list($rc, $aServer) = getServerById($dbh, $hServerId);
closeRepositoryDatabase($dbh);

?>

<h1>Configuration of Server <?php print $aServer['name']; ?></h1>

<table border="1" cellpadding="3" cellspacing="0">
  <tr><td><strong>Server name:</strong></td><td><?php print $aServer['name']; ?></td></tr>
  <tr><td><strong>Default IP:</strong></td><td><?php print $aServer['default_ip']; ?></td></tr>
  <tr><td><strong>O/S user:</strong></td><td><?php print $aServer['os_user']; ?></td></tr>
  <?php
  if ( $aServer['cluster_id'] == 0 ) {
    $name = 'none';
  }
  else {
    list($rc, $aCluster) = getClusterById($dbh, $aServer['cluster_id']);
    $name = $aCluster['name'];
  }
  ?>
  <tr><td><strong>Cluster:</strong></td><td><?php print $name; ?></td></tr>
</table>

<!-- for javascript stuff -->
<input type="hidden" id="server_id" name="server_id" value="<?php print $aServer['server_id']; ?>" />

<p>
<input type="button" value="Edit server" onClick="location.href='index.php?f=edit&amp;o=server&amp;server_id=<?php print $aServer['server_id']; ?>'" />
&nbsp;
<button id="opener">Delete server</button>
</p>


<div id="dialog-confirm" title="Delete server?">
<p><span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 20px 0;"></span>This server will be permantely deleted from the repository. Are you sure?</p>
</div>

<script src="js/server.show.configuration.js"></script>
