<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

$lSubMenu = array(
  'configuration'  => array('title' => 'Configuration', 'active' => true, 'demo' => false)
, 'checks'         => array('title' => 'Checks', 'active' => false, 'demo' => false)
);

/*
? >
<table width="100%" border="1" cellpadding="3" cellspacing="0">
  <tr>
  <?php
  foreach ( $lSubMenu as $submenu => $values ) {
    $url = "index.php?f=show&o=server&s=" . $submenu . "&server_id=" . $hServerId;
    print '<td><a href="' . $url . '">' . $values['title'] . "</a></td>\n";
  }
  ?>
  </tr>
</table>

<?php

*/

// Overview / List of databases

list($ret, $dbh) = openRepositoryDatabase();
list($ret, $aServer) = getServerById($dbh, $hServerId);
logMessage(LOG_DEBUG, "getServerById rc=$ret");
closeRepositoryDatabase($dbh);

// print "<pre>"; print_r($aServer); print "</pre>";

print "<h1>Server " . $aServer['name'] . "</h1>\n";
print "<h2>Checks</h2>\n";
?>
<p><input type="button" value="Check Server" onclick="javascript:location.href='index.php?f=test&amp;o=server&amp;server_id=<?php print $hServerId; ?>';" /></p>

<table border="1" width="100%" cellpadding="3" cellspacing="0">
  <tr>
    <th align="left">Last check</th>
    <th align="left">Time</th>
    <th align="left">Time ago</th>
    <th align="left">Status</th>
    <th></th>
  </tr>
  <?php

  list($rc, $dbh) = openRepositoryDatabase();
  list($ret, $aServerChecks) = getAllServerChecks($dbh, $hServerId);
  closeRepositoryDatabase($dbh);

  // No reason to stop when no checks are found
  // if ( count($aServerChecks) == 0 ) {
  //   $rc = 124;
  //   print "<p>No server checks found for server " . $aServer['name'] . " (rc=$rc).</p>\n";
  // }

  $aServerCheckTypes = getServerCheckTypes();
  foreach ( $aServerCheckTypes as $check ) {

    // Set defaults if check is not known yet
    if ( ! isset($aServerChecks[$check]) ) {
      $aServerChecks[$check]['name']                         = $check;
      $aServerChecks[$check]['server_id']                           = $hServerId;
      $aServerChecks[$check]['last_check_ts']                = 0;
      $aServerChecks[$check]['last_check_status']            = 'unknown';
      $aServerChecks[$check]['last_successful_check_ts']     = 0;
      $aServerChecks[$check]['last_successful_check_status'] = 'unknown';
    }

    list($ts, $status, $color, $ago) = renderCheck($aServerChecks[$check]['last_check_ts'], $aServerChecks[$check]['last_check_status']);
    ?>
    <tr>
      <td>Last <?php print $check; ?> check:</td>
      <td><?php
        if ( $ts == 0 ) {
          print '&nbsp;';
        }
        else {
          print date('Y-m-d H:i:s', $ts);
        }
      ?></td>
      <td><?php
        if ( $ago == 'unknown' ) {
          print '';
        }
        else {
          print $ago;
        }
      ?></td>
      <td align="center"><span style="color:<?php print $color; ?>"><strong><?php print $status; ?></strong></span></td>
      <td align="center"><input type="button" value="Check now" onclick="javascript:location.href='index.php?f=check&amp;o=server&amp;server_id=<?php print $hServerId; ?>&amp;t=<?php print $check; ?>';" /></td>
    </tr>
    <?php

    if ( $status != 'OK' ) {

      list($ts, $status, $color, $ago) = renderCheck($aServerChecks[$check]['last_successful_check_ts'], $aServerChecks[$check]['last_successful_check_status']);
      ?>
      <tr>
        <td>&nbsp;&nbsp;Last successfull check: </td>
        <td><?php
          if ( $ts == 0 ) {
            print '&nbsp;';
          }
          else {
            print date('Y-m-d H:i:s', $ts);
          }
        ?></td>
      <td><?php
        if ( $ago == 'unknown' ) {
          print '';
        }
        else {
          print $ago;
        }
      ?></td>
        <td align="center"></td>
        <td></td>
      </tr>
      <?php
    }
  }
  ?>
</table>

<?php

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
