<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

?>
<h1>Autodetect Servers</h1>

<p>Find hosts in our network...</p>

<?php

// inet addr:192.168.3.22  Bcast:192.168.3.255  Mask:255.255.255.0

// Extract broadcast and netmask from ifconfig
if ( ! ($p = popen('/sbin/ifconfig', 'r')) ) {
  print "<p>Cannot open ifconfig.</p>\n";
  exit(1);
}

$output = '';
while( ! feof($p) ) {
  $output .= fread($p,1024);
}
fclose($p);

// var_dump($output);

$match  = "/.*inet addr:(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}).* Bcast:(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}).*Mask:(\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3})$/im";
if ( ! preg_match($match, $output, $regs) ) {
  ?>
  <p>Cannot parse interfaces from:</p>
  <pre><?php print $output; ?></pre>
  <p><input type='button' value='Back' onclick='window.history.back();'></p>
  <?php
}
else {

  $myip  = ip2long($regs[1]);
  $bcast = ip2long($regs[2]);
  $nmask = ip2long($regs[3]);
  $nwork = ($bcast & $nmask);

  $lMyIp      = $regs[1];
  $lBroadcast = $regs[2];
  $lNetmask   = $regs[3];
  $lNetwork   = long2ip($nwork);

//   print "<p>My IP    : " . $lMyIp . ' - ' . $myip . "</p>\n";
//   print "<p>Broadcast: " . $lBroadcast . ' - ' . $bcast . "</p>\n";
//   print "<p>Netmask  : " . $lNetmask . ' - ' . $nmask . "</p>\n";
//   print "<p>Network  : " . $lNetwork . ' - ' . $nwork . "</p>\n";

  // $start = $nwork + 1;
  // while ( $start < $bcast ) {
  //   print '<p>Probe ' . long2ip($start) . ".</p>\n";
  //   $start++;
  // }

  $lIpAddresses = long2ip($nwork + 1) . '-' . long2ip($bcast-1);

  $ports = '3306,35571,33564';
  $hosts = '';

  ?>
  <form action="index.php" method="post">

  <table border="1" cellpadding="3" cellspacing="0" width="100%">
    <tr>
      <td>Ports to detect:</td>
      <td><input type="text" name="ports" value="<?php print $ports; ?>" /></td>
      <td>3306, 3307</td>
    </tr>
    <tr>
      <td>IPs to detect:</td>
      <td><input type="text" name="ip_addresses" value="<?php echo $lIpAddresses; ?>,192.168.1.42,192.168.1.158" /></td>
      <td>192.168.1.42, 192.168.1.50 - 192.168.1.50</td>
    </tr>
  </table>

  <p><input type="submit" value="Detect" /></p>

  <input type="hidden" name="f" value="detect" />
  <input type="hidden" name="o" value="server" />

  </form>
<?php
}
