<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

$ret = OK;

// print "<pre>"; print_r($aServer); print "</pre>";

print "<h1>Safe Server " . $aServer['name']. "</h1>\n";
try {

  list($ret, $dbh) = openRepositoryDatabase();
  if ( $ret != OK ) {
    // print "<pre>"; var_dump($err, $dbh); print "</pre>";
    throw new Exception($dbh);
  }


  // Check for empty server name
  if ( $aServer['name'] == '' ) {
    $rc = 919;
    $msg = "<p>ERROR: Server name cannot be empty (rc=$rc).</p>\n";
    throw new Exception($msg);
  }

  // Do those checks only when a new server is added
  // todo: in fact it should be rechecked with an edited server!!!
  $err = 0;
  if ( $aServer['server_id'] == 0 ) {
    // todo: this is buggy, we have to expect several servers with same name
    // but there should be only one server with a specific name.
    // Check server name
    list($ret, $aTest) = getServerByName($dbh, $aServer['name']);
    if ( count($aTest) == 0 ) {
      print "<p>Server name does NOT exist yet: <span style='color: green;'><strong>OK</strong></span>.</p>\n";
    }
    else {
      $err++;
      print "<p>Server name ALREADY exists: <span style='color: red;'><strong>ERR</strong></span>.</p>\n";
    }

    // Check ip_address
    list($ret, $aTest) = getServerByIpAddress($dbh, $aServer['default_ip']);
    if ( count($aTest) == 0 ) {
      print "<p>Server IP address does NOT exist yet: <span style='color: green;'><strong>OK</strong></span>.</p>\n";
    }
    else {
      $err++;
      print "<p>Server IP address ALREADY exists: <span style='color: red;'><strong>ERR</strong></span>.</p>\n";
    }
  }

  if ( $err != 0 ) {
    $rc = 918;
    $msg = "<p>ERROR: Please fix server IP or name first (rc=$rc).</p>\n";
    throw new Exception($msg);
  }

  // Only safe if no errors
  // Server add
  if ( $aServer['server_id'] == 0 ) {
    list($ret, $server_id) = addServer($dbh, $aServer);
    if ( $ret == OK ) {
      $aServer['server_id'] = $server_id;
    }
    else {
      $rc = 917;
      $msg = "<p>Adding server failed: $server_id (ret=$ret / rc=$rc).</p>\n";
      throw new Exception($msg);
    }
  }
  // Server edit
  else {

    list($ret, $msg) = setServer($dbh, $aServer);

    if ( $ret != OK ) {
      $rc = 771;
      $msg = "<p>ERROR: " . $msg . " (rc=$rc, ret=$ret).</p>\n";
      throw new Exception($msg);
    }
  }

  closeRepositoryDatabase($dbh);

  ?>
  <p>Server safed successfully.</p>
  <input type="button" value="Continue" onclick="window.location='index.php?f=show&amp;o=server&amp;s=configuration&amp;server_id=<?php print $aServer['server_id']; ?>';" />
  <?php
}
catch (Exception $e) {
  print '<p>' . $e->getMessage() . "</p>\n";
  ?>
  <p>Saving failed. Please fix the problem first.</p>
  <p><input type="button" value="Back" onClick="window.history.back();" /></p>
  <?php
}

?>
