<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

require_once("lib/Check.inc");
require_once("lib/Server.inc");
require_once("lib/Cluster.inc");

// print "<pre>"; print_r($_REQUEST); print "</pre>";

$hServerId = isset($_REQUEST['server_id']) ? intval($_REQUEST['server_id']) : 0;

// Print Submenu
if ( ($hServerId == 0) || ($hSubMenu == 'overview') ) {
  // print overview withou submenu
}
else {

  ?>
  <table width="100%" border="1" cellpadding="3" cellspacing="0">
    <tr>
      <?php
      foreach ( $gMenuStructure['server']['submenu'] as $submenu => $values ) {

        if ( $values['active'] === true ) {
          $url = "index.php?f=show&o=server&s=" . $submenu . "&server_id=" . $hServerId;
          print '<td align="center"><a href="' . $url . '">' . $values['title'] . "</a></td>\n";
        }
      }
      ?>
    </tr>
  </table>
  <?php
}

$aServer = array();

// if function is check_for_safe or safe use REQUEST
// if function is add use defaults
// all other cases use configuration database

if ( ($hFunction == 'safe') || ($hFunction == 'check_for_safe') ) {

  $aServer['server_id']  = isset($_REQUEST['server_id']) ? intval($_REQUEST['server_id']) : 0;
  $aServer['name']       = isset($_REQUEST['name']) ? substr(strval($_REQUEST['name']), 0, 32) : '';
  $aServer['default_ip'] = isset($_REQUEST['default_ip']) ? substr(strval($_REQUEST['default_ip']), 0, 32) : '';
  $aServer['os_user']    = isset($_REQUEST['os_user']) ? substr(strval($_REQUEST['os_user']), 0, 32) : '';
  $aServer['cluster_id'] = isset($_REQUEST['cluster_id']) ? intval($_REQUEST['cluster_id']) : 0;
}
else {
  // Server exists
  if ( $hServerId > 0 ) {
    list($ret, $aServer) = readServerById($hServerId);
  }
  else {
    $aServer = array();
  }
}

// print "<pre>"; print_r($aServer); print "</pre>";

if ( $hFunction == 'show' ) {

  // Set default if non is provided
//   if ( $hSubMenu == '' ) {
//     $hSubMenu = 'overview';
//   }

  if ( $hSubMenu == 'checks' ) {
    include('server.show.checks.php');
  }
  elseif ( $hSubMenu == 'overview' ) {
    include('server.show.overview.php');
  }
  elseif ( $hSubMenu == 'configuration' ) {
    include('server.show.configuration.php');
  }
  elseif ( $hSubMenu == 'autodetect' ) {
    include('server.show.autodetect.php');
  }
  else {
    print "<p>Submenu $hSubMenu does not exist.</p>\n";
  }
}
elseif ( $hFunction == 'add' ) {
  include('server.add.php');
}
elseif ( $hFunction == 'check' ) {
  include('server.check.php');
}
elseif ( $hFunction == 'check_for_safe' ) {
  include('server.check_for_safe.php');
}
elseif ( $hFunction == 'edit' ) {
  include('server.edit.php');
}
elseif ( $hFunction == 'detect' ) {
  include('server.detect.php');
}
elseif ( $hFunction == 'delete' ) {
  include('server.delete.php');
}
elseif ( $hFunction == 'safe' ) {
  include('server.safe.php');
}
elseif ( $hFunction == 'takeover' ) {
  include('server.takeover.php');
}
// test is 'all checks'
elseif ( $hFunction == 'test' ) {
  include('server.test.php');
}
/*elseif ( $hFunction == 'delete' ) {
  include('server.delete.php');
}*/
else {
  $rc = 691;
  print "<p>Function $hFunction is not implemented (rc=$rc).</p>\n";
}

?>
