<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

list($rc, $dbh) = openRepositoryDatabase();

if ( $hFunction == 'add' ) {
  print "<h1>Add new Server</h1>\n";

  $aServer['server_id']  = 0;
  $aServer['name']       = 'server1';
  $aServer['os_user']    = 'root';
  $aServer['default_ip'] = '192.168.1.42';
}
elseif ( $hFunction == 'edit' ) {
  print "<h1>Edit Server " . $aServer['name'] . "</h1>\n";

  if ( $hServerId > 0 ) {
    list($rc, $aServer) = getServerById($dbh, $hServerId);
  }
  else {
    $rc = 676;
    print "<p>Error server_id=$hServerId (rc=$rc).</p>\n";
    exit($rc);
  }
}
else {
  $rc = 677;
  print "<p>Error function=$hFunction (rc=$rc).</p>\n";
  exit($rc);
}

list($rc, $aServers) = getAllServers($dbh);
closeRepositoryDatabase($dbh);

?>

<form action="index.php" method="post">

<table border="0" cellpadding="3" cellspacing="0">
  <tr>
    <th colspan="2"></th>
    <th align="left">Example</th>
  </tr>
  <tr>
    <td>Server name:</td>
    <td><input type="text" name="name" value="<?php print $aServer['name']; ?>" size="40" /></td>
    <td>server1</td>
  </tr>
  <tr>
    <td>Default IP:</td>
    <td><input type="text" name="default_ip" value="<?php print $aServer['default_ip']; ?>" size="40" /></td>
    <td>192.168.1.42</td>
  </tr>
  <tr>
    <td>O/S user:</td>
    <td><input type="text" name="os_user" value="<?php print $aServer['os_user']; ?>" size="40" /></td>
    <td>root</td>
  </tr>
  <?php
    list($rc, $aClusters) = getAllClusters($dbh);
    if ( count($aClusters) > 0 ) {
      ?>
      <tr>
        <td>Cluster:</td>
        <td>
          <?php

          print "<select name='cluster_id'>\n";
          print "<option value='0'>Please choose...</option>\n";
          foreach ( $aClusters as $cluster ) {
            $selected = '';
            if ( $cluster['cluster_id'] == $aServer['cluster_id'] ) {
              $selected = ' selected="selected"';
            }
            print "<option value='" . $cluster['cluster_id'] . "' $selected>" . $cluster['name'] . "</option>\n";
          }
          print "</select>\n";

          ?>
        </td>
        <td></td>
      </tr>
      <?php
    }
  ?>
  <tr>
    <td></td>
    <td>&nbsp;</td>
    <td></td>
  </tr>
  <tr>
    <td></td>
    <td>
      <?php
      if ( $hFunction == 'add' ) {
        ?><input type="submit" value="Add" /><?php
      }
      // Edit
      else {
        ?><input type="submit" value="Safe" /><?php
      }
      ?>
      <input type="button" value="Back" onClick="window.history.back();" />
    </td>
    <td></td>
  </tr>
</table>

<input type="hidden" name="f" value="safe" />
<input type="hidden" name="o" value="server" />
<input type="hidden" name="server_id" value="<?php print $aServer['server_id']; ?>" />

</form>
