<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

?><h1>Detect Server</h1><?php

// print "<pre>"; print_r($_REQUEST); print "</pre>";

$hPorts = isset($_REQUEST['ports']) ? strval($_REQUEST['ports']) : '';
$hIpAddresses = isset($_REQUEST['ip_addresses']) ? strval($_REQUEST['ip_addresses']) : '';

$aPorts = explode(',', $hPorts);
$aHosts = explode(',', $hIpAddresses);

// todo: Also do ranges etc.

$lTimeout   = 3;

// page/replication.show.configuration.php
?><div id="hourglass"><p align="center"><img src='img/hourglass.gif' alt='hourglass' /></p></div><?php

myFlush();

$aCandidates = array();

foreach ( $aHosts as $host ) {
  foreach ( $aPorts as $port ) {

    $fp = @fsockopen($host, $port, $errno, $errstr, $lTimeout);

    if ( ! $fp ) {
      print "<p>$host:$port - $errstr ($errno)</p>\n";
    }
    else {

      $output = '';

      stream_set_timeout($fp, 1);
      while ( ! feof($fp) ) {
        $output .= fgets($fp, 8);
        @fwrite($fp, "\n");
      }
      fclose($fp);

      // remove non printable characters
      $output = preg_replace('/[^[:print:]]/', '', $output);

      if ( preg_match('/mysql/i', $output) ) {
        print '<p>Host ' . $host . ' seems to run MySQL on port ' . $port . ".</p>\n";
        array_push($aCandidates, array('host' => $host, 'port' => $port));
      }
      else {
        print '<p>Host ' . $host . ' seems to run something on port ' . $port . " but it does NOT look like MySQL ($output).</p>\n";
      }
    }

  }   // port loop
}   // host loop

// Filter what we know already!

?>

<h2>Taking over Server</h2>

<form action="index.php" method="post">

<table border="1" cellpadding="3" cellspacing="0">
  <tr>
   <th>Server</th>
   <th>Port</th>
   <th>Database</th>
   <th><!-- <input type="checkbox" name="enable_all" checked="checked" /> --></th>
  </tr>
  <?php
  foreach ( $aCandidates as $candidate ) {
  ?>
  <tr>
   <td><input type="hidden" name="host[]" value="<?php print $candidate['host']; ?>" /><?php print $candidate['host']; ?></td>
   <td><input type="hidden" name="port[]" value="<?php print $candidate['port']; ?>" /><?php print $candidate['port']; ?></td>
   <td><input type="text" name="database[]" value="<?php print $candidate['host'] . ':' . $candidate['port']; ?>" /></td>
   <td><input type="checkbox" name="takeover[]" checked="checked" /></td>
  </tr>
  <?php
  }
  ?>
</table>

<p><input type="submit" value="Takeover" /></p>

<input type="hidden" name="f" value="takeover" />
<input type="hidden" name="o" value="server" />

</form>
