<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

list($rc, $dbh) = openRepositoryDatabase();
list($rc, $aMasterSlaves) = getNodesOfClusterById($dbh, $hNodeId);
list($rc, $aCluster) = getClusterById($dbh, $hNodeId);

// var_dump($aMasterSlaves);

?>

<h2>Status of Master</h2>

<table border="1" cellpadding="3" cellspacing="0" width="50%">
  <tr>
   <th align="left">Role</th>
   <th align="left">Node/Database</th>
   <th align="center">Status</th>
  </tr>
  <?php

  $aMaster = array();

  foreach ( $aMasterSlaves as $values ) {

    // role id 1 = Master
    if ( $values['role_id'] == 1 ) {
      print "<tr>\n";
      print "  <td>Master</td>\n";
      print "  <td>" . $values['name'] . "</td>\n";

      // Node status
      // todo: make sure that this is live data and not from the past!

      $ret = getCheckSummaryById($values['node_id']);
      switch ( $ret ) {
      case 0:
        $color = 'green';
        $msg   = 'OK';
        break;
      case 1:
        $color = 'orange';
        $msg   = 'WRN';
        break;
      case 2:
        $color = 'red';
        $msg   = 'ERR';
        break;
      case 9:
        $color = 'orange';
        $msg   = 'UNK';
        break;
      default:
        $color = 'red';
        $msg   = 'UNK';
      };

      print "  <td align='center'><span style='color:" . $color . ";'><strong>" . $msg . "</strong></span></td>\n";
      print "</tr>\n";
      $aMaster = $values;
    }
  }
  ?>
</table>

<?php

// There should be only ONE Master!

if ( isset($aMaster['node_id']) ) {
  list($rc, $aDatabase) = getDatabaseNodeById($dbh, $aMaster['node_id']);
  list($rc, $aServer) = getServerById($dbh, $aMaster['server_id']);

  list($rc, $mysqli) = openDatabaseConnection($aDatabase['database_user'], $aDatabase['database_user_password'], $aServer['name'], $aDatabase['port']);
  if ( $rc != 0 ) {
    print "Error $mysqli (rc=$rc)";
    exit($rc);
  }

  list($rc, $aVariables) = getAllGlobalVariables($mysqli);
  // var_dump($aVariables);


  $aMasterVariables = array(
    'binlog_cache_size'
  , 'binlog_format'
  , 'binlog_row_image'
  , 'binlog_stmt_cache_size'
  , 'expire_logs_days'
  , 'log_bin'
  , 'log_bin_basename'
  , 'log_bin_index'
  , 'max_binlog_size'
  , 'server_id'
  , 'sync_binlog'
  );

  ?>
  <h3>Variables</h3>

  <table border="1" width="100%" cellpadding="3" cellspacing="0">
    <tr>
      <th align="left">Paramter</th>
      <th align="left">Value</th>
      <th align="center">Status</th>
    </tr>
    <?php
    foreach ( $aMasterVariables as $key ) {

      // Some variable do not exist in older releases:
      // Introduced in 5.6, equivalent earlier would be FULL
      if ( $key == 'binlog_row_image' ) {
        $aVariables[$key] = 'FULL';
      }
      // Introduced in 5.5, set to same size as binlog_cache_size
      if ( $key == 'binlog_stmt_cache_size' ) {
        $aVariables[$key] = $aVariables['binlog_cache_size'];
      }
      // Introduced in 5.6
      // must be picked from my.cnf... :-(
      if ( $key == 'log_bin_basename' ) {
        $aVariables[$key] = '';
      }
      if ( $key == 'log_bin_index' ) {
        $aVariables[$key] = '';
      }

      $status = '';
      $color  = 'black';
      if ( $key == 'binlog_cache_size' ) {
        if ( ($aVariables[$key] < 1024 * 1024) || ($aVariables[$key] > 10 * 1024 * 1024) ) {
          $color = 'orange';
          $status = 'WARN';
        }
      }
      if ( $key == 'binlog_format' ) {
        if ( ($aVariables[$key] != 'ROW') ) {
          $color = 'orange';
          $status = 'WARN';
        }
      }
      if ( $key == 'binlog_stmt_cache_size' ) {
        if ( ($aVariables[$key] < 1024 * 1024) || ($aVariables[$key] > 10 * 1024 * 1024) ) {
          $color = 'orange';
          $status = 'WARN';
        }
      }
      if ( $key == 'expire_logs_days' ) {
        if ( $aVariables[$key] == 0 ) {
          $color = 'orange';
          $status = 'WARN';
        }
      }
      if ( $key == 'log_bin' ) {
        if ( $aVariables[$key] != 'ON' ) {
          $color = 'red';
          $status = 'ERR';
        }
      }
      if ( $key == 'max_binlog_size' ) {
        if ( ($aVariables[$key] < 100 * 1024 * 1024) || ($aVariables[$key] > 1024 * 1024 * 1024) ) {
          $color = 'orange';
          $status = 'WARN';
        }
      }
      if ( $key == 'max_binlog_size' ) {
        if ( ($aVariables[$key] < 100 * 1024 * 1024) || ($aVariables[$key] > 1024 * 1024 * 1024) ) {
          $color = 'orange';
          $status = 'WARN';
        }
      }
      if ( $key == 'server_id' ) {
        if ( $aVariables[$key] == 0 ) {
          $color = 'red';
          $status = 'ERR';
        }
      }
      print "<tr><td>" . $key . "</td>\n";
      print "  <td>" . $aVariables[$key] . "</td>\n";
      print "  <td align='center'><span style='color:" . $color . "';>" . $status . "</span></td>\n";
      print "</tr>\n";
    }
    ?>
  </table>


  <h3>Replication User</h3>

  <p>Users beside root which have the privileges to run a slave (<code>REPLICATION SLAVE</code> or <code>ALL PRIVILEGES</code>):</p>

  <?php

  list($rc, $aUsers) = getReplicationUsers($mysqli);

  print "<ul>\n";
  foreach ( $aUsers as $user ) {
    print "<li>" . $user . "</li>\n";
  }
  print "</ul>\n";
  ?>

  <h3>Binary Log</h3>

  <?php

  list($rc, $aStatus) = getShowMasterStatus($mysqli);

  print "<p>Binary Log File / Postion: " . $aStatus['File'] . ' / ' . $aStatus['Position'] . "</p>\n";

  ?>


  <h3>Filtering on Master</h3>
  <table border="1" cellpadding="3" cellspacing="0" width="50%">
    <tr>
      <?php
        if ( $aStatus['Binlog_Do_DB'] == '' ) {
          $filter = 'none';
        }
        else {
          $filter = $aStatus['Binlog_Do_DB'];
        }
        print "<td>Binlog do DB filter</td><td>" . $filter . "</td>\n";
        print "  </tr>\n";

        if ( $aStatus['Binlog_Ignore_DB'] == '' ) {
          $filter = 'none';
        }
        else {
          $filter = $aStatus['Binlog_Ignore_DB'];
        }
        print "<td>Binlog ignore DB filter</td><td>" . $filter . "</td>\n";
      ?>
    </tr>
  </table>


  <h3>Slave hosts</h3>

  <?php

  list ($rc, $aSlaveHosts) = getSlaveHosts($mysqli);
  closeDatabaseConnection($mysqli);

  if ( count($aSlaveHosts) == 0 ) {
    print "<p>No <code>report_%</code> variables on Slave defined.<p>\n";
  }
  else {

    ?>
    <table border="1" cellpadding="3" cellspacing="0" width="50%">
      <tr>
        <th align="left">Server ID</th>
        <th align="left">Host</th>
        <th align="left">Port</th>
        <th align="left">Master ID</th>
      </tr>
      <?php
      foreach ( $aSlaveHosts as $slave ) {
        print "  <tr>\n";
        print "    <td>" . $slave['Server_id'] . "</td>\n";
        print "    <td>" . $slave['Host'] . "</td>\n";
        print "    <td>" . $slave['Port'] . "</td>\n";
        print "    <td>" . $slave['Master_id'] . "</td>\n";
        print "  </tr>\n";
      }
      ?>
    </table>
    <?php
  }

  closeRepositoryDatabase($dbh);
}
?>


<h2>Status of Slave(s)</h2>

<table border="1" cellpadding="3" cellspacing="0" width="75%">
  <tr>
    <th align="left">Role</th>
    <th align="left">Node/Database</th>
    <th align="center">Status</th>
    <th align="center">Replication</th>
  </tr>
  <?php
  foreach ( $aMasterSlaves as $values ) {

    // role id 2: Slave
    if ( $values['role_id'] == 2 ) {
      print "  <tr>\n";
      print "    <td>Slave</td>\n";
      print "    <td>" . $values['name'] . "</td>\n";


      // Node status
      // todo: make sure that this is live data and not from the past!

      $ret = getCheckSummaryById($values['node_id']);
      switch ( $ret ) {
      case 0:
        $color = 'green';
        $msg   = 'OK';
        break;
      case 1:
        $color = 'orange';
        $msg   = 'WRN';
        break;
      case 2:
        $color = 'red';
        $msg   = 'ERR';
        break;
      case 9:
        $color = 'orange';
        $msg   = 'UNK';
        break;
      default:
        $color = 'red';
        $msg   = 'UNK';
      };

      print "  <td align='center'><span style='color:" . $color . ";'><strong>" . $msg . "</strong></span></td>\n";


      // Replication status

      list($rc, $mysqli) = openDatabaseConnection($values['database_user'], $values['database_user_password'], $values['hostname'], $values['port']);
      if ( $rc != 0 ) {
        $rc = 770;
        print "<p>Open database " . $values['name'] . " failed (rc=$rc).</p>\n";
      }

      list($rc, $aSlaveStatus) = getShowSlaveStatus($mysqli);
      closeDatabaseConnection($mysqli);

      // This is NO Slave yet
      if ( count($aSlaveStatus) == 0 ) {
        $color = 'red';
        $msg   = 'ERR';
      }
      // This is a Slave
      else {

        // Slave is running
        if ( ($aSlaveStatus['Slave_IO_Running'] == 'Yes') && ($aSlaveStatus['Slave_SQL_Running'] == 'Yes') ) {
          $color = 'green';
          $msg   = 'OK';
        }
        // Slave has any problem
        else {
          $color = 'red';
          $msg   = 'ERR';
        }
      }
      print "  <td align='center'><span style='color:" . $color . ";'><strong>" . $msg . "</strong></span></td>\n";
      print "  </tr>\n";
    }
  }
  ?>
</table>

<h3>Variables</h3>

<table border="1" width="100%" cellpadding="3" cellspacing="0">
  <tr>
    <th align="left">Slave</th>
    <th align="left">Paramter</th>
    <th align="left">Value</th>
    <th align="center">Status</th>
  </tr>
  <?php

  foreach ( $aMasterSlaves as $aSlave ) {

    // role id 2: Slave
    if ( $aSlave['role_id'] == 2 ) {

      list($rc, $mysqli) = openDatabaseConnection($aSlave['database_user'], $aSlave['database_user_password'], $aSlave['hostname'], $aSlave['port']);
      if ( $rc != 0 ) {
        print "Error $mysqli (rc=$rc)";
        exit($rc);
      }

      list ($rc, $aVariables) = getAllGlobalVariables($mysqli);

// print "<pre>"; print_r($aVariables); print "</pre>";

      # 'skip_slave_start'
      $aIntVar = array('server_id', 'read_only', 'log_slave_updates', 'auto_increment_increment', 'auto_increment_offset', 'report_host', 'report_port');
      foreach ( $aIntVar as $key ) {
        print "  <tr>\n";
        print "    <td>" . $aSlave['name'] . "</td>\n";
        print "    <td>" . $key . "</td>\n";
        print "    <td>" . $aVariables[$key] . "</td>\n";
        print "    <td></td>\n";
        print "  </tr>\n";
      }
      closeDatabaseConnection($mysqli);
    }
  }
  ?>
</table>

<?php

// todo: show slave status
// status ok, warn
// Check mysql version!

closeRepositoryDatabase($dbh);

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
