<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

?>
<h1>Replication overview</h1>
<?php

list($rc, $dbh) = openRepositoryDatabase();
// Type 1 = Master/Slave
list($rc, $aMS) = getAllClusters($dbh, 1);
// Type 2 = Master/Master
list($rc, $aMM) = getAllClusters($dbh, 2);
$aMasterSlaves = array_merge($aMS, $aMM);
// print "<pre>"; print_r($aMasterSlaves); print "</pre>";
closeRepositoryDatabase($dbh);

if ( count($aMasterSlaves) == 0 ) {
  ?><p>No Replication found yet.</p><?php
}
else {

  ?>
  <table border="1" cellpadding="1" cellspacing="0">
    <tr>
      <th></th>
      <th align="left">Replication name</th>
      <th>Type</th>
    </tr>
  <?php
  foreach ($aMasterSlaves as $name => $values ) {
    ?>
    <tr>
      <td align="center"><a href='index.php?f=edit&amp;o=replication&amp;t=master/slave&amp;cluster_id=<?php echo $values['cluster_id']; ?>'><img src='img/edit.png' alt='Edit' title='Edit Replication' width="8" height="8" /></a></td>
      <td><a href='index.php?f=show&amp;o=replication&amp;s=configuration&amp;cluster_id=<?php echo $values['cluster_id']; ?>'><?php echo $values['name']; ?></a></td>
      <td align='center'>
      <?php
      if ( $values['type'] == 1 ) {
        echo "M/S";
      }
      else {
        echo "M/M";
      }
      ?>
      </td>
    </tr>
    <?php
  }
  ?>
  </table><br />
  <?php
}

?>
<p>	
<input type="button" value="Add Replication" onClick="location.href='index.php?f=add&amp;o=replication'" />
&nbsp;
<input type="button" value="Autodetect Replication" disabled="disabled" />
</p>

<?php

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
