<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

// print "<pre>"; print_r($_REQUEST); print "</pre>";

list($rc, $dbh) = openRepositoryDatabase();
list($rc, $aDatabase) = getNodesOfClusterById($dbh, $hClusterId);
list($rc, $aCluster) = getClusterById($dbh, $hClusterId);

?>

<h2>Operations</h2>

<?php

// ---------------------------------------------------------------------

?>

<h3>Master</h3>

<table border="1" cellpadding="3" cellspacing="0" width="640">
  <tr>
    <th align="left">Database</th>
    <th>Server</th>
    <th>rw/ro</th>
    <th>Node</th>
    <th>Operations</th>
  </tr>
  <?php

  // print "<pre>"; print_r($aDatabase); print "</pre>";
  foreach ( $aDatabase as $node_id => $node ) {

    if ( $node['role_id'] == SLAVE ) {
      continue;
    }

    ?>
    <tr>
      <td><a href='index.php?f=show&amp;o=node&amp;s=configuration&amp;node_id=<?php print $node['node_id']; ?>'><?php print $node['name']; ?></a></td>

      <?php
      list($rc, $aServer) = getServerById($dbh, $node['server_id']);
      if ( count($aServer) == 0 ) { $aServer['name'] = ''; }
			?>
			<td><?php print $aServer['name']; ?></td>

			<?php

			// rw/ro

			$color = 'black';

			// Master is ALWAYS bad if read_only
			// Caution: We check the wrong value here. We check the configuration.
			// Not what is currently set on the server...
			// Role id 1: Master
			if ( ($node['role_id'] == 1) && ($node['read_only'] == 1) ) {
				$color = 'red';
			}
			// Role id 2: Slave
			if ( $node['role_id'] == 2 ) {

				list($rc, $aDatabaseCheck) = getDatabaseCheck($dbh, $node['node_id'], 'mysqld', 'read_only');
				// print "<pre>"; print_r($aDatabaseCheck); print "</pre>";
				$color = '';
				if ( count($aDatabaseCheck) == 0 ) {
					$color = 'orange';
				}
				else {
					if ( $aDatabaseCheck['last_check_status'] == 'ERR' ) {
						$color = 'red';
					}
					else {
						$color = 'green';
					}
				}
			}

			// todo: This is wrong: we want what is set and not what is wanted in configuration?
			if ( $node['read_only'] == 1 ) {
				$val = 'ro';
			}
			else {
				$val = 'rw';
			}

			?>
			<td align="center"><span style="color:<?php print $color; ?>;"><?php print $val; ?></span></td>
			<?php

			// Node status
			// todo: make sure that this is live data and not from the past!

			$ret = getCheckSummaryById($node['node_id']);
			switch ( $ret ) {
			case 0:
				$color = 'green';
				$msg   = 'OK';
				break;
			case 1:
				$color = 'orange';
				$msg   = 'WRN';
				break;
			case 2:
				$color = 'red';
				$msg   = 'ERR';
				break;
			case 9:
				$color = 'orange';
				$msg   = 'UNK';
				break;
			default:
				$color = 'red';
				$msg   = 'UNK';
			};

			?>
			<td align="center"><span style="color:<?php print $color; ?>;"><strong><?php print $msg; ?></strong></span></td>
			<?php

			// Operations

			?>
			<td>
				<select>
					<option value="0">Please choose...</option>
					<option value="1" disabled="disabled" onClick="alert('Not implemented yet.');">Reset Master</option>
				</select>
			</td>
    </tr>
    <?php
  }
  ?>
</table>

<script>

$(function() {

  $( "#hourglass" ).dialog( 'close' );
});

</script>

<?php

list($rc, $aNodes) = getNodesOfClusterById($dbh, $hClusterId);

// ---------------------------------------------------------------------

?>

<h3>Slaves</h3>

<table border="1" cellpadding="3" cellspacing="0" width="640">
  <tr>
    <th align="left">Database</th>
    <th>Server</th>
    <th>rw/ro</th>
    <th>Node</th>
    <th>Replication</th>
    <th>Operations</th>
  </tr>
  <?php

  // print "<pre>"; print_r($aDatabase); print "</pre>";
  foreach ( $aDatabase as $node_id => $node ) {

		// If we have a Master we should be listed here!
    // if ( $node['role_id'] == MASTER ) {
    if ( $node['master_id'] == 0 ) {
      continue;
    }

    ?>
    <tr>
      <td><a href="index.php?f=show&amp;o=node&amp;s=configuration&amp;node_id=<?php print $node['node_id']; ?>"><?php print $node['name']; ?></a></td>
      <?php

      list($rc, $aServer) = getServerById($dbh, $node['server_id']);
      if ( count($aServer) == 0 ) { $aServer['name'] = ''; }
      print "  <td>" . $aServer['name'] . "</td>\n";

      // rw/ro

      $color = 'black';

      // Master is ALWAYS bad if read_only
      // Caution: We check the wrong value here. We check the configuration.
      // Not what is currently set on the server...
      // Role id 1: Master
      if ( ($node['role_id'] == 1) && ($node['read_only'] == 1) ) {
        $color = 'red';
      }
      // Role id 2: Slave
      if ( $node['role_id'] == 2 ) {

        list($rc, $aDatabaseCheck) = getDatabaseCheck($dbh, $node['node_id'], 'mysqld', 'read_only');
        // print "<pre>"; print_r($aDatabaseCheck); print "</pre>";
        $color = '';
        if ( count($aDatabaseCheck) == 0 ) {
          $color = 'orange';
        }
        else {
          if ( $aDatabaseCheck['last_check_status'] == 'ERR' ) {
            $color = 'red';
          }
          else {
            $color = 'green';
          }
        }
      }

      // todo: This is wrong: we want what is set and not what is wanted in configuration?
      if ( $node['read_only'] == 1 ) {
        $val = 'ro';
      }
      else {
        $val = 'rw';
      }

			?>
      <td align="center"><span style="color:<?php print $color; ?>;"><?php print $val; ?></span></td>
      <?php

			// Start/Stop Slave

			// We only need status of Slave for now
			// Role id 2: Slave
			if ( $node['role_id'] == 2 ) {

				list($rc, $mysqli) = openDatabaseConnection($node['database_user'], $node['database_user_password'], $node['hostname'], $node['port']);

				if ( $rc != 0 ) {
					$rc = 996;
					$aSlaveStatus = array();
				}
				else {

					list($rc, $aSlaveStatus) = getShowSlaveStatus($mysqli);
					closeDatabaseConnection($mysqli);
				}
			}

			// Node status
			// todo: make sure that this is live data and not from the past!

			$ret = getCheckSummaryById($node['node_id']);
			switch ( $ret ) {
			case 0:
				$color = 'green';
				$msg   = 'OK';
				break;
			case 1:
				$color = 'orange';
				$msg   = 'WRN';
				break;
			case 2:
				$color = 'red';
				$msg   = 'ERR';
				break;
			case 9:
				$color = 'orange';
				$msg   = 'UNK';
				break;
			default:
				$color = 'red';
				$msg   = 'UNK';
			};

			?>
			<td align="center"><span style="color:<?php print $color; ?>"><strong><?php print $msg; ?></strong></span></td>
			<?php


			// Replication status

			list($rc, $mysqli) = openDatabaseConnection($node['database_user'], $node['database_user_password'], $node['hostname'], $node['port']);
			if ( $rc != 0 ) {
				$rc = 768;
				$aSlaveStatus = array();
			}
			else {
				list($rc, $aSlaveStatus) = getShowSlaveStatus($mysqli);
				closeDatabaseConnection($mysqli);
			}

			// This is NO Slave yet
			if ( count($aSlaveStatus) == 0 ) {
				$color = 'red';
				$msg   = 'ERR';
			}
			// This is a Slave
			else {

				// Slave is running
				if ( ($aSlaveStatus['Slave_IO_Running'] == 'Yes') && ($aSlaveStatus['Slave_SQL_Running'] == 'Yes') ) {
					$color = 'green';
					$msg   = 'OK';
				}
				// Slave has any problem
				else {
					$color = 'red';
					$msg   = 'ERR';
				}
			}
			?>
			<td align="center"><span style="color:<?php print $color; ?>;"><strong><?php print $msg; ?></strong></span></td>
			
			<?php
			
			// Operations
			
			?>
			
			<td>
				<?php

				list($ret, $mysqli) = openDatabaseConnection($node['database_user'], $node['database_user_password'], $node['hostname'], $node['port']);
				if ( $ret != 0 ) {
					print "<p>" . $mysqli . "</p>\n";
					exit($ret);
				}

				list($ret, $aGlobalVariables) = getAllGlobalVariables($mysqli);
				// print "<pre>"; var_dump($aGlobalVariables); print "</pre>";
				// list($ret, $aMasterStatus) = getShowMasterStatus($mysqli);
				// print "<pre>"; var_dump($aMasterStatus); print "</pre>";
				list($ret, $aSlaveStatus) = getShowSlaveStatus($mysqli);
				// print "<pre>"; var_dump($aSlaveStatus); print "</pre>";
				closeDatabaseConnection($mysqli);
				?>
				<select>
					<option value="0">Please choose...</option>

					<?php
					// Never disable this button because even if both threads are set to
					// NO we need to stop slave for CHANGE MASTER command!
					$js = 'window.location="index.php?f=stop&amp;o=slave&amp;node_id=' . $node['node_id'] . '";';
					?>
					<option value="1" onClick='<?php print $js; ?>'>Stop Slave</option>

					<?php
					$disabled = '';
					if ( $aSlaveStatus['Slave_IO_Running'] == 'No' ) {
						$disabled = ' disabled="disabled"';
					}
					$js = 'window.location="index.php?f=stop&amp;o=slave&amp;t=io_thread&amp;node_id=' . $node['node_id'] . '";';
					?>
					<option value="2" <?php print $disabled; ?> onClick='<?php print $js; ?>'>&nbsp;&nbsp;Stop IO Thread</option>

					<?php
					$disabled = '';
					if ( $aSlaveStatus['Slave_SQL_Running'] == 'No' ) {
						$disabled = ' disabled="disabled"';
					}
					$js = 'window.location="index.php?f=stop&amp;o=slave&amp;t=sql_thread&amp;node_id=' . $node['node_id'] . '";';
					?>
					<option value="3" <?php print $disabled; ?> onClick='<?php print $js; ?>'>&nbsp;&nbsp;Stop SQL Thread</option>

					<?php
					$disabled = '';
					if ( ($aSlaveStatus['Slave_IO_Running'] == 'Yes') || ($aSlaveStatus['Slave_IO_Running'] == 'Yes') ) {
						$disabled = ' disabled="disabled"';
					}
					$js = 'window.location="index.php?f=show&amp;o=slave&amp;t=change_master&amp;node_id=' . $node['node_id'] . '";';
					$title = 'Slave can only be rebuilt when stopped.';
					?>
					<option value="4" <?php print $disabled; ?> <?php print $title; ?> onClick='<?php print $js; ?>'>Change Master</option>

					<?php
					$js = 'window.location="index.php?f=skip&amp;o=slave&amp;t=event&amp;node_id=' . $node['node_id'] . '";';
					?>
					<option value="5" onClick='<?php print $js; ?>'>Skip 1 event</option>

					<?php
					$disabled = '';
					if ( ($aSlaveStatus['Slave_IO_Running'] == 'Yes') || ($aSlaveStatus['Slave_IO_Running'] == 'Yes') ) {
						$disabled = ' disabled="disabled"';
					}
					$js = 'window.location="index.php?f=reset&amp;o=slave&amp;node_id=' . $node['node_id'] . '";';
					$title = 'Slave can only be reset when stopped.';
					?>
					<option value="6" <?php print $disabled; ?> onClick='<?php print $js; ?>'>Reset Slave</option>

					<?php
					$disabled = '';
					if ( ($aSlaveStatus['Slave_IO_Running'] == 'Yes') && ($aSlaveStatus['Slave_IO_Running'] == 'Yes') ) {
						$disabled = ' disabled="disabled"';
					}
					$js = 'window.location="index.php?f=start&amp;o=slave&amp;node_id=' . $node['node_id'] . '";';
					?>
					<option value="7" <?php print $disabled; ?> onClick='<?php print $js; ?>'>Start Slave</option>

					<?php
					$disabled = '';
					if ( $aSlaveStatus['Slave_IO_Running'] == 'Yes' ) {
						$disabled = ' disabled="disabled"';
					}
					$js = 'window.location="index.php?f=start&amp;o=slave&amp;t=io_thread&amp;node_id=' . $node['node_id'] . '";';
					?>
					<option value="8" <?php print $disabled; ?> onClick='<?php print $js; ?>'>&nbsp;&nbsp;Start IO Thread</option>

					<?php
					$disabled = '';
					if ( $aSlaveStatus['Slave_SQL_Running'] == 'Yes' ) {
						$disabled = ' disabled="disabled"';
					}
					$js = 'window.location="index.php?f=start&amp;o=slave&amp;t=sql_thread&amp;node_id=' . $node['node_id'] . '";';
					?>
					<option value="9" <?php print $disabled; ?> onClick='<?php print $js; ?>'>&nbsp;&nbsp;Start SQL Thread</option>

					<?php
					// This is not a Slave yet (aSlaveStatus == NULL)
					$disabled = '';
					if ( ($aSlaveStatus['Slave_IO_Running'] == 'Yes') || ($aSlaveStatus['Slave_IO_Running'] == 'Yes') ) {
					}
					if ( count($aSlaveStatus) == 0 ) {
					}
					$js = 'window.location="index.php?f=make&amp;o=slave&amp;node_id=' . $node['node_id'] . '";';
					$js = 'window.location="index.php?f=show&amp;o=slave&amp;t=build&amp;node_id=' . $node['node_id'] . '";';
					$disabled = ' disabled="disabled"';
					$title = 'Slave can only be built when stopped.';
					?>
					<option value="10" <?php print $disabled; ?> onClick='alert("Not implemented yet.");'>&nbsp;&nbsp;Build Slave</option>
				</select> 
			</td>
    </tr>
    <?php
  }
  ?>
</table>

<?php
closeRepositoryDatabase($dbh);

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
