<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

list($rc, $dbh) = openRepositoryDatabase();
list($rc, $aDatabase) = getNodesOfClusterById($dbh, $hClusterId);
list($rc, $aCluster) = getClusterById($dbh, $hClusterId);
list($rc, $aNodes) = getAllDatabaseNodes($dbh);
$aClusterTypes = getClusterTypes();

// print "<pre>"; print_r($aCluster); print "</pre>";
?>

<h2>Configuration of <?php print $aCluster['name']; ?></h2>

<table border="1" width="75%" cellpadding="3" cellspacing="0">
  <tr>
    <td><strong>Cluster name:</strong></td>
    <td><?php print $aCluster['name']; ?></td>
    <td>Master</td>
    <td></td>
  </tr>
  <tr>
    <td><strong>Cluster type:</strong></td>
    <td><?php print $aClusterTypes[$aCluster['type']]; ?></td>
    <td></td>
    <td></td>
  </tr>
  <?php

  list($rc, $aMasterIds) = getMastersOfReplication($dbh, $aCluster['cluster_id']);
  // print "<pre>"; print_r($aMasterIds); print "</pre>";
  list($rc, $aSlaveIds) = getSlavesOfMasterSlaveReplication($dbh, $aCluster['cluster_id']);
  // print "<pre>"; print_r($aSlaveIds); print "</pre>";

	// Print all Masters
  $no = 1;
  foreach ( $aMasterIds as $id ) {
    ?>
    <tr>
      <td><strong>Master<?php if ( count($aMasterIds) > 1 ) { print ' ' . $no; } ?>:</strong></td>
      <td><a href="index.php?f=show&amp;o=node&amp;s=configuration&amp;node_id=<?php print $aNodes[$id]['node_id']; ?>" title="<?php print $aNodes[$id]['name']; ?>"><?php print $aNodes[$id]['name']; ?></a></td>
			<td>
				<?php
				$master_id = $aNodes[$id]['master_id'];
				if ( $master_id > 0 ) {
					print $aNodes[$master_id]['name'];
				}
				else {
					print 'none';
				}
				?>
			</td>
      <td align="center"><a href="index.php?o=replication&amp;f=delete_node&amp;cluster_id=<?php print $aCluster['cluster_id']; ?>&amp;node_id=<?php print $aNodes[$id]['node_id']; ?>"><img src="img/db_remove.png" alt="Del" title="Delete node" /></a></td>
    </tr>
    <?php
    $no++;
  }

	// Print all Slaves
  $no = 1;
  foreach ( $aSlaveIds as $id ) {
    ?>
    <tr>
      <td><strong><?php if ( $no == 1 ) { print "Slaves:"; } ?></strong></td>
      <td><a href="index.php?f=show&amp;o=node&amp;s=configuration&amp;node_id=<?php print $aNodes[$id]['node_id']; ?>" title="<?php print $aNodes[$id]['name']; ?>"><?php print $aNodes[$id]['name']; ?></a></td>
			<td>
				<?php
				$master_id = $aNodes[$id]['master_id'];
				print $aNodes[$master_id]['name'];
				?>
			</td>
      <td align="center"><a href="index.php?o=replication&amp;f=delete_node&amp;cluster_id=<?php print $aCluster['cluster_id']; ?>&amp;node_id=<?php print $aNodes[$id]['node_id']; ?>"><img src="img/db_remove.png" alt="Del" title="Delete node" /></a></td>
   </tr>
    <?php
    $no++;
  }

  ?>
</table>

<!-- for javascript stuff -->
<input type="hidden" id="cluster_id" name="cluster_id" value="<?php print $aCluster['cluster_id']; ?>" />

<p>
<input type="button" value="Edit replication" onclick="location.href='index.php?f=edit&amp;o=replication&amp;cluster_id=<?php print $aCluster['cluster_id']; ?>';" />
&nbsp;
<button id="opener">Delete Replication</button>
</p>

<div id="dialog-confirm" title="Delete replication?">
<p><span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 20px 0;"></span>This replication will be permantely deleted from the repository. Are you sure?</p>
</div>

<script src="js/replication.show.configuration.js"></script>

<?php

closeRepositoryDatabase($dbh);

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
