<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

require_once('lib/Cluster.inc');
require_once('lib/Database.inc');

// http://api.jqueryui.com/dialog/
?>

<link rel="stylesheet" href="css/jquery-ui.css" />
<script src="js/jquery.js"></script>
<script src="js/jquery-ui.js"></script>

<script>

// increase the default animation speed to exaggerate the effect
$.fx.speeds._default = 1000;

$(function() {
  $('#server_id').dialog({
    autoOpen: false
  , show: 'blind'
  });
  $('#server_id_opener').click(function() {
    $('#server_id').dialog('open');
    return false;
  });
});

$(function() {
  $('#binary_log_file').dialog({
    autoOpen: false
  , show: 'blind'
  });
  $('#binary_log_file_opener').click(function() {
    $('#binary_log_file').dialog('open');
    return false;
  });
});

</script>

<?php

// print "<pre>"; print_r($_REQUEST); print "</pre>";

list($ret, $dbh) = openRepositoryDatabase();
list($ret, $aCluster) = getClusterById($dbh, $hClusterId);
// Type 1 = Master/Slave
// list($ret, $aMasterSlaves) = getAllClusters($dbh, 1);
list($ret, $aNodes) = getNodesOfClusterById($dbh, $hClusterId);
// print "<pre>"; print_r($aNodes); print "</pre>";

?>

<h2><?php print $gMenuStructure['database']['submenu']['checks']['title']; ?> for Replication <?php print $aCluster['name']; ?></h2>

<?php
/*
<p>
<input type="button" value="Check Replication" onclick="location.href='index.php?f=test&amp;o=replication&amp;cluster_id=<?php print $hClusterId; ?>';" />
&nbsp;
<input type="button" value="Check Node" onclick="location.href='index.php?f=test&amp;o=node&amp;node_id=<?php print $hNodeId; ?>';" />
</p>
*/

// ---------------------------------------------------------------------

?>
<h3>Master</h3>
<?php

// For finding duplicate server_id
$aServerIds = array();
// For finding equal Auto Increment values
$aAutoIncrement = array();

foreach ( $aNodes as $id => $node ) {

  if ( $node['role_id'] == MASTER ) {

    // print "<pre>"; print_r($node); print "</pre>";
    ?>
    <h4><?php print $node['name']; ?></h4>
    <?php

    list($ret, $mysqli) = openDatabaseConnection($node['database_user'], $node['database_user_password'], $node['hostname'], $node['port']);
    if ( $ret != OK ) {
			$rc = 946;
			$msg = $mysqli . " (rc=$rc).";
			logMessage(LOG_ERR, $msg);
      print "<p>$msg</p>\n";
      exit($rc);
    }

    list($ret, $aGlobalVariables) = getAllGlobalVariables($mysqli);
    // print "<pre>"; print_r($aGlobalVariables); print "</pre>";
    list($ret, $aMasterStatus) = getShowMasterStatus($mysqli);
    // print "<pre>"; print_r($aMasterStatus); print "</pre>";
    list($ret, $aReplicationUsers) = getReplicationUsers($mysqli);
    closeDatabaseConnection($mysqli);

    // Store Auto Increment Information
    $aAutoIncrement[$node['node_id']] = array($aGlobalVariables['auto_increment_offset'], $aGlobalVariables['auto_increment_increment']);
    
    ?>

    <table border="1" cellpadding="3" cellspacing="0">
      <tr>
        <th align="left">Variable</th>
        <th align="left">Value</th>
        <th align="center">Status</th>
        <th align="left">Solution</th>
      </tr>
      <tr>
        <td>Server ID</td>
        <td><?php print $aGlobalVariables['server_id']; ?></td>
        <?php
        if ( ( intval($aGlobalVariables['server_id']) > 0 )
          && ( ! in_array(intval($aGlobalVariables['server_id']), $aServerIds))
					 ) {
					$color = 'green';
					$state = 'OK';
        }
        else {
					$color = 'red';
					$state = 'ERR';
        }
				?>
				<td align="center"><span style="color:<?php print $color; ?>; font-weight:bolder;"><?php print $state; ?></span></td>
        <td>
					<?php
					if ( intval($aGlobalVariables['server_id']) == 0 ) {
						print "Enable unique server ID with <code>server_id = ...</code>";
					}
					if ( in_array(intval($aGlobalVariables['server_id']), $aServerIds) ) {
						print "Server ID must be unique within a Replication Cluster";
					}
					array_push($aServerIds, intval($aGlobalVariables['server_id']));
					?>
        </td>
      </tr>
      <tr>
        <td>Binary Log File / Position</td>
        <td><?php print $aMasterStatus['File'] . ' / ' . $aMasterStatus['Position']; ?></td>
        <?php
        if ( strval($aMasterStatus['File']) != '' ) {
          ?>
          <td align="center"><span style="color:green; font-weight:bolder;">OK</span></td>
          <?php
        }
        else {
          ?>
          <td align="center"><span style="color:red; font-weight:bolder;">ERR</span></td>
          <?php
        }
        ?>
				<td align="left">
					<?php
					if ( strval($aMasterStatus['File']) != '' ) {
						// noop
					}
					else {
						?>
						Enable binary logging with <code>log_bin = ...</code>
						<?php
					}
					?>
				</td>
      </tr>
      <tr>
        <td>Binary Log Do DB Filter</td>
        <?php
        $filter = 'no filter';
        $state  = 'OK';
        $color  = 'green';
        if ( $aMasterStatus['Binlog_Do_DB'] != '' ) {
          $filter = $aMasterStatus['Binlog_Do_DB'];
          $state  = 'WARN';
          $color  = 'orange';
        }
        ?>
        <td><?php print $filter; ?></td>
        <td align='center' style='color:<?php print $color; ?>; font-weight:bolder;'><?php print $state; ?></td>
        <td></td>
      </tr>
      <tr>
        <td>Binary Log Ignorde DB Filter</td>
        <?php
        $filter = 'no filter';
        $state  = 'OK';
        $color  = 'green';
        if ( $aMasterStatus['Binlog_Ignore_DB'] != '' ) {
          $filter = $aMasterStatus['Binlog_Ignore_DB'];
          $state  = 'WARN';
          $color  = 'orange';
        }
        ?>
        <td><?php print $filter; ?></td>
        <td align='center' style='color:<?php print $color; ?>; font-weight:bolder;'><?php print $state; ?></td>
        <td></td>
      </tr>
			<tr>
				<td>Binary Log Format</td>
				<td><?php print $aGlobalVariables['binlog_format']; ?></td>
					<?php
					$state  = 'OK';
					$color  = 'green';
					if ( strval($aGlobalVariables['binlog_format']) == 'ROW' ) {
						$state  = 'OK';
						$color  = 'green';
					}
					else {
						$state  = 'WARN';
						$color  = 'orange';
					}
					?>
				<td align='center' style='color:<?php print $color; ?>; font-weight:bolder;'><?php print $state; ?></td>
					<?php
					?>
				<td>
					<?php
					if ( strval($aGlobalVariables['binlog_format']) != 'ROW' ) {
						print "<code>binlog_format = { MIXED | ROW }</code>";
					}
					?>
				</td>
			</tr>
			<tr>
				<td>Sync Binary Log</td>
				<td><?php print $aGlobalVariables['sync_binlog']; ?></td>
				<?php
				// Always warn!
				$state  = 'WARN';
				$color  = 'orange';
				?>
				<td align='center' style='color:<?php print $color; ?>; font-weight:bolder;'><?php print $state; ?></td>
				<td>Check about <code>sync_binlog = ...</code></td>
			</tr>
			<tr>
				<td valign="top">Replication user</td>
				<td valign="top">
					<?php
					if ( count($aReplicationUsers) == 0 ) {
						print 'none';
					}
					else {
						foreach( $aReplicationUsers as $user ) {
							print $user . '<br />';
						}
					}
					?>
				</td>
				<td align="center" valign="top">
					<?php
					if ( count($aReplicationUsers) == 0 ) {
						$state = 'ERR';
						$color  = 'red';
					}
					else {
						$state = 'OK';
						$color  = 'green';
					}
					?>
					<span style='color:<?php print $color; ?>; font-weight:bolder;'><?php print $state; ?></span>
				</td>
				<td>
					<?php
					if ( count($aReplicationUsers) == 0 ) {
						print "Create a replication user as follows:<br />
						<code>GRANT REPLICATION SLAVE ON *.*<br />TO 'replication'@'%' IDENTIFIED BY 'secret';</code>";
					}
					?>
				</td>
			</tr>
			<tr>
				<td valign="top">Auto Increment Offset / Increment</td>
				<td valign="top"><?php print $aGlobalVariables['auto_increment_offset'] . ' / ' . $aGlobalVariables['auto_increment_increment']; ?></td>
				<td align="center" valign="top">
					<?php
					
					$noOfMasters = 0;
					foreach ( $aNodes as $n ) {
						if ( $n['role_id'] == MASTER ) {
						  $noOfMasters++;
						}
					}
					
					$state = 'OK';
					$color  = 'green';
					// Check all other Offset/Increment
					foreach ( $aAutoIncrement as $id => $aAuto ) {

						// Skip myself
						if ( $id == $node['node_id'] ) {
							continue;
						}

						// everything else matters
						// Offset must be different
						if ( $aGlobalVariables['auto_increment_offset'] == $aAuto[0] ) {
							$state = 'ERR';
							$color  = 'red';
						}
						// Increment must be the same
						if ( $aGlobalVariables['auto_increment_increment'] != $aAuto[1] ) {
							$state = 'ERR';
							$color  = 'red';
						}
						// Increment must not be same number as nodes!
						if ( $aAuto[1] != $noOfMasters ) {
							$state = 'ERR';
							$color  = 'red';
						}
					}
					?>
					<span style='color:<?php print $color; ?>; font-weight:bolder;'><?php print $state; ?></span>
				</td>
				<td>
					<?php
					if ( $state != 'OK' ) {
						print "<code>AUTO_INCREMENT_OFFSET</code> must be different. <code>AUTO_INCREMENT_INCREMENT</code> must be the same. <code>AUTO_INCREMENT_INCREMENT</code> must be $noOfMasters.";
					}
					?>
				</td>
			</tr>
		</table>
		<?php
	}
}

// ---------------------------------------------------------------------

?>
<h3>Slaves</h3>
<?php

foreach ( $aNodes as $id => $node ) {

	// if ( $node['role_id'] == SLAVE ) {
	if ( $node['master_id'] != 0 ) {

    ?>
    <h4><?php print $node['name']; ?></h4>
    <?php

    list($ret, $mysqli) = openDatabaseConnection($node['database_user'], $node['database_user_password'], $node['hostname'], $node['port']);
    if ( $ret != OK ) {
      print "<p>" . $mysqli . "</p>\n";
      exit($ret);
    }

    list($ret, $aGlobalVariables) = getAllGlobalVariables($mysqli);
    // print "<pre>"; var_dump($aGlobalVariables); print "</pre>";
    list($ret, $aSlaveStatus) = getShowSlaveStatus($mysqli);
    // print "<pre>"; var_dump($aSlaveStatus); print "</pre>";
    closeDatabaseConnection($mysqli);

		?>
		<table border="" cellpadding="3" cellspacing="0">
			<tr>
				<th align="left">Status</th>
				<th align="left">Value</th>
				<th>Status</th>
				<th>Solution</th>
			</tr>
			<tr>
				<td>Server ID</td>
				<td><?php print $aGlobalVariables['server_id']; ?></td>
				<td align="center">
					<?php
						if ( ( intval($aGlobalVariables['server_id']) > 0 )
							&& ( ! in_array(intval($aGlobalVariables['server_id']), $aServerIds))
							) {
							$state = 'OK';
							$color = 'green';
						}
						else {
							// If this node is also a MASTER skip the check because
							// it was already done above!
							if ( $node['role_id'] == MASTER ) {
								$state = 'OK';
								$color = 'green';
							}
							else {
								$state = 'ERR';
								$color = 'red';
							}
						}
					?>
					<span style="color:<?php print $color; ?>; font-weight:bolder;"><?php print $state; ?></span>
				</td>
				<td>
					<?php
					if ( intval($aGlobalVariables['server_id']) == 0 ) {
						print "Enable unique server ID with <code>server_id = ...</code>";
					}
					if ( in_array(intval($aGlobalVariables['server_id']), $aServerIds) ) {
						// If this node is also a MASTER skip the check because
						// it was already done above!
						if ( $node['role_id'] == MASTER ) {
							// noop
						}
						else {
							print "Server ID must be unique within a Replication Cluster";
						}
					}
					array_push($aServerIds, intval($aGlobalVariables['server_id']));
					?>
				</td>
			</tr>
			<?php
			// print "<pre>"; print_r($aSlaveStatus); print "</pre>\n";
			$aExclustionList = array(
				'Connect_Retry', 'Relay_Log_File', 'Relay_Log_Pos', 'Relay_Log_Space', 'Master_SSL_Allowed'
			, 'Master_SSL_CA_File', 'Master_SSL_CA_Path', 'Master_SSL_Cert', 'Master_SSL_Cipher', 'Master_SSL_Key'
			, 'Master_SSL_Verify_Server_Cert', 'Seconds_Behind_Master');
			foreach ( $aSlaveStatus as $key => $value ) {

        if ( (! in_array($key, $aExclustionList)) && ($value != '') && ($value != '0') && ($value != 'None') ) {

          $color = 'black';
          if ( (($key == 'Slave_IO_Running') && ($value == 'No'))
            || (($key == 'Slave_SQL_Running') && ($value == 'No'))
            || (($key == 'Last_IO_Error') && ($value != ''))
            || (($key == 'Last_IO_Errno') && ($value != ''))
            || (($key == 'Last_SQL_Error') && ($value != ''))
            || (($key == 'Last_SQL_Errno') && ($value != ''))
             ) {
            $color = 'red';
          }
          if ( (($key == 'Seconds_behind_master') && ($value != '0'))
             ) {
            $color = 'orange';
          }

					?>
					<tr>
						<td><?php print $key; ?></td>
						<td><span style="color:<?php print $color; ?>; font-weight:bolder;"><?php print $value; ?></span></td>
						<td></td>
						<td>
							<?php
							if (($key == 'Slave_IO_Running') && ($value == 'No') 
							 && ($aSlaveStatus['Slave_SQL_Running'] == 'No')) {
								print "Start Slave.";
							}
							if (($key == 'Last_Errno') && ($value == 999)) {
								print "Make Slave with Change Master first.";
							}
							?>
						</td>
					</tr>
					<?php
				}
			}
			?>
			<tr>
				<td>Seconds Behind Master</td>
				<td><?php print $aSlaveStatus['Seconds_Behind_Master']; ?></td>
				<?php
					if ( $aSlaveStatus['Seconds_Behind_Master'] <= 1 ) {
						$color = 'green';
						$state = 'OK';
					}
					elseif ( $aSlaveStatus['Seconds_Behind_Master'] <= 60 ) {
						$color = 'orange';
						$state = 'WARN';
					}
					else {
						$color = 'red';
						$state = 'BAD';
					}
				?>
				<td align="center"><span style="color:<?php print $color; ?>; font-weight:bolder;"><?php print $state; ?></span></td>
				<td></td>
			</tr>
		</table>
		<?php
	}  // This server is a Slave
}

closeRepositoryDatabase($dbh);

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
