<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

require_once('lib/Cluster.inc');

// ---------------------------------------------------------------------
if ( $hType == 'replication' ) {
// ---------------------------------------------------------------------

  $aCluster = array();

  // print "<pre>"; print_r($_REQUEST); print "</pre>\n";

  // Parse parameter
  $aCluster['cluster_id'] = isset($_REQUEST['cluster_id']) ? intval($_REQUEST['cluster_id']) : 0;
  $aCluster['name']       = isset($_REQUEST['name']) ? substr(strval($_REQUEST['name']), 0, 32) : '';
  $aCluster['type']       = isset($_REQUEST['type']) ? intval($_REQUEST['type']) : 0;
  // print "<pre>"; print_r($aCluster); print "</pre>\n";

  $aMasters         = $_REQUEST['master_id'];
  $aSlaves          = $_REQUEST['slave_id'];
  $aSlavesMasterId  = $_REQUEST['slaves_master_id'];

  // logMessage(LOG_DEBUG, print_r($aMasters, true));
  // logMessage(LOG_DEBUG, print_r($aSlaves, true));


  // Remove entries which were not set

  foreach ( $aMasters as $id => $node_id ) {
    if ( $node_id == 0 ) {
      unset($aMasters[$id]);
    }
  }


  // Remove entries which were not set

  foreach ( $aSlaves as $id => $node_id ) {
    if ( $node_id == 0 ) {
      unset($aSlaves[$id]);
      unset($aSlavesMasterId[$id]);
    }
  }


  // Remove masters which were left over (last element)
  if ( ($aCluster['type'] == MASTER_SLAVE) && (count($aMasters) > 1) ) {
    array_pop($aMasters);
  }

  logMessage(LOG_DEBUG, print_r($aMasters, true));
  logMessage(LOG_DEBUG, print_r($aSlaves, true));

  ?><h1>Safe Replication</h1><?php

  list($rc, $dbh) = openRepositoryDatabase();

  list($rc, $a) = getClusterByName($dbh, $aCluster['name']);
  if ( $rc != OK ) {
    $rc = 121;
    $msg = "Error getting cluster name (rc=$rc).";
    logMessage(LOG_ERR, $msg);
    print "<p>$msg</p>\n";
  }

  // Do some checks here

  // Currently only M/S and M/M are allowed.

  if ( ($aCluster['type'] != MASTER_SLAVE) && ($aCluster['type'] != MASTER_MASTER) ) {
    ?><p>Cluster type must be 1 (Master/Slave) or 2 (Master/Master) but is <?php print $aCluster['type']; ?>. I will fix this now for you to <?php print MASTER_SLAVE; ?>...</p><?php
    $aCluster['type'] = MASTER_SLAVE;
  }

  
	// Check if Masters are empty
	if ( count($aMasters) == 0 ) {
		$rc = 193;
		$msg = "No master specified (rc=$rc).";
		logMessage(LOG_ERR, $msg);
		print "<p>$msg</p>\n";
	}

  
	// Check if Slaves are empty
	if ( count($aSlaves) == 0 ) {
		$rc = 194;
		$msg = "No slave specified (rc=$rc).";
		logMessage(LOG_ERR, $msg);
		print "<p>$msg</p>\n";
	}
  

  // Check if Master is already involved somewhere else

  foreach ( $aMasters as $node_id ) {

    $ret = isDatabaseInOtherCluster($dbh, $node_id, $aCluster['cluster_id']);
    if ( $ret === true ) {
      $rc = 120;
      $msg = "Master (node_id=$node_id) is already in use somewhere else. Please check an fix this (rc=$rc).";
      logMessage(LOG_ERR, $msg);
      print "<p>$msg</p>\n";
    }
  }


  // Check if Slave is already involved somewhere else

  foreach ( $aSlaves as $node_id ) {
    $ret = isDatabaseInOtherCluster($dbh, $node_id, $aCluster['cluster_id']);
    if ( $ret === true ) {
      $rc = 122;
      $msg = "Slave (node_id=$node_id) is already in use somewhere else. Please check an fix this (rc=$rc).";
      logMessage(LOG_ERR, $msg);
      print "<p>$msg</p>\n";
    }
  }


  // Check if Slave is also a Master

  foreach ( $aSlaves as $node_id ) {
    if ( in_array($node_id, $aMasters) ) {
      $rc = 954;
      $msg = "Slave cannot be a Master as well (rc=$rc).";
      logMessage(LOG_ERR, $msg);
      print "<p>$msg</p>\n";
    }
  }


  // Check if a Master ist specifed twice
  // todo: maybe this can be done smarter?

  foreach ( $aMasters as $node_id ) {

    $cnt = 0;
    foreach ( $aMasters as $id ) {
      if ( $node_id == $id ) {
        $cnt++;
      }
    }
    if ( $cnt > 1 ) {
      $rc = 953;
      $msg = "Node $id cannot be specified twice as a Master (rc=$rc).";
      logMessage(LOG_ERR, $msg);
      print "<p>$msg</p>\n";
      break;
    }
  }

  // Check if a Slave has not specified a Master
  // or if Slaves Master is not in Master List
  // print "<pre>"; print_r($aSlaves); print "</pre>";
  // print "<pre>"; print_r($aSlavesMasterId); print "</pre>";

  foreach ( $aSlaves as $key => $slave_id ) {
    if ( $aSlavesMasterId[$key] == 0 ) {
      $rc = 949;
      $msg = "Slave " . ($key + 1) . " has no specified Master (rc=$rc).";
      logMessage(LOG_ERR, $msg);
      print "<p>$msg</p>\n";
      continue;
    }
    if ( ! in_array($aSlavesMasterId[$key], $aMasters) ) {
      $rc = 951;
      $msg = "Specified Master for Slave " . ($key + 1) . " was not specifed as Master above (rc=$rc).";
      logMessage(LOG_ERR, $msg);
      print "<p>$msg</p>\n";
    }
  }


	try {

		// We have some errors from checks
		// Stop here

		if ( $rc != OK ) {
			throw new Exception($msg);
		}
  
  
		// We have 2 cased:
		// a) Cluster exists yet -> its a update
		// b) Cluster does not exits --> its a insert

		// Cluster exists
		if ( $aCluster['cluster_id'] != 0 ) {

			// Check if cluster name exits and it is not ours

			if ( (count($a) > 0) && ($a['cluster_id'] != $aCluster['cluster_id']) ) {
				$rc = 127;
				$msg = "Cluster name already exists (rc=$rc).";
				logMessage(LOG_ERR, $msg);
				print "<p>$msg</p>\n";
				throw new Exception($msg);
			}


			// Safe cluster: name, type and change_ts
			$rc = updateCluster($dbh, $aCluster);

			// Delete all Cluster/Node relations in case we want to delete one
			// node from cluster
			list($rc, $cnt) = deleteAllNodesFromCluster($dbh, $aCluster['cluster_id']);
			logMessage(LOG_DEBUG, "deleteAllNodesFromCluster: $cnt nodes deleted.");
		}

		// Cluster is new
		else {

			// Check if cluster name already exits

			if ( count($a) > 0 ) {
				$rc = 129;
				$msg = "Cluster name already exists (rc=$rc).";
				logMessage(LOG_ERR, $msg);
				print "<p>$msg</p>\n";
				throw new Exception($msg);
			}


			// Safe cluster
			list($ret, $lClusterId) = addCluster($dbh, $aCluster);
			if ( $ret == OK ) {
				$aCluster['cluster_id'] = $lClusterId;
			}
			else {
				$rc = 947;
				$msg = "Internal error (rc=$rc).";
				logMessage(LOG_ERR, $msg);
			}
		}


		// Safe master relation
		// 

		foreach ( $aMasters as $key => $node_id ) {

			// It is a Master/Slave replication
			if ( count($aMasters) == 1 ) {
				$master_id = 0;
			}
			// It is a Master/Master replication
			elseif ( count($aMasters) == 2 ) {
			
				// Use the OTHER as Master
				if ( $key == 0 ) {
					$master_id = $aMasters[1];
				}
				elseif ( $key == 1 ) {
					$master_id = $aMasters[0];
				}
				else {
					$rc = 952;
					$msg = "Internal error (rc=$rc).";
					logMessage(LOG_ERR, $msg);
					logMessage(LOG_ERR, print_r($aMasters, true));
				}
			}
			// Other set-ups are currently not supported
			else {
				$rc = 948;
				$msg = "Unsupported set-up (rc=$rc).";
				print "<p>" . $msg . "</p>\n";
				logMessage(LOG_ERR, $msg);
				logMessage(LOG_ERR, print_r($aMasters, true));
			}

			// print "<pre>"; print_r($aMasters); print "</pre>";
			// print "<pre>"; var_dump($master_id); print "</pre>";

			$ret = addMasterToCluster($dbh, $aCluster['cluster_id'], $node_id, $master_id);
			if ( $ret != OK ) {
				logMessage(LOG_ERR, "Adding Master to Cluster failed (ret=$ret).");
			}
		}


		// Safe slave relation

		// There is at least one Slave specified
		// print "<pre>"; print_r($aMasters); print "</pre>\n";
		// print "<pre>"; print_r($aSlaves); print "</pre>\n";
		if ( isset($aSlaves) ) {

			foreach ( $aSlaves as $key => $node_id ) {
				$ret = addSlaveToCluster($dbh, $aCluster['cluster_id'], $node_id, $aSlavesMasterId[$key]);
				if ( $ret != OK ) {
					logMessage(LOG_ERR, "Adding Slave to Cluster failed (ret=$ret).");
				}
			}
		}

		// There is NO Slave specified

		else {

			// This is OK if M/M is specified

			if ( $aCluster['type'] == MASTER_MASTER ) {
				print "<p>No Slave specifed. This is OK for Master/Master Replication.</p>\n";
			}
			// This is NOT OK if M/S is specified
			else {
				print "<p>No Slave specifed. This is NOT OK for Master/Slave Replication. Please fix this later...</p>\n";
			}
		}

		?><p>Replication safed.</p><?php
		?><p><input type="button" value="Continue" onclick="location.href='<?php print "index.php?f=show&amp;o=replication&amp;s=overview"; ?>';" /></p><?php

	}
	catch (Exception $e) {
		?><p><input type="button" value="Back" onclick="window.history.back();"></p><?php
	}
		
	closeRepositoryDatabase($dbh);
}
// ---------------------------------------------------------------------
elseif ( $hType == 'node' )
// ---------------------------------------------------------------------
{
  // Possibly this code is never touched?

  print "<pre>"; print_r($_REQUEST); print "</pre>\n";

  $aNode = array();

  // Parse parameter

  $aCluster['cluster_id'] = isset($_REQUEST['cluster_id']) ? intval($_REQUEST['cluster_id']) : 0;
  $aCluster['type']       = isset($_REQUEST['type']) ? intval($_REQUEST['type']) : 0;

  $aSlave['node_id']      = isset($_REQUEST['node_id']) ? intval($_REQUEST['node_id']) : 0;
  $role                   = isset($_REQUEST['role']) ? substr(strval($_REQUEST['role']), 0, 8) : '';
  if ( $role == 'Slave' ) {
    $aSlave['role_id'] = 2;
  }

  print "Saving node...";

  list($rc, $dbh) = openRepositoryDatabase();
  $rc = addSlaveToCluster($dbh, $aCluster['cluster_id'], $aSlave['node_id'], $aNode['master_id']);
  closeRepositoryDatabase($dbh);
  ?>
  <p><input type="button" value="Continue" onclick="location.href='index.php?f=show&amp;o=replication&amp;s=configuration&amp;cluster_id=<?php print $aCluster['cluster_id']; ?>'" /></p>
  <?php
}
// ---------------------------------------------------------------------
else
// ---------------------------------------------------------------------
{
	print "Unknown type $hType\n";
}

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
