<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

$hFunction  = isset($_REQUEST['f']) ? strval($_REQUEST['f']) : '';
$hClusterId = isset($_REQUEST['cluster_id']) ? intval($_REQUEST['cluster_id']) : 0;

if ( $hFunction == 'add' ) {

  ?><h1>Add new replication</h1><?php

  $aCluster['cluster_id']   = 0;
  $aCluster['name'] = 'Master/Slave Replication';
  $aCluster['type'] = MASTER_SLAVE;
}
elseif ( $hFunction == 'edit' ) {

  if ( $hClusterId > 0 ) {
		list($rc, $aCluster) = getClusterById($dbh, $hClusterId);
	}

  ?><h1>Edit Replication <?php print $aCluster['name']; ?></h1><?php
}
else {
  $rc = 942;
	$msg = "Error (rc=$rc).";
  print "<p>$msg</p>\n";
	logMessage(LOG_ERR, $msg);
  exit($rc);
}

logMessage(LOG_DEBUG, print_r($aCluster, true));

// <script src="js/node.check_for_safe.js"></script>

?>

<script src="js/replication.edit.js"></script>

<form action="index.php" method="post">

<table border="0" cellpadding="3" cellspacing="0">
  <tr>
    <td>Replication name:</td>
    <td><input type="text" name="name" value="<?php print $aCluster['name']; ?>" /></td>
    <td></td>
  </tr>
  <tr>
    <td>Cluster type:</td>
    <td>
      <?php
      $aClusterTypes = getClusterTypes();
      ?>
      <select name="type" id="MasterSlaveType" onchange="myToggle();">
        <?php
        foreach ( $aClusterTypes as $cluster_type_id => $value ) {
          $selected = '';
          if ( $cluster_type_id == $aCluster['type'] ) {
            $selected = 'selected="selected"';
          }
          $disabled = '';
          if ( ($cluster_type_id != MASTER_SLAVE) && ($cluster_type_id != MASTER_MASTER) ) {
            $disabled='disabled="disabled"';
          }
          print '<option value="' . $cluster_type_id . '"' . " $selected $disabled >" . $value . "</option>\n";
        }
        ?>
      </select>
    </td>
    <td></td>
  </tr>
  <tr><td></td><td>&nbsp;</td><td></td></tr>
  <?php

  // Masters

  list($rc, $aNodes) = getAllDatabaseNodes($dbh);
  if ( $hFunction == 'edit' ) {
    list($rc, $aMasterIds) = getMastersOfReplication($dbh, $aCluster['cluster_id']);
    // print "<pre>"; print_r($aMasterIds); print "</pre>";
    list($rc, $aSlaveIds) = getSlavesOfMasterSlaveReplication($dbh, $aCluster['cluster_id']);
    // print "<pre>"; print_r($aSlaveIds); print "</pre>";
  }

  ?>
  <tr>
    <td>Master:</td>
    <td>
      <select name="master_id[]">
        <option value="0">none</option>
        <?php
        foreach ( $aNodes as $node ) {
          $selected = '';
          if ( isset($aMasterIds[0]) && ($node['node_id'] == $aMasterIds[0]) ) {
            $selected = ' selected="selected"';
          }
          ?><option value="<?php print $node['node_id']; ?>" <?php print $selected; ?>><?php print $node['name']; ?></option><?php
        }
        ?>
      </select>
    </td>
    <td></td>
  </tr>

  <tr id="master2">
    <td></td>
    <td>
      <select name="master_id[]">
        <option value="0">none</option>
        <?php
        foreach ( $aNodes as $node ) {
          $selected = '';
          if ( isset($aMasterIds[1]) && ($node['node_id'] == $aMasterIds[1]) ) {
            $selected = ' selected="selected"';
          }
          ?><option value="<?php print $node['node_id']; ?>" <?php print $selected; ?>><?php print $node['name']; ?></option><?php
        }
        ?>
      </select>
    </td>
    <td></td>
  </tr>
  <tr><td></td><td>&nbsp;</td><td></td></tr>

  <?php

  // Slaves

  if ( $gMode == 'demo' ) {
    ?>
    <tr>
      <td>Slaves:</td>
      <td><input type="button" value="autodetect" disabled="disabled" title="For production release only" /></td>
    </tr>
    <td></td>
    <?php
  }

  // Loop over all 2 slaves
  for ( $i = 0; $i <= 2; $i++ ) {
    ?>
    <tr>
      <td><?php if ( $i == 0 ) { print "Slaves:"; } ?></td>
      <td>
        <select name="slave_id[]">
        <option value="0">none</option>
        <?php
        foreach ( $aNodes as $node ) {
          $selected = '';
          if ( isset($aSlaveIds[$i]) && ($node['node_id'] == $aSlaveIds[$i]) ) {
            $selected = ' selected="selected"';
          }
          ?><option value="<?php print $node['node_id']; ?>" <?php print $selected; ?>><?php print $node['name']; ?></option><?php
        }
        ?>
        </select> of Master:
      </td>
      <td>
        <select name="slaves_master_id[]">
        <option value="0">none</option>
        <?php
        foreach ( $aNodes as $node ) {
          $selected = '';
          if ( isset($aSlaveIds[$i]) && ($node['node_id'] == $aNodes[$aSlaveIds[$i]]['master_id']) ) {
            $selected = ' selected="selected"';
          }
          ?><option value="<?php print $node['node_id']; ?>" <?php print $selected; ?>><?php print $node['name']; ?></option><?php
        }
        ?>
        </select>
      </td>
    </tr>
    <?php
  }

  // Navigation

  ?>
  <tr><td></td><td>&nbsp;</td></tr>
  <tr>
    <td></td>
    <td>
    <?php

    if ( $hFunction == 'edit' ) {
      ?><input type="submit" value="Safe" /><?php
    }
    elseif ( $hFunction == 'add' ) {
      ?><input type="submit" value="Create" /><?php
    }

    ?>&nbsp;<input type="button" value="Back" onclick="window.history.back();"></td>
		</td>
    <td></td>
  </tr>
</table>

<?php

// Disable 2nd Master if necessary

if ( $aCluster['type'] == MASTER_SLAVE ) {
  ?>
  <script>
  document.getElementById('master2').style.visibility='hidden';
  </script>
  <?php
}
// MASTER_MASTER
else {
  // do nothing
}
?>

<input type="hidden" name="o" value="replication" />
<input type="hidden" name="f" value="safe" />
<input type="hidden" name="t" value="replication" />
<input type="hidden" name="cluster_id" value="<?php print $aCluster['cluster_id']; ?>" />

</form>

<?php

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
