<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

// print "<pre>"; print_r($_REQUEST); print "</pre>";

$hClusterId = isset($_REQUEST['cluster_id']) ? intval($_REQUEST['cluster_id']) : 0;
$hNodeId    = isset($_REQUEST['node_id']) ? intval($_REQUEST['node_id']) : 0;

list($rc, $dbh) = openRepositoryDatabase();
list ($rc, $aNode) = getDatabaseNodeById($dbh, $hNodeId);

// print "<pre>"; print_r($aNode); print "</pre>";

?><h1>Delete node <?php print $aNode['name']; ?> from Replication</h1><?php

try {

	if ( $aNode['cluster_id'] != $hClusterId ) {
		$msg = "Node does NOT belong to Replication.";
		throw new Exception($msg);
	}


	// If Node is Master check if there are some Slaves attached

	if ( $aNode['role_id'] == MASTER ) {
	
		list($ret, $aSlaveIds) = getSlavesOfMaster($dbh, $aNode['node_id']);
		if ( count($aSlaveIds) > 0 ) {
			$msg = "Node has attached Slaves. Please detache them first.";
			throw new Exception($msg);
		}
	}

	// Everything seems fine

	$aNode['cluster_id'] = 0;
	$aNode['role_id']    = 0;
	$aNode['master_id']  = 0;
	list($rc, $cnt) = setDatabaseNode($dbh, $aNode);
	if ( $rc != OK ) {
		$msg = "Error deleting node from Replication (rc=$rc).";
		throw new Exception($msg);
	}

	print "<p>Node " . $aNode['name'] . " deleted from Replication.</p>\n";
}
catch (Exception $e) {
	logMessage(LOG_ERR, $e->getMessage());
	print "<p>$msg</p>\n";
}

$url = "index.php?o=replication&amp;f=show&amp;s=configuration&amp;cluster_id=" . $hClusterId;
?><p><input type="button" value="Continue" onclick="location.href='<?php print $url; ?>'" /></p><?php

closeRepositoryDatabase($dbh);

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
