<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

?>
<h1>Database overview</h1>
<?php

require_once("lib/Server.inc");

list($rc, $dbh) = openRepositoryDatabase();
list($rc, $aSections) = getAllDatabaseNodes($dbh);
list($rc, $aClusters) = getAllClusters($dbh);
// print "<pre>"; print_r($aSections); print "</pre>";
closeRepositoryDatabase($dbh);

if ( count($aSections) == 0 ) {
  print "<p>No database found yet.</p>\n";
}
else {

  // Print all database nodes
  ?>
  <table border="1" cellpadding="1" cellspacing="0">
    <tr>
      <th></th>
      <th align="left">Database name</th>
      <th align="left">Server</th>
      <th align="left">Servicename/IP address</th>
      <th align="left">Cluster</th>
    </tr>
  <?php
  foreach ( $aSections as $node => $aNode ) {

    list($ret, $aServer) = readServerById($aNode['server_id']);
    // print "<pre>"; print_r($aNode); print "</pre>";
    ?>
    <tr>
      <td align="center"><a href='index.php?f=edit&amp;o=node&amp;node_id=<?php print $aNode['node_id']; ?>'><img src='img/edit.png' alt='Edit' title='Edit Database' width="8" height="8" /></a></td>
      <td align="left"><a href='index.php?f=show&amp;o=node&amp;s=configuration&amp;node_id=<?php print $aNode['node_id']; ?>'><?php print $aNode['name']; ?></a></td>
      <td align="left"><a href="index.php?f=show&amp;o=server&amp;s=configuration&amp;server_id=<?php print $aNode['server_id']; ?>"><?php print $aServer['name']; ?></a></td>
      <td align="left"><?php print $aNode['hostname']; ?></td>
      <td>
				<?php
				if ( isset($aClusters[$aNode['cluster_id']]['name']) ) {
					print $aClusters[$aNode['cluster_id']]['name'];
				}
				else {
					print 'none';
				}
				?>
			</td>
    </tr>
    <?php
  }
  ?>
  </table><br />
  <?php
}

?>
<p>
<input type="button" value="Add Database" onClick="location.href='index.php?f=add&amp;o=node&amp;t=mysqld'" />
&nbsp;
<input type="button" disabled="disabled" value="Autodetect Database" onClick="location.href='index.php?o=server&amp;f=show&amp;s=autodetect'" />
</p>

<?php

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
