<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

// print "<pre>"; print_r($_REQUEST); print "</pre>";

list($rc, $dbh) = openRepositoryDatabase();
list($rc, $aNode) = getDatabaseNodeById($dbh, $hNodeId);

// Get information from repository.checks not from life system!
// This is because if a systems hangs it can take ages until
// we can start operations

list($ret, $aChecks) = getAllDatabaseChecks($dbh, $hNodeId);
// print "<pre>"; print_r($aChecks); print "</pre>";

$lDatabase = 'unknown';
$lReadOnly = 'unknown';
if ( isset($aChecks['database_connect']['last_check_status']) ) {

	if ( $aChecks['database_connect']['last_check_status'] == 'OK' ) {

		$lDatabase = 'started';

		list($ret, $mysqli) = openDatabaseConnection($aNode['database_user'], $aNode['database_user_password'], $aNode['hostname'], $aNode['port']);
		if ( $ret == OK ) {
			list($ret, $msg) = checkDatabaseReadOnly($mysqli, $aNode);
			// ret code does not matter here. msg is correct anyway.
			$lReadOnly = $msg;
			closeDatabaseConnection($mysqli);
		}
	}
	else {
		$lDatabase = 'stopped';
	}
}

closeRepositoryDatabase($dbh);

// print "<pre>"; print_r($aNode); print "</pre>";

?>
<h2><?php print $gMenuStructure['database']['submenu']['operations']['title'] . ' for database ' . $aNode['name']; ?></h2>

<table border="1" cellpadding="3" cellspacing="0">
	<tr>
		<td>Start/stop:</td>
		<td><?php print $lDatabase; ?></td>
	</tr>
	<tr>
		<td>Read_only:</td>
		<td><?php print $lReadOnly; ?></td>
	</tr>
</table>

<p align="left">
<?php

// I was concerned to disable the stop button. But because we do a remote shutdown
// we use the same way to stop the mysqld as we check it. So forcing a stop would
// not at the moment until we have implemented the local shutdown feature to force
// a shutdown.

if ( $lDatabase == 'stopped' ) {
	?>
	<input type="button" value="Start database" onclick="location.href='index.php?f=start&amp;o=node&amp;node_id=<?php print $hNodeId; ?>';" />
	<?php
}
else {
	?>
	<input type="button" value="Stop database" onclick="location.href='index.php?f=stop&amp;o=node&amp;node_id=<?php print $hNodeId; ?>';" />
	<?php
}

if ( $lReadOnly == 'read_write' ) {
	?>
	<input type="button" value="Make read-only" onclick="location.href='index.php?f=make&amp;o=node&amp;t=read-only&amp;node_id=<?php print $hNodeId; ?>';" />
	<?php
}
else {
	?>
	<input type="button" value="Make read-write" onclick="location.href='index.php?f=make&amp;o=node&amp;t=read-write&amp;node_id=<?php print $hNodeId; ?>';" />
	<?php
}

?>
<input type="button" value="Backup database" disabled="disabled" onclick="location.href='index.php?f=backup&amp;o=node&amp;node_id=<?php print $hNodeId; ?>';" />
</p>

<?php
// ---------------------------------------------------------------------
?>
<br />
<h2><?php print $gMenuStructure['database']['submenu']['error_log']['title']; ?></h2>
<?php

list($ret, $aServer) = getServerById($dbh, $aNode['server_id']);


// Get actual MySQL error log directly from the database

list ($ret, $mysqli) = openDatabaseConnection($aNode['database_user'], $aNode['database_user_password'], $aNode['hostname'], $aNode['port']);

$lErrorLog = '';
if ( $ret == OK ) {
  list($ret, $lErrorLog) = getErrorLog($mysqli, $aNode);
  logMessage(LOG_DEBUG, "(rc=$ret), $lErrorLog");
  closeDatabaseConnection($mysqli);
}

// If we cannot get the actual MySQL error log look into repository/configuration
if ( $lErrorLog == '' ) {
  $lErrorLog = $aNode['error_log'];
}

if ( $lErrorLog != '' ) {

  $tail_lines = 20;
  list ($ret, $output) = getTailOfFile($aServer['os_user'], $aServer['name'], $lErrorLog, $tail_lines);
  if ( $ret == OK ) {

    // Color warning and error messages
    $pattern = '/(warning)/i';
    $replacement = '<span style="color:orange; font-weight:bold;">${1}</span>';
    $output = preg_replace($pattern, $replacement, $output);

    $pattern = '/(error)/i';
    $replacement = '<span style="color:red; font-weight:bold;">${1}</span>';
    $output = preg_replace($pattern, $replacement, $output);

    ?><pre style="overflow:auto;" width="80">...<br /><?php print wordwrap($output, 100); ?></pre><?php
  }
  else {
    print "<p>Cannot read error log file $lErrorLog.</p>\n";
  }
}
else {
  print "<p>Cannot get <code>log_error</code> variable.</p>\n";
}

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
