<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

require_once('lib/Server.inc');

list($rc, $aServer) = readServerById($aNode['server_id']);

?>

<h2><?php print $gMenuStructure['database']['submenu']['configuration']['title'] . ' for database ' . $aNode['name']; ?></h2>

<table border="1" cellpadding="3" cellspacing="0">
  <tr><td><strong>Node type:</strong></td><td><?php print $aNode['node_type']; ?></td></tr>
  <tr><td><strong>Database name:</strong></td><td><?php print $aNode['name']; ?></td></tr>
  <tr><td><strong>Server:</strong></td><td><?php print $aServer['name']; ?></td></tr>
  <tr><td><strong>basedir:</strong></td><td><?php print $aNode['basedir']; ?></td></tr>
  <tr><td><strong>datadir:</strong></td><td><?php print $aNode['datadir']; ?></td></tr>
  <tr><td><strong>my.cnf:</strong></td><td><?php print $aNode['my_cnf']; ?></td></tr>
  <tr><td><strong>Servicename/IP address:</strong></td><td><?php print $aNode['hostname']; ?></td></tr>
  <tr><td><strong>port:</strong></td><td><?php print $aNode['port']; ?></td></tr>
  <tr><td><strong>Database user:</strong></td><td><?php print $aNode['database_user']; ?></td></tr>
  <?php

	$password = $aNode['database_user_password'];
  if ( $gMode == 'production' ) {
		$password = str_repeat('*', rand(8, 15));
  }

  ?>
  <tr><td><strong>Database user password:</strong></td><td><?php print $password; ?></td></tr>
  <tr>
    <td><strong>Read only:</strong></td>
    <td>
    <?php
      if ( $aNode['read_only'] == 1 ) {
        $checkbox = ' checked="checked"';
      }
      else {
        $checkbox = '';
      }
    ?>
    <input type="checkbox" <?php print $checkbox; ?> disabled="disabled" name="read_only" /></td>
  </tr>
  <tr>
    <td><strong>Master:</strong></td>
    <td>
      <?php
      if ( $aNode['master_id'] == 0 ) {
        print 'none';
      }
      else {
        list($ret, $a) = getNodesWithFilter($dbh, array('node_id' => $aNode['master_id']));
        $aMaster = array_shift($a);
        print $aMaster['name'];
      }
      ?>
    </td>
  </tr>
</table>

<!-- for javascript stuff -->
<input type="hidden" id="node_id" name="node_id" value="<?php print $aNode['node_id']; ?>" />

<p>
<input type="button" value="Edit database" onclick="location.href='index.php?f=edit&amp;o=node&amp;node_id=<?php print $aNode['node_id']; ?>';" />
&nbsp;
<button id="opener">Delete database</button>
</p>


<div id="dialog-confirm" title="Delete database?">
<p><span class="ui-icon ui-icon-alert" style="float:left; margin:0 7px 20px 0;"></span>This database will be permantely deleted from the repository. Are you sure?</p>
</div>

<script src="js/node.show.configuration.js"></script>

<?php

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
