<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

// print "<pre>"; print_r($aNode); print "</pre>";

?>

<h2><?php print $gMenuStructure['database']['submenu']['checks']['title']; ?> for database <?php print $aNode['name']; ?></h2>

<p><input type="button" value="Check database" onclick="location.href='index.php?f=test&amp;o=node&amp;node_id=<?php print $hNodeId; ?>';" /></p>

<table border="1" width="100%" cellpadding="3" cellspacing="0">
  <tr>
    <th align="left">Last check</th>
    <th align="left">Time</th>
    <th align="left">Time ago</th>
    <th align="left">Status</th>
    <th></th>
  </tr>
  <?php

  // list($rc, $dbh) = openRepositoryDatabase();
  list($ret, $aDatabaseChecks) = getChecksWithFilter($dbh, array('unit_id' => $hNodeId, 'type' => 'mysqld'));
  // print "<pre>"; print_r($aDatabaseChecks); print "</pre>";

  // closeRepositoryDatabase($dbh);

  if ( count($aDatabaseChecks) == 0 ) {
    $rc = 125;
    logMessage(LOG_INFO, "No database checks found for database " . $aNode['name'] . " (rc=$rc).");
  }

  $aNodeCheckTypes = getNodeCheckTypes();
  // print "<pre>"; print_r($aNodeCheckTypes); print "</pre>";
  foreach ( $aNodeCheckTypes as $check ) {

    // Set defaults if check is not known yet
    if ( ! isset($aDatabaseChecks[$check]) ) {
      $aDatabaseChecks[$check]['name']                         = $check;
      $aDatabaseChecks[$check]['node_id']                      = $hNodeId;
      $aDatabaseChecks[$check]['last_check_ts']                = 0;
      $aDatabaseChecks[$check]['last_check_status']            = 'unknown';
      $aDatabaseChecks[$check]['last_successful_check_ts']     = 0;
      $aDatabaseChecks[$check]['last_successful_check_status'] = 'unknown';
    }
    // print "<pre>"; print_r(array($aDatabaseChecks[$check]['last_check_ts'], $aDatabaseChecks[$check]['last_check_status'])); print "</pre>";
    list($ts, $status, $color, $ago) = renderCheck($aDatabaseChecks[$check]['last_check_ts'], $aDatabaseChecks[$check]['last_check_status']);
		// print "<pre>"; print_r(array($ts, $status, $color, $ago)); print "</pre>";
    ?>
    <tr>
      <td>Last <?php print $check; ?> check:</td>
      <td><?php
        if ( $ts == 0 ) {
          print '&nbsp;';
        }
        else {
          print date('Y-m-d H:i:s', $ts);
        }
      ?></td>
      <td><?php
        if ( $ago == 'unknown' ) {
          print '';
        }
        else {
          print $ago;
        }
      ?></td>
      <td align="center"><span style="color:<?php print $color; ?>"><strong><?php print $status; ?></strong></span></td>
      <td align="center"><input type="button" value="Check now" onclick="javascript:location.href='index.php?f=check&amp;o=node&amp;node_id=<?php print $hNodeId; ?>&amp;t=<?php print $check; ?>';" /></td>
    </tr>
    <?php

    if ( $status != 'OK' ) {

      list($ts, $status, $color, $ago) = renderCheck($aDatabaseChecks[$check]['last_successful_check_ts'], $aDatabaseChecks[$check]['last_successful_check_status']);
      ?>
      <tr>
        <td>&nbsp;&nbsp;Last successfull check: </td>
        <td><?php
          if ( $ts == 0 ) {
            print '&nbsp;';
          }
          else {
            print date('Y-m-d H:i:s', $ts);
          }
        ?></td>
      <td><?php
        if ( $ago == 'unknown' ) {
          print '';
        }
        else {
          print $ago;
        }
      ?></td>
        <td align="center"></td>
        <td></td>
      </tr>
      <?php
    }
  }
  ?>
</table>
