<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

require_once("lib/Node.inc");
require_once("lib/Check.inc");
require_once("lib/System.inc");
require_once("lib/Database.inc");

// print "<pre>"; print_r($_REQUEST); print "</pre>";

// Print Submenu
if ( ($hNodeId == 0) || ($hSubMenu == 'overview') ) {
  // print overview withou submenu
}
else {

  ?>
  <table width="100%" border="1" cellpadding="3" cellspacing="0">
    <tr>
      <?php
      foreach ( $gMenuStructure['database']['submenu'] as $submenu => $values ) {

        if ( $values['active'] === true ) {
          $url = "index.php?f=show&o=node&s=" . $submenu . "&node_id=" . $hNodeId;
          print '<td align="center"><a href="' . $url . '">' . $values['title'] . "</a></td>\n";
        }
      }
      ?>
    </tr>
  </table>
  <?php
}

$aNode = array();

// if function is check_for_safe or safe use REQUEST
// if function is add use defaults
// all other cases use configuration database

if ( ($hFunction == 'safe') || ($hFunction == 'check_for_safe') || ($hFunction == 'edit') ) {

  if ( ($hFunction == 'edit') && ($hNodeId > 0) ) {
		list($rc, $aNode) = readNodeById($hNodeId);
  }
  else {

		$aNode['node_id']                = isset($_REQUEST['node_id']) ? intval($_REQUEST['node_id']) : 0;
		$aNode['name']                   = isset($_REQUEST['name']) ? substr(strval($_REQUEST['name']), 0, 64) : '';
		$aNode['status']                 = isset($_REQUEST['status']) ? strval($_REQUEST['status']) : '';
		$aNode['node_type']              = isset($_REQUEST['node_type']) ? substr(strval($_REQUEST['node_type']), 0, 16) : '';
		$aNode['hostname']               = isset($_REQUEST['hostname']) ? substr(strval($_REQUEST['hostname']), 0, 64) : '';
		$aNode['basedir']                = isset($_REQUEST['basedir']) ? substr(strval($_REQUEST['basedir']), 0, 255) : '';
		$aNode['datadir']                = isset($_REQUEST['datadir']) ? substr(strval($_REQUEST['datadir']), 0, 255) : '';
		$aNode['my_cnf']                 = isset($_REQUEST['my_cnf']) ? substr(strval($_REQUEST['my_cnf']), 0, 255) : '';
		$aNode['hostname']               = isset($_REQUEST['hostname']) ? substr(strval($_REQUEST['hostname']),0, 255) : '';
		$aNode['port']                   = isset($_REQUEST['port']) ? intval($_REQUEST['port']) : 3306;
		$aNode['database_user']          = isset($_REQUEST['database_user']) ? substr(strval($_REQUEST['database_user']), 0, 32) : '';
		$aNode['database_user_password'] = isset($_REQUEST['database_user_password']) ? substr(strval($_REQUEST['database_user_password']), 0, 32) : '';
		$aNode['error_log']              = isset($_REQUEST['error_log']) ? strval($_REQUEST['error_log']) : '';
		$aNode['pid_file']               = isset($_REQUEST['pid_file']) ? strval($_REQUEST['pid_file']) : '';
		$aNode['read_only']              = isset($_REQUEST['read_only']) ? strval($_REQUEST['read_only']) : 'off';
		$aNode['server_id']              = isset($_REQUEST['server_id']) ? intval($_REQUEST['server_id']) : 0;
		$aNode['role_id']                = isset($_REQUEST['role_id']) ? intval($_REQUEST['role_id']) : 0;
		$aNode['cluster_id']             = isset($_REQUEST['cluster_id']) ? intval($_REQUEST['cluster_id']) : 0;
    $aNode['master_id']              = isset($_REQUEST['master_id']) ? intval($_REQUEST['master_id']) : 0;

		if ( $aNode['read_only'] == 'on' ) {
			$aNode['read_only'] = 1;
		}
		elseif  ( $aNode['read_only'] == 'off' ) {
			$aNode['read_only'] = 0;
		}
  }
}
else {
  // Node exists
  if ( $hNodeId > 0 ) {
    list($rc, $aNode) = readNodeById($hNodeId);
  }
  else {
    $aNode = array();
  }
}

// print "<pre>"; print_r($aNode); print "</pre>";

if ( $hFunction == 'show' ) {

  // Set default if non is provided
//   if ( $hSubMenu == '' ) {
//     $hSubMenu = 'overview';
//   }

  if ( $hSubMenu == 'operations' ) {
    include('node.show.operations.php');
  }
  elseif ( $hSubMenu == 'configuration' ) {
    include('node.show.configuration.php');
  }
  elseif ( $hSubMenu == 'checks' ) {
    include('node.show.checks.php');
  }
  elseif ( $hSubMenu == 'information' ) {
    include('node.show.information.php');
  }
  elseif ( $hSubMenu == 'replication' ) {
    include('node.show.replication.php');
  }
//   elseif ( $hSubMenu == 'error_log' ) {
//     include('node.show.error_log.php');
//   }
  elseif ( $hSubMenu == 'overview' ) {
    include('node.show.overview.php');
  }
  elseif ( $hSubMenu == 'profiler' ) {
    include('node.show.profile.php');
  }
  elseif ( $hSubMenu == 'monitor' ) {
    include('node.show.monitor.php');
  }
  else {
    $rc = 687;
    print "<p>SubMenu $hSubMenu is not implemented. (rc=$rc)</p>\n";
  }
}
elseif ( $hFunction == 'stop' ) {
  include('node.stop.php');
}
elseif ( $hFunction == 'start' ) {
  include('node.start.php');
}
elseif ( $hFunction == 'make' ) {
  include("node.$hFunction.php");
}
// test is 'all checks'
elseif ( $hFunction == 'test' ) {
  include('node.test.php');
}
elseif ( $hFunction == 'check_for_safe' ) {
  include('node.check_for_safe.php');
}
elseif ( $hFunction == 'check' ) {
  include('node.check.php');
}
elseif ( $hFunction == 'edit' ) {
  include('node.edit.php');
}
elseif ( $hFunction == 'add' ) {
  include('node.add.php');
}
elseif ( $hFunction == 'safe' ) {
  include('node.safe.php');
}
elseif ( $hFunction == 'delete' ) {
  include('node.delete.php');
}
elseif ( $hFunction == 'backup' ) {
  include('node.backup.php');
}
else {
  $rc = 696;
  print "<p>Function $hFunction is not implemented (rc=$rc).</p>\n";
}

?>
