<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

// print "<pre>"; print_r($aNode); print "</pre>";
// print "<pre>"; print_r($_REQUEST); print "</pre>";

if ( $hFunction == 'add' ) {

  print "<h1>Add new database</h1>\n";

  $aNode['node_id']                     = 0;
  $aNode['name']                   = 'mysqld1';
  $aNode['hostname']               = '';
  $aNode['basedir']                = '/usr';
  $aNode['datadir']                = '/var/lib/mysql';
  $aNode['my_cnf']                 = '/etc/my.cnf';
  $aNode['port']                   = '3306';
  $aNode['database_user']          = 'root';
  $aNode['database_user_password'] = 'secret';
  $aNode['node_type']              = 'mysqld';
  $aNode['read_only']              = 0;
  $aNode['status']                 = '';
  $aNode['error_log']              = '';
  $aNode['pid_file']               = '';
  $aNode['server_id']              = 0;
  $aNode['role_id']                = 0;
  $aNode['cluster_id']             = 0;
  $aNode['master_id']              = 0;
}
elseif ( $hFunction == 'edit' ) {

  if ( $hNodeId > 0 ) {
    list($rc, $aNode) = readNodeById($hNodeId);
  }

  print "<h1>Edit node " . $aNode['name'] . "</h1>\n";
}
else {
  $rc = 678;
  print "<p>Error (rc=$rc).</p>\n";
  exit($rc);
}

// print "<pre>"; print_r($aNode); print "</pre>";

list($rc, $aServers) = getAllServers($dbh);

?>

<form action="index.php" method="post">

<table border="1" cellpadding="3" cellspacing="0" width="100%">
  <tr>
    <th colspan="2"></th>
    <th>Example</th>
  </tr>
  <tr>
    <td>Database name:</td>
    <td><input type="text" name="name" value="<?php print $aNode['name']; ?>" size="40" /></td>
    <td>prod_dwh</td>
  </tr>
  <?php
  /*
  <tr>
    <td>Node type:</td>
    <td><input type="text" name="see_below" value="<?php print $aNode['node_type']; ?>" size="40" disabled="enabled" /></td>
    <td>mysqld</td>
  </tr>
  */
  ?>
  <tr>
    <td>Server:</td>
    <td>
      <?php
      if ( count($aServers) > -1 ) {
        ?>
        <select name="server_id" id="server_id" onChange="setHostname();">
          <option value="0">... please choose</option>
          <?php
          foreach ( $aServers as $server ) {
            $selected = '';
            if ( $server['server_id'] == $aNode['server_id'] ) {
              $selected = 'selected="selected"';
            }
            ?>
            <option value="<?php print $server['server_id']; ?>" <?php print $selected; ?>><?php print $server['name']; ?></option>
            <?php
          }
          ?>
        </select>
        <?php
      }
      ?>
    </td>
    <td><code>uname -n</code></td>
  </tr>
  <tr>
    <td>basedir</td>
    <td><input type="text" name="basedir" value="<?php print $aNode['basedir']; ?>" size="40" /></td>
    <td><code>/usr</code></td>
  </tr>
  <tr>
    <td>datadir</td>
    <td><input type="text" name="datadir" value="<?php print $aNode['datadir']; ?>" size="40" /></td>
    <td><code>/var/lib/mysql</code></td>
  </tr>
  <tr>
    <td>my.cnf</td>
    <td><input type="text" name="my_cnf" value="<?php print $aNode['my_cnf']; ?>" size="40" /></td>
    <td><code>/etc/my.cnf</code></td>
  </tr>
  <tr>
    <td>Servicename/IP address</td>
    <td><input type="text" name="hostname" id="hostname" value="<?php print $aNode['hostname']; ?>" /></td>
    <td>192.168.1.42</td>
  </tr>
  <tr>
    <td>port</td>
    <td><input type="text" name="port" value="<?php print $aNode['port']; ?>" maxlength="5" /></td>
    <td>3306</td>
  </tr>
  <tr>
    <td>Database user:</td>
    <td><input type="text" name="database_user" value="<?php print $aNode['database_user']; ?>" size="40" /></td>
    <td>mysql</td>
  </tr>
  <tr>
    <td>Database password user:</td>
    <td><input type="password" name="database_user_password" value="<?php print $aNode['database_user_password']; ?>" size="40" /></td>
    <td></td>
  </tr>
  <tr>
    <td>Read only:</td>
    <?php
      if ( $aNode['read_only'] == 1 ) {
        $checkbox = ' checked="checked"';
      }
      else {
        $checkbox = '';
      }
    ?>
    <td><input type="checkbox" name="read_only" <?php print $checkbox; ?> /></td>
    <td>on / off</td>
  </tr>
  <tr>
    <td></td>
    <td>
      <?php
      if ( $hFunction == 'add' ) {
        ?><input type="submit" value="Add" /><?php
      }
      // Edit
      else {
        ?><input type="submit" value="Safe" /><?php
      }
      // <input type="button" value="Back" onclick="window.location='index.php?f=show&amp;o=node&amp;s=overview'" />
      ?>
      <input type='button' value='Back' onclick='window.history.back();'>
    </td>
    <td></td>
  </tr>
</table>

<input type="hidden" name="o" value="node" />
<input type="hidden" name="f" value="safe" />
<input type="hidden" name="n" value="<?php print $aNode['name']; ?>" />
<input type="hidden" name="node_type" value="<?php print $aNode['node_type']; ?>" />
<input type="hidden" name="node_id" value="<?php print $aNode['node_id']; ?>" />

<input type="hidden" name="role_id" value="<?php print $aNode['role_id']; ?>" />
<input type="hidden" name="master_id" value="<?php print $aNode['master_id']; ?>" />
<input type="hidden" name="cluster_id" value="<?php print $aNode['cluster_id']; ?>" />
<input type="hidden" name="status" value="<?php print $aNode['status']; ?>" />
<input type="hidden" name="error_log" value="<?php print $aNode['error_log']; ?>" />
<input type="hidden" name="pid_file" value="<?php print $aNode['pid_file']; ?>" />

</form>

<script src="js/node.edit.js"></script>

<?php

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
