<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

// print "<pre>"; print_r($aNode); print "</pre>";

// require_once("lib/Server.inc");
// require_once("lib/System.inc");

$rc = OK;

?>
<script src="js/node.check_for_safe.js"></script>

<h1>Checking node <?php print $aNode['name']; ?></h1>

<?php

// Check variables

// Check if server was choosen

if ( $aNode['server_id'] == 0 ) {
  $rc = 488;
  print "<p>Please choose a Server (rc=$rc).</p>\n";
}

// Check if node name already exists for new node

list($ret, $a) = getDatabaseNodeByName($dbh, $aNode['name']);
if ( (count($a) > 0) && ($aNode['node_id'] == 0) ) {
  $rc = 487;
  print "<p>Database node with name " . $aNode['name'] . " already exists (rc=$rc).</p>\n";
}

// Check if node name already exists for other node on edit

list($ret, $a) = getDatabaseNodeByName($dbh, $aNode['name']);
if ( (count($a) > 0) && ($aNode['node_id'] != $a['node_id']) ) {
  $rc = 486;
  print "<p>Other database node with name " . $aNode['name'] . " already exists (rc=$rc).</p>\n";
}

if ( $rc == OK ) {

	?>

	<p>Checking node <?php print $aNode['name']; ?>...</p>


	<?php

	// testNode($dbh, $aNode, false)

	?>

	<div id="test-message"><img src="img/hourglass.gif" alt="hourglass.gif" title="Please wait" /></div>
	<script> document.getElementById("test-message").hidden = true; </script>


	<?php

	if ( $hFunction == 'check_for_safe' ) {

		list($ret, $aServer) = getServerById($dbh, $aNode['server_id']);


		$ro = $aNode['read_only'] == 1 ? 'on' : 'off';

		// If all checks are OK perform safe
		$par = "name=" . $aNode['name']
				 . "&amp;server_id=" . $aNode['server_id']
				 . "&amp;basedir=" . $aNode['basedir']
				 . "&amp;datadir=" . $aNode['datadir']
				 . "&amp;my_cnf=" . $aNode['my_cnf']
				 . "&amp;hostname=" . $aNode['hostname']
				 . "&amp;port=" . $aNode['port']
				 . "&amp;database_user=" . $aNode['database_user']
				 . "&amp;database_user_password=" . $aNode['database_user_password']
				 . "&amp;os_user=" . $aServer['os_user']
				 . "&amp;node_type=" . $aNode['node_type']
				 . "&amp;read_only=" . $ro;
		?>

		<div id="check-for-safe-ok">
		<p>Configuration is OK. Saving it now.</p>
		<p><input type="button" value="Continue" onclick="window.location='index.php?f=safe&amp;o=node&amp;node_id=<?php print $aNode['node_id'] . '&amp;' . $par ; ?>';" /></p>
		</div>
		<script> document.getElementById("check-for-safe-ok").hidden = true; </script>

		<div id="check-for-safe-err">
		<p>Some errors in your configuration were detected.<br />
		Do you want to safe anyway or do you want fix these values?</p>
		<?php
		// todo: node is is empty!
		// print "<pre>"; print_r($aNode); print "</pre>";
		?>
		<p><input type="button" value="Safe" onclick="window.location='index.php?f=safe&amp;o=node&amp;node_id=<?php print $aNode['node_id'] . '&amp;' . $par ; ?>';" />
		<input type="button" value="Fix" onclick="window.location='index.php?f=edit&amp;o=node&amp;node_id=<?php print $aNode['node_id'] . '&amp;' . $par ; ?>';" /></p>
		</div>
		<script> document.getElementById("check-for-safe-err").hidden = true; </script>

		<?php
	}
	elseif ( $hFunction == 'test' ) {
		?><p><input type="button" value="Continue" onclick="javascript:location.href='index.php?f=show&amp;o=node&amp;s=checks&amp;node_id=<?php print $hNodeId; ?>';" /></p><?php
	}

	?>
	<script>

	window.onload = checkNodeForSafe(<?php print $aNode['node_id']; ?>, '<?php print $hFunction; ?>');

	</script>

	<?php

}
// Error in variables check
else {
  print "<p><input type='button' value='Back' onClick='window.history.back();' /></p>\n";
}

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
