<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

list($rc, $dbh) = openRepositoryDatabase();
list($rc, $aServers) = getAllServers($dbh);
list($rc, $aClusters) = getAllClusters($dbh);

// New Load Balancer
if ( $hLoadBalancerId == 0 ) {

  ?><h2>Add new Load Balancer to Cluster</h2><?php

  // Check what is possible or already there and make good guesses/suggestions

  // ./glbd --daemon --round
  // --control 192.168.1.60:4444
  // 192.168.1.60:3306
  // 192.168.1.60:35198 192.168.1.60:35199

  // defaults
  $aLoadBalancer['server_id']       = 0;
  $aLoadBalancer['name']            = 'prod-lb';
  $aLoadBalancer['listen_address']  = '192.168.1.99';
  $aLoadBalancer['listen_port']     = 3306;
  // 1 = Round-robin
  // 2 = Random
  $aLoadBalancer['policy_id']       = 1;
  // 1 = Galera Load Balancer
  // 2 = MySQL Proxy
  // 3 = HA Proxy
  $aLoadBalancer['type_id'] = 1;
  $aLoadBalancer['control_address'] = '192.168.1.99';
  $aLoadBalancer['control_port']    = 4444;
  $aLoadBalancer['cluster_id']      = 0;
}
// Edit VIP
else {

  ?><h2>Edit Load Balancer for Cluster <?php print $aClusters[$aLoadBalancer['cluster_id']]['name']; ?></h2><?php
  // print "<pre>"; print_r($aLoadBalancer); print "</pre>";

  list($rc, $aCluster) = getClusterById($dbh, $aLoadBalancer['cluster_id']);
}

closeRepositoryDatabase($dbh);
?>

<form action="index.php" method="post">

<table border="0" cellpadding="3" cellspacing="0" width="100%">
  <tr><th></th><th></th><th align="left">Example</th></tr>
  <tr>
    <td align="left">Name</td>
    <td><input type="text" name="name" value="<?php print $aLoadBalancer['name']; ?>" /></td>
    <td>prod-lb</td>
  </tr>
  <tr>
    <td align="left">Cluster</td>
    <td>
      <select name="cluster_id">
        <option id="0">Please choose...</option>
        <?php
        foreach ( $aClusters as $cluster ) {
          $selected = '';
          if ( $cluster['cluster_id'] == $aLoadBalancer['cluster_id'] ) {
            $selected = ' selected="selected"';
          }
          print "<option value='" . $cluster['cluster_id'] . "'" . $selected . ">" . $cluster['name'] . "</option>\n";
        }
        ?>
      </select>
    </td>
    <td></td>
  </tr>
  <tr>
    <td align="left">Server</td>
    <td>
      <select name="server_id">
        <option id="0">Please choose...</option>
        <?php
        foreach ( $aServers as $server ) {
          $selected = '';
          if ( $server['server_id'] == $aLoadBalancer['server_id'] ) {
            $selected = ' selected="selected"';
          }
          print "<option value='" . $server['server_id'] . "'" . $selected . ">" . $server['name'] . "</option>\n";
        }
        ?>
      </select>
    </td>
    <td></td>
  </tr>
  <tr>
    <td align="left">Listen address / port:</td>
    <td>
      <input type="text" name="listen_address" value="<?php print $aLoadBalancer['listen_address']; ?>" maxlength="15" size="8" />
      <input type="text" name="listen_port" value="<?php print $aLoadBalancer['listen_port']; ?>" maxlength="15" size="8" />
    </td>
    <td>192.168.1.99 / 3306</td>
  </tr>
  <tr>
    <td align="left">Balancing policy</td>
    <td>
      <select name="policy_id">
        <option id="0">Please choose...</option>
        <?php

        $aPolicy = array(1 => 'Round-robin', 2 => 'Random');

        foreach ( $aPolicy as $policy_id => $policy ) {

          $selected = '';
          if ( $policy_id == $aLoadBalancer['policy_id'] ) {
            $selected = ' selected="selected"';
          }
          print "<option value='" . $$policy_id . "'" . $selected . ">" . $aPolicy[$$policy_id] . "</option>\n";
        }
        ?>
      </select>
    </td>
    <td></td>
  </tr>
  <tr>
    <td align="left">Type</td>
    <td>
      <select name="type_id">
        <option id="0">Please choose...</option>
        <?php

        $aType = array(1 => 'Galera Load Balancer', 2 => 'MySQL Proxy', 3 => 'HA Proxy');

        foreach ( $aType as $type_id => $type ) {

          $selected = '';
          if ( $type_id == $aLoadBalancer['type_id'] ) {
            $selected = ' selected="selected"';
          }
          print "<option value='" . $type_id . "'" . $selected . ">" . $aType[$type_id] . "</option>\n";
        }
        ?>
      </select>
    </td>
    <td></td>
  </tr>
  <tr>
    <td align="left">Control address / port:</td>
    <td>
      <input type="text" name="control_address" value="<?php print $aLoadBalancer['control_address']; ?>" maxlength="15" size="8" />
      <input type="text" name="control_port" value="<?php print $aLoadBalancer['control_port']; ?>" maxlength="15" size="8" />
    </td>
    <td>192.168.1.99 / 4444</td>
  </tr>
  <tr><td></td><td>&nbsp;</td><td></td></tr>
  <tr>
    <td align="center"></td>
    <td>
      <?php
      if ( $hLoadBalancerId == 0 ) {
        ?><input type="submit" value="Add Load Balancer" /><?php
      }
      else {
        ?><input type="submit" value="Safe Load Balancer" /><?php
      }
      ?>
      <input type="button" value="Back" onClick="window.history.back();" /></td>
    <td></td>
  </tr>
</table>

<input type="hidden" name="f" value="safe" />
<input type="hidden" name="o" value="load-balancer" />
<input type="hidden" name="loadbalancer_id" value="<?php print $aLoadBalancer['loadbalancer_id']; ?>" />

</form>
