<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

require_once("lib/Install.inc");
require_once("lib/Repository.inc");

// ---------------------------------------------------------------------
if ( $hFunction == 'install' )
// ---------------------------------------------------------------------
{
  ?>
  <h1>Install system</h1>
  <?php

  // none      - fresh install / no file
  // step_1    - check requirements
  // step_2    - install database structure
  // step_3    - upgrade
  // completed - completed

  do {

		$level = getInstallationLevel();
		$msg = "Installation level: $level.";
		logMessage(LOG_DEBUG, $msg);
		print "<p>$msg</p>\n";

		switch ($level) {
		// -----------------------------------------------------------------
		case 'none':
		// -----------------------------------------------------------------
			// Set next step
			$rc = setInstallationLevel('step_1');
			if ( $rc != OK ) {
				$msg = "Cannot set installation level (rc=$rc).";
				logMessage(LOG_ERR, $msg);
				print "<p>$msg</p>\n";
				exit($rc);
			}
			break;
		// -----------------------------------------------------------------
		case 'step_1':
		// -----------------------------------------------------------------
			?>
			<h2>Check requirements</h2>
			<?php


			// Check for mod_rewrite module

			if ( function_exists('apache_get_modules') && (! in_array('mod_rewrite', apache_get_modules())) ) {
				$msg = "Apache module <code>mod_rewrite</code> is missing.";
				logMessage(LOG_WARNING, $msg);
				print "<p>$msg</p>";
			}


			// Check for encrypted https connection

			if ( ! empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443 ) {
				// noop;
			}
			else {
				?>
				<p>You should use an encrypted https connection only.</p>
				<p>Enable SSL on <a href="https://help.ubuntu.com/12.04/serverguide/httpd.html#https-configuration" target="_blank" title="HTTPS Configuration">Ubuntu</a>.</p>
				<?php
			}


			// var_dump(get_loaded_extensions());

			if ( extension_loaded('mysqli') === false ) {
				print "<p>Extension mysqli is needed.<br />\n";
				print "Please install with:<br />\n";
				print "<pre>yum install php-mysqli</pre></p>\n";
				print "<pre>sudo apt-get install php5-mysql</pre></p>\n";
			}
			else {
				print "<p>Extension mysqli is installed.</p>\n";
			}

			if ( extension_loaded('posix') === false ) {
				print "<p>Extension posix is needed.<br />\n";
				print "Please install with:<br />\n";
				print "<pre>yum install php-posix</pre></p>\n";
				// On Ubunutu it seems to be default installed.
			}
			else {
				print "<p>Extension posix is installed.</p>\n";
			}

			// PDO driver

			if ( ! extension_loaded('PDO') ) {
				print "<p>Extension PDO is needed.<br />\n";
				print "Please install with:<br />\n";
				print "<pre>sudo apt-get install ...</pre></p>\n";
			}
			else {
				print "<p>Extension PDO is installed.</p>\n";
			}

			?>
			<p>Available PDO drivers are:<br />
			print <ul>
			<?php
			$aDriver = PDO::getAvailableDrivers();
			$sqllite_found = false;
			foreach ( $aDriver as $driver ) {
				print "  <li>$driver</li>\n";
				if ( $driver == 'sqlite' ) {
					$sqllite_found = true;
				}
			}
			?>
			</ul></p>
			<?php

			if ( $sqllite_found === false ) {
				print "<p>SQLite driver is missing!<br />\n";
				print "Please install with:<br />\n";
				print "<pre>sudo apt-get install php5-sqlite3</pre></p>\n";
			}

			// O/S packages

			$cmd = 'which lsb_release >/dev/null 2>&1';
			exec($cmd, $lsb, $ret);
			if ( $ret != OK ) {
				?>
				<p>The program <code>lsb_release</code> is missing.<br />
				Please intall with:<br />
				<pre>yum install redhat-lsb-core</pre></p>
				<?php
			}

			// Set next step
			$rc = setInstallationLevel('step_2');
			if ( $rc != OK ) {
				$msg = "Cannot set installation level (rc=$rc).";
				logMessage(LOG_ERR, $msg);
				print "<p>$msg</p>\n";
				exit($rc);
			}
			break;
		// -----------------------------------------------------------------
		case 'step_2':
		// -----------------------------------------------------------------
			?>
			<h2>Install repository database</h2>
			<?php

			print "<p>Create repository database.</p>\n";
			$rc = createRepositoryDatabase();
			if ( $rc != OK ) {
				$msg = "Problem creating repository database (rc=$rc).";
				logMessage(LOG_ERR, $msg);
				print "<p>$msg</p>\n";
				exit($rc);
			}

			print "<p>Repository database successfully created.</p>\n";

			$rc = setInstallationLevel('step_3');
			if ( $rc != OK ) {
				$msg = "Cannot set installation level (rc=$rc).";
				logMessage(LOG_ERR, $msg);
				print "<p>$msg</p>\n";
				exit($rc);
			}
			break;
		// -----------------------------------------------------------------
		case 'step_3':
		// -----------------------------------------------------------------
			?>
			<h2>Upgrade repository database</h2>
			<?php
			
			list($ret, $dbh) = openRepositoryDatabase();
			$ret = upgradeRepositoryDatabase($dbh);
			if ( $ret != OK ) {
				$rc = 933;
				print "<p>Cannot upgrade repository database (rc=$rc).</p>\n";
				exit($rc);
			}
			closeRepositoryDatabase($dbh);

			$rc = setInstallationLevel('completed');
			if ( $rc != OK ) {
				$msg = "Cannot set installation level (rc=$rc).";
				logMessage(LOG_ERR, $msg);
				print "<p>$msg</p>\n";
				exit($rc);
			}
			
			break;
		// -----------------------------------------------------------------
		case 'completed':
		// -----------------------------------------------------------------
			// noop
			break;
		// -----------------------------------------------------------------
		default;
		// -----------------------------------------------------------------
			$rc = 867;
			$msg = "Internal error: Installation level $level does not exist (rc=$rc).";
			logMessage(LOG_ERR, $msg);
			print "<p>$msg</p>\n";
			exit($rc);
		}
		
  } while ( $level != 'completed' );

  ?>
  <p><input type="button" value="Continue" onclick="javascript:location.href='index.php';" /></p>
  <?php
}
// ---------------------------------------------------------------------
else
// ---------------------------------------------------------------------
{
  print "Unkown function $hFunction";
}

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
