<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

?>
<h2>Ssh public key</h2>
<?php

$whoami = whoami();
$home = getHomeDir($whoami);

$aSshPublicKeyFiles = array(
  0 => $home . '/.ssh/id_rsa.pub'
, 1 => $home . '/.ssh/id_dsa.pub'
);

$pk_exists = false;
foreach ( $aSshPublicKeyFiles as $publicKeyFile ) {

  if ( file_exists($publicKeyFile) ) {
    print "Public key file <code>" . $publicKeyFile . "</code> is <span style='color:green;'><strong>OK</strong></span>.<br /><br />\n";
    $pk_exists = true;
    break;
  }
}

// RSA or DSA key exists
if ( $pk_exists === true) {

  if ( is_readable($publicKeyFile) ) {
    $fh = fopen($publicKeyFile, 'r');
    $SshPublicKey = fgets($fh);
    fclose($fh);
    print "Ssh public key is:<br /><pre>" . chunk_split($SshPublicKey, 64) . "</pre>\n";  }
  else {
    print "ERROR: Cannot read key <code>" . $publicKeyFile . "</code><br />\n";
  }
}
else {
  print "No public key found at <code>~/.ssh</code>. To create one <a href='index.php?f=create&o=public_key'>click here</a>.<br />\n";
}

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
