<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

require_once("lib/Repository.inc");

list($ret, $dbh) = openRepositoryDatabase();
list($ret, $lEncryptedLicense) = getEncryptedLicense($dbh);

$aDecryptedLicense = array();
if ( $ret == 0 ) {
  $aDecryptedLicense = decryptLicense(getMocIdentifier($dbh), $lEncryptedLicense);
}

// print "<pre>"; print_r($aDecryptedLicense); print "</pre>";


$lMocIdentifier = getMocIdentifier($dbh);

closeRepositoryDatabase($dbh);

if ( $hFunction == 'show' ) {

  ?>
	<h2>License Key Information</h2>

	<p>Your MySQL Ops Center identifier: <?php print $lMocIdentifier; ?></p>
	<?php

  // License Key is empty, no license key yet
  if ( count($aDecryptedLicense) == 0 ) {
		?><p>No License Key found. Please get a new License Key.</p><?php
  }
  else {

		?><p>MySQL Ops Center <?php
		if ( $aDecryptedLicense['type'] == 'demo' ) {
			print "Demo";
		}
		else {
			print "Production";
		}
		?> License Key for <?php print $aDecryptedLicense['company']; ?>. For:</p>
		<table border="0" cellpadding="3" cellspacing="0">
			<tr><td>normal MySQL nodes:</td><td><?php print $aDecryptedLicense['mysql_nodes']; ?></td></tr>
			<tr><td>MySQL Master nodes:</td><td><?php print $aDecryptedLicense['master_nodes']; ?></td></tr>
			<tr><td>MySQL Slave nodes:</td><td><?php print $aDecryptedLicense['slave_nodes']; ?></td></tr>
			<tr><td>Galera Cluster nodes:</td><td><?php print $aDecryptedLicense['galera_nodes']; ?></td></tr>
		</table>
    <p>License Key expires: <?php print date('Y-m-d', $aDecryptedLicense['expiry_date']); ?></p><?php
  }
  ?>
  <form action="index.php" enctype="multipart/form-data" method="post">

  <p>Upload new License Key: <input type='file' name='file' size="40"><br />
	or<br />
	Add your new License Key here: <input type="text" name="license_key" /><br />
	<input type="submit" value="Upload"></p>

  <input type="hidden" name="o" value="configuration" />
  <input type="hidden" name="f" value="upload" />
  <input type="hidden" name="s" value="license_information" />

  </form>

  <p>Get a <a href="https://support.fromdual.com/admin/public/demo_license_key.php?t=demo&amp;i=<?php print $lMocIdentifier; ?>" target="_blank">new Demo License Key</a> or a <a href="https://support.fromdual.com/admin/public/demo_license_key.php?t=production&amp;i=<?php print $lMocIdentifier; ?>" target="_blank">new Production Lincense</a>.</p>

  <?php
}
elseif ( $hFunction == 'upload' ) {

  $newEncryptedLicense = isset($_REQUEST['license_key']) ? substr(strval($_REQUEST['license_key']), 0, 256) : '';

  ?><h2>Upload new License Key</h2><?php

	// It was a file
  if ( $newEncryptedLicense == '' ) {

		// echo "<pre>"; print_r($_FILES); echo "</pre>\n";

		$lAllowedExtensions = array('license', 'key');
		$e = explode('.', $_FILES['file']['name']);
		$ext = end($e);

		if (($_FILES['file']['type'] == 'application/octet-stream')
		&& ($_FILES['file']['size'] < 256)
		&& in_array($ext, $lAllowedExtensions)
			) {

			if ($_FILES['file']['error'] > 0) {
				echo '<p>Return Code: ' . $_FILES['file']['error'] . "</p>\n";
			}
			else {

				// echo '<p>Upload: ' . $_FILES['file']['name'] . "</p>\n";
				// echo '<p>Type: ' . $_FILES['file']['type'] . "</p>\n";
				// echo '<p>Size: ' . round(($_FILES['file']['size'] / 1024), 3) . " kByte</p>\n";
				// echo '<p>Temp file: ' . $_FILES['file']['tmp_name'] . "</p>\n";

				$tmp_file = 'tmp/' . $_FILES['file']['name'];

				if ( file_exists($tmp_file) ) {
					echo '<p>' . $_FILES['file']['name'] . " already exists.</p>\n";
				}
				else {
					move_uploaded_file($_FILES['file']['tmp_name'], $tmp_file);
					// echo '<p>Stored in: ' . $tmp_file . "</p>\n";

					list($ret, $newEncryptedLicense) = readEncryptLicenseFromFile($tmp_file);
				}

				// Clean-up License Key after it is stored in the database
				unlink($tmp_file);
			}
		}
		else {
			echo "<p>Invalid file.</p>\n";
		}
	}   // File

	// We have a license now:
  if ( $newEncryptedLicense != '' ) {

		$newDecryptedLicense = decryptLicense(getMocIdentifier($dbh), $newEncryptedLicense);

		try {
		
			// License does not match to Ops Center identifier
			if ( (count($newDecryptedLicense) < 8)
				|| ( $newDecryptedLicense['moc_key'] != $lMocIdentifier )
			) {
				$rc = 192;
				$msg = "License key does not match to your MySQL Ops Center installation (rc=$rc).";
				throw new Exception($msg);
			}
		
		
			list($rc, $dbh) = openRepositoryDatabase();

			// Get old license to verify it is not an update of an Demo license
			list($ret, $oldEncryptedLicense) = getEncryptedLicense($dbh);
			$oldDecryptedLicense = array();
			if ( $ret == OK ) {
				$oldDecryptedLicense = decryptLicense(getMocIdentifier($dbh), $oldEncryptedLicense);
			}
			
			// Rule is as follows:
			// If new License Key is a Demo License Key
			// AND old License Key existed do not accept it.
			if ( ($newDecryptedLicense['type'] != 'production')
				&& (count($oldDecryptedLicense) != 0)
				) {
				$rc = 152;
				$msg = "A demo license key was used to overload an old license key (rc=$rc).";
				print "<p>$msg</p>\n";
				logMessage(LOG_WARNING, $msg);
			}
			else {
				list($ret, $msg) = setEncryptedLicense($dbh, $newEncryptedLicense);
				// var_dump($ret, $msg);
				print "<p>License Key updated.</p>\n";
			}
			closeRepositoryDatabase($dbh);

		}
		catch (Exception $e) {
			logMessage(LOG_ERR, $e->getMessage());
			print "<p>" . $e->getMessage() . "</p>\n";
		}
	}

  ?><input type="button" value="Continue" onclick="window.location='index.php';" /><?php
}
else {
  $rc = 697;
  print "<p>Function $hFunction is not implemented (rc=$rc).</p>\n";
}

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
