<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

require_once("lib/Job.inc");

?>
<h2>Jobs</h2>
<?php

list($ret, $aJobs) = getJobsWithFilter($dbh, array());

if ( $ret == OK ) {

  if ( count($aJobs) != 0 ) {

    ?>
    <table border="1" cellpadding="3" cellspacing="0" width="100%">
      <tr>
        <th align="left">Name</th>
        <th align="left">Server</th>
        <th align="left">PID</th>
        <th align="left">Start</th>
        <th align="left">Status</th>
        <th align="right">Interval</th>
        <th align="left">Last check</th>
        <th align="left">End</th>
        <th align="right">Code</th>
        <th align="left">Output</th>
      </tr>
    <?php
    foreach ( $aJobs as $lJobId => $aJob ) {
      ?>
      <tr>
        <td><?php print $aJob['name']; ?></td>
        <td><?php print $aJob['server']; ?></td>
        <td><?php print $aJob['pid']; ?></td>
        <td><?php print date('Y-m-d H:i:s', $aJob['start_ts']); ?></td>
        <td><?php print $aJob['status']; ?></td>
        <td align="right"><?php print $aJob['check_interval']; ?></td>
        <td>
          <?php
          if ( $aJob['last_check_ts'] == 0 ) {
            print '';
          }
          else {
            print date('Y-m-d H:i:s', $aJob['last_check_ts']);
          }
          ?>
        </td>
        <td><?php
          if ( $aJob['end_ts'] == 0 ) {
            print '';
          }
          else {
            print date('Y-m-d H:i:s', $aJob['end_ts']);
          }
        ?></td>
        <td align="right"><?php
          if ( $aJob['end_ts'] == 0 ) {
            print '';
          }
          else {
            print $aJob['error_code'];
          }
        ?></td>
        <td><?php print $aJob['error_message']; ?></td>
      </tr>
      <?php
    }
    ?>
    </table>
    <?php
  }
  else {
    ?><p>No Jobs available.</p><?php
  }
}
else {
  ?><p>Error.</p><?php
}

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
