<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
$gIndention += 2;

?>
<h2>Crontab</h2>
<?php

// include('lib/System.inc');

$whoami = whoami();
$crontab = '';

$lCheckNodesTask = dirname($_SERVER['SCRIPT_FILENAME']) . '/bin/check_nodes.php';

try {
  $output = printCrontabFile();
  
  if ( $output == '' ) {
		print "<p>Crontab for user $whoami is empty.</p>\n";
  }
  else {
		$crontab = implode("\n", $output);
		?>
		<p>Your actual crontab for user <?php print $whoami; ?> is:</p>
		<pre><?php print $crontab . "<br />\n"; ?></pre>
		<?php
  }
}
catch (Exception $e) {
  ?></pre><?php
  if ( preg_match('/no crontab for/', $e->getMessage()) ) {
    print "<p>No crontab for user " . $whoami . " <span style='color:orange;'><strong>WARNING</strong></span></p>\n";
  }
  else {
    $rc = 881;
    print '<p>' . $e->getMessage() . " (rc=$rc)</p>\n";
  }
}

// We do not find task or crontab does not even exist
if ( (findTaskInCrontabFile($lCheckNodesTask) === false)
  || ($crontab == '') ) {
  ?>
  <p>We recommend to add the following job to the crontab:</p>
  <pre>*  *  *  *  *  <?php print $lCheckNodesTask; ?></pre>
  <p><input type='button' value='Add job' onclick="javascript:location.href='index.php?f=add&amp;o=crontab&amp;t=job&amp;n=check_nodes';"/></p>
  <?php
}

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
