<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

require_once("lib/Cluster.inc");

// ---------------------------------------------------------------------
if ( $hFunction == 'show' )
// ---------------------------------------------------------------------
{
?>

<h1>Cluster MM-Cluster 1</h1>

<p>Cluster type: MySQL Master/Master Cluster</p>

<h2>Nodes</h2>

<table>
  <tr>
    <th>Node</th>
    <th>Server</th>
    <th colspan="2">read/write</th>
    <th>Status</th>
    <th>Start/stop</th>
    <th>Role</th>
    <th>log_slave_updates</th>
    <th>AI Increment</th>
    <th>AI Offset</th>
  </tr>
  <tr>
    <td><a href="index.php?f=show&amp;o=node">mysql-5.6.4-1</a></td>
    <td>server 1</td>
    <td>read write</td>
    <td><input type="button" value="read only" /></td>
    <td bgcolor="Green">OK</td>
    <td><input type="button" value="Stop node" /></td>
    <td>write</td>
    <td>log_slave_updates</td>
    <td>2</td>
    <td>1</td>
  </tr>
  <tr>
    <td><a href="index.php?f=show&amp;o=node">mysql-5.6.4-2</a></td>
    <td>server 2</td>
    <td>read only</td>
    <td><input type="button" value="read write" /></td>
    <td bgcolor="Red">ERR</td>
    <td><input type="button" value="Stop node" /></td>
    <td>read</td>
    <td>log_slave_updates</td>
    <td>2</td>
    <td>1</td>
  </tr>
</table>

<h2>Virtual IP (VIP)</h2>

<table>
  <tr><td>VIP 1</td><td>server 1</td><td>192.168.1.2</td><td>UP</td></tr>
</table>

<input type="button" value="Stop VIP" />
<input type="button" value="Start VIP" disabled="disabled" />
<input type="button" value="Failover VIP" />


<h2>Load Balancer</h2>

<p>IP Address: 192.168.1.100</p>

<table>
  <tr>
    <th>Backend</th>
    <th>IP address</th>
    <th>Port</th>
    <th>Load</th>
    <th>Status</th>
  </tr>
  <tr>
    <td>Backend 1</td>
    <td>192.168.1.13</td>
    <td>3306</td>
    <td>1.5</td>
    <td>UP</td>
  </tr>
  <tr>
    <td>Backend 2</td>
    <td>192.168.1.14</td>
    <td>3306</td>
    <td>1.0</td>
    <td>UP</td>
  </tr>
  <tr>
    <td>Backend 3</td>
    <td>192.168.1.15</td>
    <td>3306</td>
    <td>0.5</td>
    <td>DOWN</td>
  </tr>
</table>

<?php
}
// ---------------------------------------------------------------------
elseif ( $hFunction == 'create' )
// ---------------------------------------------------------------------
{
  ?><h1>Create cluster of type <?php print $hType; ?></h1>

  <form action="index.php" method="post">

  <table>
    <tr>
      <td>Cluster name</td>
      <td><input type="text" name="cluster_name" value="test_cluster" /></td>
    </tr>
    <tr>
      <td>Cluster type:</td>
      <td>
        <select name="cluster_type">
          <option value="1">Master/Slave</option>
          <option value="2" disabled="disabled">Master/Master</option>
          <option value="3" disabled="disabled">Galera Cluster</option>
          <option value="4" disabled="disabled">Failover Cluster</option>
          <option value="5" disabled="disabled">MySQL Cluster</option>
        </select>
      </td>
    </tr>
    <?php

    list($rc, $dbh) = openRepositoryDatabase();
    list($rc, $aSections) = getAllDatabaseNodes($dbh);
    closeRepositoryDatabase($dbh);

    ?>
    <tr>
      <td>Master:</td>
      <td>
        <select name="master_node">
          <?php
          foreach ($aSections as $section) {
            print "<option value='$section'>$section</option>";
          }
          ?>
        </select>
      </td>
    </tr>
    <tr>
      <td>Slaves:</td>
      <td><input type="button" value="autodetect" disabled="disabled" title="For production release only" /></td>
    </tr>
    <tr>
      <td>Slaves:</td>
      <td>
        <select name="slave_1">
          <?php
          foreach ($aSections as $section) {
            print "<option value='$section'>$section</option>";
          }
          ?>
        </select>
      </td>
    </tr>
    <tr>
      <td></td>
      <td>
        <select name="slave_2">
          <?php
          foreach ($aSections as $section) {
            print "<option value='$section'>$section</option>";
          }
          ?>
        </select>
      </td>
    </tr>
    <tr>
      <td></td>
      <td>
        <select name="slave_3">
          <?php
          foreach ($aSections as $section) {
            print "<option value='$section'>$section</option>";
          }
          ?>
        </select>
      </td>
    </tr>
    <!-- more for production release only -->
    <tr>
      <td>VIP (optional)</td>
      <td><input type="text" name="vip_1" value="192.168.1.100" /></td>
    </tr>
    <!-- more for production release only -->
    <tr>
      <td></td>
      <td><input type="submit" value="Create" /></td>
    </tr>
  </table>

  <input type="hidden" name="o" value="cluster" />
  <input type="hidden" name="t" value="master/slave" />
  <input type="hidden" name="f" value="safe" />

  </form>
  <?php
}
// ---------------------------------------------------------------------
elseif ( $hFunction == 'check_for_safe' )
// ---------------------------------------------------------------------
{
  print "Funktion $hFunction ...<br />";
  $aCluster = array();
  $aCluster['cluster_name'] = isset($_REQUEST['cluster_name']) ? substr($_REQUEST['cluster_name'], 0, 32) : 'unknown';
  testCluster($aCluster);
}
// ---------------------------------------------------------------------
else
// ---------------------------------------------------------------------
{
  print "Unkown function $hFunction";
}

?>
