<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

/*

  stopVip($aVip)
  startVip($aVip)
  getVipsWithFilter($dbh, $aFilter = array())
  addVip($dbh, $aVip)
  deleteVip($dbh, $pVipId)
  setVip($dbh, $aVip)

*/

// No require/included here!
// require_once('Ssh.inc');

// -------------------------------------------------------------------
function stopVip($aVip)
// -------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $msg = 'OK';

  // Check VIP with ping
  list($ret, $msg) = checkPing($aVip['ip_address']);
  // VIP seems to be stopped yet.
  if ( $ret != 0 ) {
    $rc = 757;
    return array($rc, $msg);
  }

  // Stop VIP old style
  if ( $aVip['ipaddr_type'] == 1 ) {
    $cmd = 'ifconfig ' . $aVip['interface'] . ':' . $aVip['alias'] . ' down';
  }
  // Stop VIP new style
  elseif ( $aVip['ipaddr_type'] == 2 ) {
    $cmd = 'ip addr del ' . $aVip['ip_address'] . ' dev ' . $aVip['interface'];
  }
  // Wrong type
  else {
    $rc = 756;
    return array($rc, 'IP addr type is ' . $aVip['ipaddr_type']);
  }

  // Stop VIP remote

  list($rc, $dbh) = openRepositoryDatabase();
  list($ret, $aServer) = getServerById($dbh, $aVip['location_id']);
  closeRepositoryDatabase($dbh);

  print "<p>Stop VIP remote on server " . $aServer['name'] . "</p>\n";
  list($ret, $msg) = runRemoteCommand($aServer['os_user'], $aServer['name'], $cmd);
  if ( $ret != 0 ) {
    return array($ret, $msg);
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $msg);
}

// -------------------------------------------------------------------
function startVip($aVip)
// -------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $msg = 'OK';

  // Check VIP with ping
  list($ret, $msg) = checkPing($aVip['ip_address']);
  // IP replies. This is should not be an is bad!
  if ( $ret == 0 ) {
    $rc = 767;
    return array($rc, $msg);
  }

  // Start VIP old style
  if ( $aVip['ipaddr_type'] == 1 ) {
    $cmd = 'ifconfig ' . $aVip['interface'] . ':' . $aVip['alias'] . ' ' . $aVip['ip_address'];
  }
  // Start VIP new style
  elseif ( $aVip['ipaddr_type'] == 2 ) {
    $cmd = 'ip addr add ' . $aVip['ip_address'] . ' dev ' . $aVip['interface'];
  }
  // Wrong type
  else {
    $rc = 766;
    return array($rc, 'IP addr type is ' . $aVip['ipaddr_type']);
  }

  // Start VIP remote

  list($rc, $dbh) = openRepositoryDatabase();
  list($ret, $aServer) = getServerById($dbh, $aVip['location_id']);
  closeRepositoryDatabase($dbh);

  print "<p>Start VIP remote on server " . $aServer['name'] . "</p>\n";
  list($ret, $msg) = runRemoteCommand($aServer['os_user'], $aServer['name'], $cmd);
  if ( $ret != 0 ) {
    return array($ret, $msg);
  }


	// Update neighbours' ARP caches

	$cmd = 'arping -q -c 3 -A -I ' . $aVip['interface'] . ' ' . $aVip['ip_address'];

  print "<p>Update ARP caches on server " . $aServer['name'] . "</p>\n";
  list($ret, $msg) = runRemoteCommand($aServer['os_user'], $aServer['name'], $cmd);
  if ( $ret != 0 ) {
    return array($ret, $msg);
  }


  // Check VIP with ping

  list($ret, $msg) = checkPing($aVip['ip_address']);
  // IP does not reply. This is bad!
  if ( $ret != 0 ) {
    return array($ret, $msg);
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $msg);
}

// ---------------------------------------------------------------------
function getVipsWithFilter($dbh, $aFilter = array())
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $aVips = array();

  $sql = "SELECT * FROM vips WHERE 1\n";

  foreach ( $aFilter as $key => $value ) {
    $sql .= "  AND $key = :$key\n";
  }
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  $stmt = $dbh->prepare($sql);

  foreach ( $aFilter as $key => $value ) {
    $stmt->bindValue(":$key", $value);
  }

  try {
    $stmt->execute();

    while ( $result = $stmt->fetch(PDO::FETCH_ASSOC) ) {
      $aVips[$result['ip_address']] = $result;
    }
  }
  catch (PDOException $e) {
    $rc = 753;
    logMessage(LOG_ERR, $e->getMessage() . " (rc=$rc)");
    $aVips = $e->getMessage() . " (rc=$rc)";
  }
  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $aVips);
}

// ---------------------------------------------------------------------
function getVipByIp($dbh, $pIpAddress)
// ---------------------------------------------------------------------
{
  list($rc, $aVips) = getVipsWithFilter($dbh, array('ip_address' => $pIpAddress));
  return array($rc, array_shift($aVips));
}

// ---------------------------------------------------------------------
function getVipById($dbh, $pVipId)
// ---------------------------------------------------------------------
{
  list($rc, $aVips) = getVipsWithFilter($dbh, array('vip_id' => $pVipId));
  return array($rc, array_shift($aVips));
}

// ---------------------------------------------------------------------
function getAllVipsFromCluster($dbh, $pClusterId)
// ---------------------------------------------------------------------
{
  return getVipsWithFilter($dbh, array('cluster_id' => $pClusterId));
}

// ---------------------------------------------------------------------
function addVip($dbh, $aVip)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $vip_id = 0;

  $sql = "INSERT INTO vips ('ip_address', 'name', 'ipaddr_type', 'interface', 'alias', 'primary_id', 'failover_id', 'location_id', 'cluster_id', 'last_change_ts', 'fo_sync_only', 'fo_wait_sync')
VALUES (:ip_address, :name, :ipaddr_type, :interface, :alias, :primary_id, :failover_id, :location_id, :cluster_id, :last_change_ts, :fo_sync_only, :fo_wait_sync)";
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));
  $stmt = $dbh->prepare($sql);

  $stmt->bindValue(':ip_address', $aVip['ip_address']);
  $stmt->bindValue(':name', $aVip['name']);
  $stmt->bindValue(':ipaddr_type', $aVip['ipaddr_type']);
  $stmt->bindValue(':interface', $aVip['interface']);
  $stmt->bindValue(':alias', $aVip['alias']);
  $stmt->bindValue(':primary_id', $aVip['primary_id']);
  $stmt->bindValue(':failover_id', $aVip['failover_id']);
  $stmt->bindValue(':location_id', $aVip['primary_id']);
  $stmt->bindValue(':cluster_id', $aVip['cluster_id']);
  $stmt->bindValue(':last_change_ts', time());
  $stmt->bindValue(':fo_sync_only', $aVip['fo_sync_only']);
  $stmt->bindValue(':fo_wait_sync', $aVip['fo_wait_sync']);

  try {
    $stmt->execute();
    $vip_id =  $dbh->lastInsertId();
		logMessage(LOG_DEBUG, "Row ID: $vip_id");
  }
  catch (PDOException $e) {
    $rc = 934;
    $msg = $e->getMessage() . " (rc=$rc).";
		logMessage(LOG_ERR, $msg);
    print "<p>$msg</p>\n";
    $vip_id = 0;
  }
  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $vip_id);
}

// ---------------------------------------------------------------------
function deleteVip($dbh, $pVipId)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc  = OK;
  $cnt = 0;

  $sql = "DELETE FROM vips WHERE vip_id = :vip_id";
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  $stmt = $dbh->prepare($sql);
  $stmt->bindValue(':vip_id', $pVipId);

  try {
    $stmt->execute();
    $cnt = $stmt->rowCount();
		logMessage(LOG_DEBUG, "Rows deleted: $cnt");
  }
  catch (PDOException $e) {
    $rc = 801;
    $msg = $e->getMessage() . " (rc=$rc).\n";
		logMessage(LOG_ERR, $msg);
    print "<p>$msg</p>\n";
    $cnt = $msg;
  }
  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $cnt);
}

// ---------------------------------------------------------------------
function setVip($dbh, $aVip)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $cnt = 0;

  $sql = "UPDATE vips
   SET ip_address = :ip_address
     , name = :name
     , ipaddr_type = :ipaddr_type
     , interface = :interface
     , alias = :alias
     , primary_id = :primary_id
     , failover_id = :failover_id
     , location_id = :location_id
     , cluster_id  = :cluster_id
     , last_change_ts = :last_change_ts
     , fo_sync_only = :fo_sync_only
     , fo_wait_sync = :fo_wait_sync
 WHERE vip_id = :vip_id";
	logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  $stmt = $dbh->prepare($sql);
  $stmt->bindValue(':vip_id', $aVip['vip_id']);
  $stmt->bindValue(':ip_address', $aVip['ip_address']);
  $stmt->bindValue(':name', $aVip['name']);
  $stmt->bindValue(':ipaddr_type', $aVip['ipaddr_type']);
  $stmt->bindValue(':interface', $aVip['interface']);
  $stmt->bindValue(':alias', $aVip['alias']);
  $stmt->bindValue(':primary_id', $aVip['primary_id']);
  $stmt->bindValue(':failover_id', $aVip['failover_id']);
  $stmt->bindValue(':location_id', $aVip['location_id']);
  $stmt->bindValue(':cluster_id', $aVip['cluster_id']);
  $stmt->bindValue(':last_change_ts', time());
  $stmt->bindValue(':fo_sync_only', $aVip['fo_sync_only']);
  $stmt->bindValue(':fo_wait_sync', $aVip['fo_wait_sync']);

  try {
    $stmt->execute();
    $cnt = $stmt->rowCount();
		logMessage(LOG_DEBUG, "Rows updated: $cnt");
  }
  catch (PDOException $e) {
    $rc = 935;
    $msg = $e->getMessage() . " (rc=$rc).";
		logMessage(LOG_ERR, $msg);
		print "<p>$msg</p>\n";
		$cnt = $msg;
  }
  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $cnt);
}

?>
