<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

/*

  setUser($dbh, $aUser)
  getUsersWithFilter($dbh, $aFilter = array())
  userExists($dbh, $pLoginName, $pPasswordHash)
  getUser($dbh, $pUserId)
  getUserByLoginName($dbh, $pLoginName)
  getAllUsers($dbh)
  setPassword($dbh, $pUserId, $pPassword)
  deleteUser($dbh, $pUserId)

*/

// No require/included here!

// ---------------------------------------------------------------------
function setUser($dbh, $aUser)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $sql = "UPDATE users
   SET login_name    = :login_name
     , email_address = :email_address
     , first_name    = :first_name
     , last_name     = :last_name
     , mobile        = :mobile
     , role_id       = :role_id
 WHERE user_id = :user_id";
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  $stmt = $dbh->prepare($sql);

  $stmt->bindValue(':user_id', $aUser['user_id']);
  $stmt->bindValue(':login_name', $aUser['login_name']);
  $stmt->bindValue(':email_address', $aUser['email_address']);
  $stmt->bindValue(':first_name', $aUser['first_name']);
  $stmt->bindValue(':last_name', $aUser['last_name']);
  $stmt->bindValue(':mobile', $aUser['mobile']);
  $stmt->bindValue(':role_id', $aUser['role_id']);

  try {
    $stmt->execute();
    $cnt = $stmt->rowCount();
  }
  catch (PDOException $e) {
    $rc = 894;
    return $rc;
  }

  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return $rc;
}

// ---------------------------------------------------------------------
function getUsersWithFilter($dbh, $aFilter = array())
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $aUsers = array();

  $sql = "SELECT * FROM users WHERE 1\n";

  foreach ( $aFilter as $key => $value ) {
    $sql .= "  AND $key = :$key\n";
  }
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  $stmt = $dbh->prepare($sql);

  foreach ( $aFilter as $key => $value ) {
    $stmt->bindValue(":$key", $value);
  }

  try {
    $stmt->execute();

    while ( $result = $stmt->fetch(PDO::FETCH_ASSOC) ) {
      $aUsers[$result['user_id']] = $result;
    }
  }
  catch (PDOException $e) {
    $rc = 752;
    logMessage(LOG_ALERT, $e->getMessage() . " (rc=$rc)");
    $aUsers = $e->getMessage() . " (rc=$rc)";
  }
  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
	return array($rc, $aUsers);
}

// ---------------------------------------------------------------------
function userExists($dbh, $pLoginName, $pPasswordHash)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc  = OK;
  $ret = true;

  list($rc, $aUsers) = getUsersWithFilter($dbh, array('login_name' => $pLoginName, 'password_hash' => $pPasswordHash));
  if ( count($aUsers) == 1 ) {
		$ret = true;
  }
  else {
		$ret = false;
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $ret);
}

// ---------------------------------------------------------------------
function getUser($dbh, $pUserId)
// ---------------------------------------------------------------------
{
  list($rc, $aUsers) = getUsersWithFilter($dbh, array('user_id' => $pUserId));
  return array($rc, array_shift($aUsers));
}

// ---------------------------------------------------------------------
function getUserByLoginName($dbh, $pLoginName)
// ---------------------------------------------------------------------
{
  list($rc, $aUsers) = getUsersWithFilter($dbh, array('login_name' => $pLoginName));
  return array($rc, array_shift($aUsers));
}

// ---------------------------------------------------------------------
function getAllUsers($dbh)
// ---------------------------------------------------------------------
{
  return getUsersWithFilter($dbh, array());
}

// ---------------------------------------------------------------------
function setPassword($dbh, $pUserId, $pPassword)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $sql = "UPDATE users
   SET password_hash = :password_hash
 WHERE user_id = :user_id";
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  $stmt = $dbh->prepare($sql);

  $stmt->bindValue(':user_id', $pUserId);
  $stmt->bindValue(':password_hash', md5($pPassword));

  try {
    $stmt->execute();
    $cnt = $stmt->rowCount();
  }
  catch (PDOException $e) {
    $rc = 899;
    return $rc;
  }

  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return $rc;
}

// ---------------------------------------------------------------------
function deleteUser($dbh, $pUserId)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $sql = "DELETE FROM users WHERE user_id = :user_id";
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  $stmt = $dbh->prepare($sql);
  $stmt->bindValue(':user_id', $aUser['user_id']);

  try {
    $stmt->execute();
    $cnt = $stmt->rowCount();
  }
  catch (PDOException $e) {
    $rc = 820;
    return $rc;
  }

  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return $rc;
}

?>
