<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

/*

  whoami()
  getHomeDir($pUser)
  runSshCommand($pUser, $pHost, $pCommand)
  getPidFromPidFile($pUser, $pHost, $pPidFile)
  getTailOfFile($pUser, $pHost, $pFile, $pCount)
  getOperatingSystem()

*/

// No require/included here!

// -------------------------------------------------------------------
function whoami()
// -------------------------------------------------------------------
{
  $cmd = 'which whoami';
  $whoami = exec($cmd, $output, $ret);
  return exec($whoami, $output, $ret);
}

// -------------------------------------------------------------------
function getHomeDir($pUser)
// -------------------------------------------------------------------
{
  $cmd = "grep $pUser /etc/passwd";
  $stdout = exec($cmd, $output, $ret);
  $f = explode(':', $stdout);
  return rtrim($f[5], '/');
}

// -------------------------------------------------------------------
// todo:Shoul possibly better be in the ssh class?
function runSshCommand($pUser, $pHost, $pCommand)
// -------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  // 2>&1 >& /dev/null
  $cmd = 'ssh -o ConnectTimeout=10 ' . $pUser . '@' . $pHost . " '$pCommand' 2>&1";
  logMessage(LOG_DEBUG, $cmd);

  // ssh exits with the exit status of the remote command or with 255 if an error occurred.
  $stdout = exec($cmd, $output, $ret);
  logMessage(LOG_DEBUG, $stdout);
  logMessage(LOG_DEBUG, print_r($output, true));

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (ret=$ret).");
  return array($ret, implode("\n", $output));
}

// -------------------------------------------------------------------
function getPidFromPidFile($pUser, $pHost, $pPidFile)
// -------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $cmd = "cat $pPidFile 2>&1";
  list($rc, $output) = runSshCommand($pUser, $pHost, $cmd);

	try {
		if ( $rc != OK ) {
			throw new Exception(null);
		}
		if ( intval($output) == 0 ) {
			$rc = 961;
			throw new Exception(null);
		}
	}
	catch (Exception $e) {
    // noop $e->getMessage()
	}

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, intval($output));
}

// -------------------------------------------------------------------
function getTailOfFile($pUser, $pHost, $pFile, $pCount)
// -------------------------------------------------------------------
{
  $rc = OK;

  $cmd = "tail -n $pCount $pFile 2>&1";
  list($rc, $output) = runSshCommand($pUser, $pHost, $cmd);
  return array($rc, $output);
}

// -------------------------------------------------------------------
function getOperatingSystem()
// -------------------------------------------------------------------
{
  $aOperatingSystem = array();

  $cmd = 'uname -i';
  $aOperatingSystem['Hardware platform'] = exec($cmd, $stdout, $ret);
  $cmd = 'uname -o';
  $aOperatingSystem['Operating System'] = exec($cmd, $stdout, $ret);

  if ( $aOperatingSystem['Operating System'] == 'GNU/Linux' ) {

    $cmd = 'lsb_release -a 2>/dev/null';
    exec($cmd, $lsb, $ret);

    foreach ( $lsb as $row ) {
      list($key, $value) = explode(':', $row, 2);
      $aOperatingSystem[trim($key)] = trim($value);
    }
  }

  return $aOperatingSystem;
}

?>
