<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

/*

  catRemoteFile($pUser, $pHost, $pFile)
  createPublicKey($pUser, $pHost)
  runRemoteCommand($pUser, $pHost, $pCommand)
  copyFileToRemoteServer($pLocalFile, $pUser, $pHost, $pRemoteFile)

*/

// ---------------------------------------------------------------------
function catRemoteFile($pUser, $pHost, $pFile)
// ---------------------------------------------------------------------
{
  $rc = OK;

  $cmd = "ssh -o ConnectTimeout=10 $pUser@$pHost 'cat $pFile' 2>&1";
  // print $cmd;
  $stdout = exec($cmd, $output, $ret);

  if ( $ret != 0 ) {
    $rc = 554;
    return array($rc, $stdout);
  }

  return array($rc, $output);
}

// ---------------------------------------------------------------------
function runRemoteCommand($pUser, $pHost, $pCommand)
// ---------------------------------------------------------------------
{
  $rc = OK;

  $gSshTimeout = 10;
  $cmd = "ssh -o ConnectTimeout=$gSshTimeout $pUser@$pHost '$pCommand' 2>&1";
  $stdout = exec($cmd, $output, $ret);

  if ( $ret != 0 ) {
    $rc = 558;
    return array($rc, $stdout);
  }

  return array($rc, $output);
}

// ---------------------------------------------------------------------
function createPublicKey($pUser, $pHost)
// ---------------------------------------------------------------------
{
  $rc = OK;

  $whoami = whoami();
  $home = getHomeDir($whoami);

  // Find ssh-keygen

  $cmd = "which ssh-keygen";
  $stdout = exec($cmd, $output, $ret);
  if ( $ret != 0 ) {
    $rc = 555;
    $msg = 'Program ssh-keygen not found.';
    return array($rc, $msg);
  }

  // Check and if needed create ~/.ssh folder

  $lSshDir = $home . '/.ssh';
  if ( ! file_exists($lSshDir) ) {
    print "<p>Directory $lSshDir does not exist. Creating it...<br />\n";
    if ( @mkdir($lSshDir) === false ) {

      $error = error_get_last();
      $rc = 556;
      $msg = "Error creating $lSshDir: " . $error['message'] . " (rc=$rc)!";
      return array($rc, $msg);
    }
  }

  // Create ssh key

  $cmd = "$stdout -N '' -t rsa -f " . $home . "/.ssh/id_rsa";
  $stdout = exec($cmd, $output, $ret);
  if ( $ret != 0 ) {
    $rc = 557;
    $msg = "Error creating ssh key: $stdout (ret = $ret).";
    return array($rc, $msg);
  }
}

// ---------------------------------------------------------------------
function copyFileToRemoteServer($pLocalFile, $pUser, $pHost, $pRemoteFile)
// ---------------------------------------------------------------------
{
  $rc = OK;

  $port = 22;
  $timeout = 10;

  $cmd = "scp -P $port -o ConnectTimeout=$timeout $pLocalFile $pUser@$pHost:$pRemoteFile 2>&1";
  // print $cmd;
  $stdout = exec($cmd, $output, $ret);

  if ( $ret != 0 ) {
    $rc = 957;
    return array($rc, $stdout);
  }

  return array($rc, $output);
}

?>
