<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

// No require/included here!

$gMenuStructure = array(
  'server' => array(
    'title' => 'Server'
  , 'link' => 'index.php?f=show&amp;o=server&amp;s=overview'
  , 'active' => true
  , 'submenu' => array(
      'configuration' => array('title' => 'Configuration', 'link' => '', 'active' => true)
    , 'checks'        => array('title' => 'Checks', 'link' => '', 'active' => true)
    )
  )
, 'database' => array(
    'title' => 'Database'
  , 'link' => 'index.php?f=show&amp;o=node&amp;s=overview'
  , 'active' => true
  , 'submenu' => array(
      'configuration' => array('title' => 'Configuration', 'link' => '', 'active' => true)
    , 'checks'        => array('title' => 'Checks', 'link' => '', 'active' => true)
    , 'operations'    => array('title' => 'Operations', 'link' => '', 'active' => true)
    , 'information'   => array('title' => 'Information', 'link' => '', 'active' => false)
    , 'replication'   => array('title' => 'Replication', 'link' => '', 'active' => false)
    , 'error_log'     => array('title' => 'Error Log', 'link' => '', 'active' => false)
    , 'profiler'      => array('title' => 'Profiler', 'link' => '', 'active' => false)
    , 'monitor'       => array('title' => 'Monitor', 'link' => '', 'active' => false)
    )
  )
, 'replication' => array(
    'title' => 'Replication'
  , 'link' => 'index.php?f=show&amp;o=replication&amp;s=overview'
  , 'active' => true
  , 'submenu' => array(
      'configuration' => array('title' => 'Configuration', 'link' => '', 'active' => true)
    , 'checks'        => array('title' => 'Checks', 'link' => '', 'active' => true)
    , 'operations'    => array('title' => 'Operations', 'link' => '', 'active' => true)
    , 'status'        => array('title' => 'Status', 'link' => '', 'active' => false)
    , 'vip'           => array('title' => 'VIP', 'link' => '', 'active' => false)
    , 'load-balancer' => array('title' => 'Load Balancer', 'link' => '', 'active' => false)
    )
  )
, 'vip' => array(
		'title' => 'VIP'
  , 'link' => 'index.php?f=show&amp;o=vip&amp;s=overview'
  , 'active' => true
  , 'submenu' => array(
      'configuration' => array('title' => 'Configuration', 'link' => '', 'active' => true)
    , 'checks'        => array('title' => 'Checks', 'link' => '', 'active' => true)
    , 'operations'    => array('title' => 'Operations', 'link' => '', 'active' => true)
  	)
  )
, 'master-master'  => array('title' => 'M/M Replication', 'link' => 'index.php?f=show&o=master-master', 'active' => false)
, 'galera_cluster' => array('title' => 'Galera Cluster', 'link' => '', 'active' => false)
, 'a/p-cluster'    => array('title' => 'Failover Cluster', 'link' => '', 'active' => false)
, 'ndb-cluster'    => array('title' => 'MySQL Cluster', 'link' => '', 'active' => false)
, 'configuation' => array(
    'title' => 'Configuration'
  , 'link' => 'index.php?f=show&amp;o=configuration&amp;s=license_information'
  , 'active' => true
  , 'submenu' => array(
      'ssh_key'             => array('title' => 'Ssh Public Key', 'link' => '', 'active' => true)
    , 'moc_server'          => array('title' => 'Redundant MOC Server', 'link' => '', 'active' => false)
    , 'alerts'              => array('title' => 'Alerts', 'link' => '', 'active' => false)
    , 'license_information' => array('title' => 'License information', 'link' => '', 'active' => false)
    , 'jobs'                => array('title' => 'Jobs', 'link' => '', 'active' => false)
    , 'crontab'             => array('title' => 'Crontab', 'link' => '', 'active' => true)
    , 'bugs'                => array('title' => 'Bugs', 'link' => 'https://support.fromdual.com/bugs', 'active' => true)
    , 'user'                => array('title' => 'User', 'link' => '', 'active' => true)
    )
  )
, 'login' => array(
    'title' => 'Login'
  , 'link' => 'index.php?f=show&amp;o=user&amp;s=login-mask'
  , 'active' => true
  )
);

// print "<pre>"; print_r($gMenuStructure); print "</pre>";

function printMenu()
{
  global $hObject, $gThemePath;

	?>
	<table border="0" cellpadding="3" cellspacing="0" width="100%">
		<tr>
			<th align="left">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?f=show&amp;o=configuration&amp;s=license_information" title="Dashboard">Dashboard</a></th>
			<th colspan="1" width="20%"></th>
		</tr>
		<tr>
			<th align="left"><a href="index.php?f=show&amp;o=server&amp;s=overview" title="Server"><img src="<?php print $gThemePath; ?>/open.png" title="Server" height="12" />Server</a></th>
			<th colspan="1" width="20%"></th>
		</tr>
		<?php

		// -------------------------------------------------------------------
		if ( $hObject == 'server' )
		// -------------------------------------------------------------------
		{
			list($rc, $dbh) = openRepositoryDatabase();
			list($ret, $aServers) = getAllServers($dbh);
			// print "<pre>"; print_r($aServers); print "</pre>\n";
			closeRepositoryDatabase($dbh);

			// Print all database nodes
			foreach ( $aServers as $server_id => $server ) {

				$ret = getServerCheckSummary($server['server_id']);
				logMessage(LOG_DEBUG, "getCheckSummary for server " . $server['server_id'] . " returns $ret.");

				switch ( $ret ) {
				case 0:
					$color  = 'green';
					$status = 'OK';
					$img    = 'img/status-green.png';
					break;
				case 1:
					$color  = 'orange';
					$status = 'WARN';
					$img    = 'img/status-orange.png';
					break;
				case 2:
					$color  = 'red';
					$status = 'ERR';
					$img    = 'img/status-red.png';
					break;
				case 9:
					$color  = 'orange';
					$status = 'UNK';
					$img    = 'img/status-orange.png';
					break;
				default:
					$color  = 'red';
					$status = 'ERR';
					$img    = 'img/status-red.png';
				}

				?>
				<tr>
					<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?f=show&amp;o=server&amp;s=checks&amp;server_id=<?php print $server['server_id']; ?>"><?php print $server['name']; ?></a></td>
					<td align="center" colspan="1"><span style='color:<?php print $color; ?>;'><img src="<?php print $img; ?>" alt="<?php print $status; ?>" width="16" height="16" title="Status <?php print $status; ?>" /></span></td>
				</tr>
				<?php
			}
		}
		?>
		<tr>
			<th align="left"><a href="index.php?f=show&amp;o=node&amp;s=overview" title="Database"><img src="<?php print $gThemePath; ?>/open.png" title="Database" height="12" />Database</a></th>
			<th colspan="1" width="20%"></th>
		</tr>
		<?php
		// -------------------------------------------------------------------
		if ( $hObject == 'node' )
		// -------------------------------------------------------------------
		{
			list($rc, $dbh) = openRepositoryDatabase();
			list($rc, $aSections) = getAllDatabaseNodes($dbh);
			closeRepositoryDatabase($dbh);

			// Print all database nodes
			foreach ( $aSections as $node => $aNode ) {

				$ret = getCheckSummaryById($aNode['node_id']);

				logMessage(LOG_DEBUG, "getCheckSummary for node $node returns $ret.");

				switch ( $ret ) {
				case 0:
					$color  = 'green';
					$status = 'OK';
					$img    = 'img/status-green.png';
					break;
				case 1:
					$color  = 'orange';
					$status = 'WARN';
					$img    = 'img/status-orange.png';
					break;
				case 2:
					$color  = 'red';
					$status = 'ERR';
					$img    = 'img/status-red.png';
					break;
				case 9:
					$color  = 'orange';
					$status = 'UNK';
					$img    = 'img/status-orange.png';
					break;
				default:
					$color  = 'red';
					$status = 'ERR';
					$img    = 'img/status-red.png';
				}

				?>
				<tr>
					<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?f=show&amp;o=node&amp;s=checks&amp;node_id=<?php print $aNode['node_id']; ?>"><?php print $aNode['name']; ?></a></td>
					<td align="center" colspan="1"><span style='color:<?php print $color; ?>;'><img src="<?php print $img; ?>" alt="<?php print $status; ?>" width="16" height="16" title="Status <?php print $status; ?>" /></span></td>
				</tr>
				<?php
			}
		}

		?>
		<tr>
			<th align="left"><a href="index.php?f=show&amp;o=replication&amp;s=overview" title="Replication"><img src="<?php print $gThemePath; ?>/open.png" title="Replication" height="12" />Replication</a></th>
			<th colspan="1" width="20%"></th>
		</tr>
		<?php

		// -------------------------------------------------------------------
		if ( ($hObject == 'replication') || ($hObject == 'master-master') )
		// -------------------------------------------------------------------
		{
			list($ret, $dbh) = openRepositoryDatabase();
			logMessage(LOG_DEBUG, "openConfiguartionDatabase: rc=$ret");
			list($ret, $aMS) = getAllClusters($dbh, MASTER_SLAVE);
			logMessage(LOG_DEBUG, "getAllClusters: rc=$ret");
			list($ret, $aMM) = getAllClusters($dbh, MASTER_MASTER);
			logMessage(LOG_DEBUG, "getAllClusters: rc=$ret");
			$aMasterSlaves = array_merge($aMS, $aMM);
			closeRepositoryDatabase($dbh);

			foreach ($aMasterSlaves as $name => $values ) {

				$color = 'red';
				$img    = 'img/status-red.png';
				$status = 'ERR';

				// Check replication

				list($ret, $aNodes) = getNodesOfClusterById($dbh, $values['cluster_id']);
				logMessage(LOG_DEBUG, "getNodesOfClusterById: rc=$ret");
				foreach ( $aNodes as $id => $node ) {

					if ( $node['role_id'] == SLAVE ) {

						list($ret, $mysqli) = openDatabaseConnection($node['database_user'], $node['database_user_password'], $node['hostname'], $node['port']);
						if ( $ret != 0 ) {
							$color = 'red';
							$img    = 'img/status-red.png';
							$status = 'ERR';
						}
						else {
							list($ret, $aSlaveStatus) = getShowSlaveStatus($mysqli);
							logMessage(LOG_INFO, $ret);
							logMessage(LOG_DEBUG, print_r($aSlaveStatus, true));

							if ( $ret == OK ) {
								if ( ($aSlaveStatus['Slave_IO_Running'] == 'Yes') && ($aSlaveStatus['Slave_SQL_Running'] == 'Yes') ) {
									if ( $aSlaveStatus['Seconds_Behind_Master'] == 0 ) {
										$color = 'green';
										$img    = 'img/status-green.png';
										$status = 'OK';
									}
									else {
										$color = 'orange';
										$img    = 'img/status-orange.png';
										$status = 'WARN';
									}
								}
							}
							else {
								logMessage(LOG_ERR, "(rc=$ret), $aSlaveStatus");
							}
							closeDatabaseConnection($mysqli);
						}

					}   // SLAVE

				}   // foreach
				?>
				<tr>
					<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?f=show&amp;o=replication&amp;s=checks&amp;cluster_id=<?php print $values['cluster_id']; ?>"><?php print $values['name']; ?></a></td>
					<td align="center" colspan="1"><span style='color:<?php print $color; ?>;'><img src="<?php print $img; ?>" alt="<?php print $status; ?>" width="16" height="16" title="Status <?php print $status; ?>" /></span></td>
				</tr>
				<?php
			}
		}
		// -------------------------------------------------------------------
		elseif ( $hObject == 'galera_cluster' )
		// -------------------------------------------------------------------
		{
			?>

			<tr><th align="left">Galera Cluster</th><th>Ping</th><th>ssh</th><th>Connect</th></tr>
			<tr><td>Galera Cluster 1</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td> + galera-1.0-21-a</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td> + galera-1.0-21-b</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Red">ERR</td></tr>
			<tr><td> + galera-1.0-21-c</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Orange">ERR</td></tr>
			<tr><td colspan="4">Create Galera Cluster</td></tr>

			<?php
		}
		// -------------------------------------------------------------------
		elseif ( $hObject == 'a/p-cluster' )
		// -------------------------------------------------------------------
		{
			?>

			<tr><th align="left">Failover Cluster</th><th>Ping</th><th>ssh</th><th>Connect</th></tr>
			<tr><td>a/p-Cluster 1</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td> + mysql-5.6.4</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td> + <span style="color:grey;">mysql-5.6.4</span></td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td colspan="4">Create failover Cluster</td></tr>

			<?php
		}
		// -------------------------------------------------------------------
		elseif ( $hObject == 'ndb-cluster' )
		// -------------------------------------------------------------------
		{
			?>

			<tr><th align="left">MySQL Cluster</th><th>Ping</th><th>ssh</th><th>Connect</th></tr>
			<tr><td>MySQL Cluster 1</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td> + mgm1</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td> + mgm2</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td> + datanode1</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td> + datanode2</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td> + datanode3</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td> + datanode4</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td> + sqlnode1</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td> + sqlnode2</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td> + sqlnode3</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td><td bgcolor="Green">OK</td></tr>
			<tr><td colspan="4">Create MySQL Cluster</td></tr>

			<?php
		}
		// -------------------------------------------------------------------
		elseif ( ($hObject == 'configuration') || ($hObject == '') )
		// -------------------------------------------------------------------
		{
		}
		// -------------------------------------------------------------------
		elseif ( $hObject == 'login' )
		// -------------------------------------------------------------------
		{
		}
		// -------------------------------------------------------------------
		elseif ( $hObject == 'public_key' )
		// -------------------------------------------------------------------
		{
		}
		?>
		<tr>
			<th align="left"><a href="index.php?f=show&amp;o=vip&amp;s=overview" title="VIP"><img src="<?php print $gThemePath; ?>/open.png" title="VIP" height="12" />VIP</a></th>
			<th colspan="1" width="20%"></th>
		</tr>
		<?php
		// -------------------------------------------------------------------
		if ( $hObject == 'vip' )
		// -------------------------------------------------------------------
		{
			list($rc, $dbh) = openRepositoryDatabase();
			list($ret, $aVips) = getVipsWithFilter($dbh, array());
			// print "<pre>"; print_r($aVips); print "</pre>\n";
			closeRepositoryDatabase($dbh);

			// Print all vips
			foreach ( $aVips as $vip_id => $vip ) {

				?>
				<tr>
					<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?o=vip&amp;f=show&amp;s=operations&amp;vip_id=<?php print $vip['vip_id']; ?>"><?php print $vip['ip_address']; ?></a></td>
					<td align="center" colspan="1"></td>
				</tr>
				<?php
			}
		}
		// -------------------------------------------------------------------
		elseif ( $hObject == 'slave' )
		// -------------------------------------------------------------------
		{
		}
		// -------------------------------------------------------------------
		elseif ( $hObject == 'user' )
		// -------------------------------------------------------------------
		{
		}
		// -------------------------------------------------------------------
		elseif ( $hObject == 'load-balancer' )
		// -------------------------------------------------------------------
		{
		}
		?>
		<tr>
			<th align="left"><a href="index.php?f=show&amp;o=configuration&amp;s=license_information" title="Configuration"><img src="<?php print $gThemePath; ?>/open.png" title="Configuration" height="12" />Configuration</a></th>
			<th colspan="1" width="20%"></th>
		</tr>
		<?php
		// -------------------------------------------------------------------
		if ( $hObject == 'configuration' )
		// -------------------------------------------------------------------
		{
			?>
			<tr>
				<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?f=show&amp;o=configuration&amp;s=ssh_key">ssh Public Key</a></td>
				<td align="center" colspan="1"></td>
			</tr>
			<?php
			/*
			<tr>
				<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?f=show&amp;o=configuration&amp;s=jobs">Jobs</a></td>
				<td align="center" colspan="1"></td>
			</tr>
			*/
			?>
			<tr>
				<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?f=show&amp;o=configuration&amp;s=crontab">Crontab</a></td>
				<td align="center" colspan="1"></td>
			</tr>
			<tr>
				<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="https://support.fromdual.com/bugs" target="_blank" title="Bugs">Bugs</a></td>
				<td align="center" colspan="1"></td>
			</tr>
			<tr>
				<td>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href="index.php?f=show&amp;o=configuration&amp;s=user">User</a></td>
				<td align="center" colspan="1"></td>
			</tr>
			<?php
		}
		?>
	</table>
	<?php
}

?>
