<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

/*

	printHiResTime()
	logMessage($pPriority = LOG_EMERG, $pMessage)

*/

// No require/included here!

// ---------------------------------------------------------------------
function printHiResTime()
// ---------------------------------------------------------------------
{
   list($usec, $sec) = explode(' ', microtime());
   return ((float)$usec + (float)$sec);
}

// ---------------------------------------------------------------------
function logMessage($pPriority = LOG_EMERG, $pMessage)
// ---------------------------------------------------------------------
{
  global $gLogFile, $gLogPriorityThreshold, $gLogPriorityFilter, $gIndention;

  // var_dump($pPriority, $pMessage, $gLogPriorityThreshold);

  /*
    Log Priorities (see syslog)

    LOG_EMERG   system is unusable
                MOC critical ERRORS
    LOG_ALERT   action must be taken immediately
								MOC ERRORS
    LOG_CRIT    critical conditions
								MOC WARNINGS
    LOG_ERR     error conditions
								Target (node) ERRORS
    LOG_WARNING warning conditions
								Target (node) WARNINGS
    LOG_NOTICE  normal, but significant, condition
								Function calls
    LOG_INFO    informational message
								return codes, etc
    LOG_DEBUG   debug-level message
								print_r, $sql, etc
  */

  // Priority is above threshold
  if ( $pPriority > $gLogPriorityThreshold ) {
    return;
  }

  // We have special log filters enabled
  if ( in_array($pPriority, $gLogPriorityFilter) ) {
    return;
  }

  switch ( $pPriority ) {
  // MOC critical ERRORS
  case LOG_EMERG:
    $lPriorityMessage = 'EMERG ';
    break;
  // MOC ERRORS
  case LOG_ALERT:
    $lPriorityMessage = 'ALERT ';
    break;
  // MOC WARNINGS
  case LOG_CRIT:
    $lPriorityMessage = 'CRIT  ';
    break;
  // Target (node) ERRORS
  case LOG_ERR:
    $lPriorityMessage = 'ERROR ';
    break;
  // Target (node) WARNINGS
  case LOG_WARNING:
    $lPriorityMessage = 'WARN  ';
    break;
  // Function calls
  case LOG_NOTICE:
    $lPriorityMessage = 'NOTICE';
    break;
  // return codes, etc
  case LOG_INFO:
    $lPriorityMessage = 'INFO  ';
    break;
  // print_r, $sql, etc
  case LOG_DEBUG:
    $lPriorityMessage = 'DEBUG ';
    break;
  default:
    $rc = 999;
    $lPriorityMessage = 'ERROR ';
    $pMessage .= "\nWrong priority: $pPriority (rc=$rc).";
  }

  $a = gettimeofday();
  $msg = sprintf("%s.%06d %5d - %-6s %s %s", date('Y-m-d H:i:s', $a['sec']), $a['usec'], getmypid(), $lPriorityMessage, str_repeat(' ', $gIndention), $pMessage);

  if ( $gLogFile != '' ) {
    error_log($msg . PHP_EOL, 3, $gLogFile);
  }
  else {
    // This will never happen atm!
    // /etc/php5/apache2/php.ini
    // error_log
    error_log($msg);
  }
}

?>
