<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

/*

  setInstallationLevel($pLevel)
  getInstallationLevel()

*/

// ---------------------------------------------------------------------
function getInstallationLevel()
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  global $gConfigDir;

  $file = $gConfigDir . '/' . 'installation.status';
  $level = 'none';

	try {
  
		if ( ! file_exists($file) ) {
			throw new Exception('none');
		}

		if ( ! is_readable($file) ) {
			$rc = 865;
			$msg = "File $file does not exist or is not readable for user " . whoami() . " (rc=$rc).";
			logMessage(LOG_ERR, $msg);
			print "<p>$msg</p>\n";
			throw new Exception('error');
		}

		// read file
		try {
			$fh = fopen($file, 'r');
		}
		catch (Exception $e) {
			$rc = 703;
			$msg = $e->getMessage() . " (rc=$rc).";
			logMessage(LOG_ERR, $msg);
			print "<p>$msg</p>\n";
			throw new Exception('error');
		}

		if ( $fh !== false ) {
			$level = trim(fgets($fh));
			fclose($fh);
		}

		if ( $level == '' ) {
			$level = 'none';
		}

  }
  catch (Exception $e) {
		$level = $e->getMessage();
  }
  
  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (level=$level).");
  return $level;
}

// ---------------------------------------------------------------------
function setInstallationLevel($pLevel)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  global $gConfigDir;

  $rc = OK;

  $file = $gConfigDir . '/' . 'installation.status';

	try {

		if ( ! file_exists($file) ) {

			// try to write file
			try {
				$fh = @fopen($file, 'w');
			}
			catch (Exception $e) {
				$rc = 702;
				$msg = $e->getMessage() . " (rc=$rc).";
				logMessage(LOG_ERR, $msg);
				print "<p>$msg</p>\n";
				throw new Exception($rc);
			}
			if ( $fh !== false ) {
				fclose($fh);
			}
			else {
				$rc = 931;
				$err = error_get_last();
				$msg = "Error: " . $err['message'] . " (rc=$rc). Line: " . $err['line'] . ', ' . $err['file'];
				logMessage(LOG_ERR, $msg);
				print "<p>$msg</p>\n";
				throw new Exception($rc);
			}
		}

		// File exits for sure here
		if ( ! is_writable($file) ) {
			$rc = 700;
			$msg = "Cannot write to $file as user " . whoami() . " (rc=$rc).";
			logMessage(LOG_ERR, $msg);
			print "<p>$msg</p>\n";
			throw new Exception($rc);
		}

		try {
			$fh = @fopen($file, 'w');
			fputs($fh, "$pLevel\n");
			fclose($fh);
		}
		catch (Exception $e) {
			$rc = 701;
			$msg = "Error: " . $e->getMessage() . " (rc=$rc).";
			logMessage(LOG_ERR, $msg);
			print "<p>$msg</p>\n";
			throw new Exception($rc);
		}

	}
	catch (Exception $e) {
		// noop
	}
  
  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return $rc;
}

?>
