<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

/*

  openDatabaseConnection($pUser, $pPassword, $pHost, $pPort)
  closeDatabaseConnection($mysqli)
  getGlobalVariable($mysqli, $pVariableName)
  getReplicationUsers($mysqli)
  getShowMasterStatus($mysqli)
  getShowSlaveStatus($mysqli)
  getAllGlobalVariables($mysqli)
  getPidFile($mysqli)
  stopSqlThread($mysqli)
  startSqlThread($mysqli)
  stopIoThread($mysqli)
  startIoThread($mysqli)
  startSlave($mysqli)
  stopSlaveDirect($mysqli)
  stopSlaveSecure($mysqli)
  getAllGlobalStatus($mysqli)
  getGlobalStatus($mysqli, $pStatusName)
  skipSlaveEvent($mysqli, $pCount = 1)
  getSlaveHosts($mysqli)
  setSlaveToMaster($mysqli, $pChangeMasterTo)
  resetSlave($mysqli)

*/

// No require/included here!

// ---------------------------------------------------------------------
function openDatabaseConnection($pUser, $pPassword, $pHost, $pPort)
// ---------------------------------------------------------------------
{
	global $gIndention;
	logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
	$gIndention += 2;

	$rc = OK;
	logMessage(LOG_DEBUG, "User=$pUser, host=$pHost, port=$pPort");

	try {

		// Does not work if we want to use an option!
		// $mysqli = new mysqli($pHost, $pUser, $pPassword, null, $pPort, null);

		$mysqli = mysqli_init();
		if ( ! $mysqli ) {
			$rc = 675;
			$msg = "mysqli_init failed (rc=$rc).";
			throw new Exception($msg);
		}

		$err = ini_get('error_reporting');
		ini_set('error_reporting', 0);

		$timeout = 3;
		if ( ! $mysqli->options(MYSQLI_OPT_CONNECT_TIMEOUT, $timeout) ) {
			$rc = 674;
			$msg = "Setting MYSQLI_OPT_CONNECT_TIMEOUT failed (rc=$rc).";
			ini_set('error_reporting', $err);
			throw new Exception($msg);
		}

		if ( ! $mysqli->real_connect($pHost, $pUser, $pPassword, null, $pPort, null) ) {
			$rc = 704;
			$msg = 'Connect Error (' . mysqli_connect_errno() . ') '	 . mysqli_connect_error() . " (rc=$rc)";
			ini_set('error_reporting', $err);
			throw new Exception($msg);
		}

		ini_set('error_reporting', $err);
		if ( mysqli_connect_errno() != 0 ) {
			$rc = 673;
			$msg = 'Connect Error (' . mysqli_connect_errno() . ') '	 . mysqli_connect_error() . " (rc=$rc)";
			throw new Exception($msg);
		}

		if ( ! $mysqli->query('SET NAMES utf8') ) {
			$rc = 672;
			$msg = "Cannot set character set to utf8 (rc=$rc)";
			throw new Exception($msg);
		}
	}
	catch (Exception $e) {
		logMessage(LOG_ERR, $e->getMessage());
		$mysqli = $msg;
	}

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $mysqli);
}

// ---------------------------------------------------------------------
function closeDatabaseConnection($mysqli)
// ---------------------------------------------------------------------
{
  $mysqli->close();
}

// ---------------------------------------------------------------------
function getGlobalVariable($mysqli, $pVariableName)
// return array($rc, $value)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $sql = sprintf("SHOW GLOBAL VARIABLES WHERE variable_name = '%s'", $pVariableName);
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  try {
  
		if ( ! $result = $mysqli->query($sql) ) {
			$rc = 705;
			$value = $mysqli->error . " (rc=$rc).";
			throw new Exception($value);
		}
		if ( $record = $result->fetch_array(MYSQLI_ASSOC) ) {
			$value = $record['Value'];
		}
		else {
			$rc = 706;
			$value = "Error (rc=$rc).";
			throw new Exception($value);
		}
  }
	catch (Exception $e) {
		// noop
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $value);
}

// ---------------------------------------------------------------------
function getReplicationUsers($mysqli)
// return array($rc, $aUser)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc    = OK;
  $aUser = array();

  $sql = sprintf("SELECT user, host FROM mysql.user WHERE Repl_slave_priv = 'Y' AND user != 'root'");
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $result = $mysqli->query($sql) ) {
    $rc = 940;
    $value = $mysqli->error;
    return array($rc, $value);
  }
  while ( $record = $result->fetch_array(MYSQLI_ASSOC) ) {
    $user = "'" . $record['user'] . "'@'" . $record['host'] . "'";
    array_push($aUser, $user);
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $aUser);
}

// ---------------------------------------------------------------------
function getShowMasterStatus($mysqli)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $aStatus = array(
		'File' => ''
	, 'Position' => ''
	, 'Binlog_Do_DB' => ''
	, 'Binlog_Ignore_DB' => ''
	, 'Executed_Gtid_Set' => ''
	);

  $sql = sprintf("SHOW MASTER STATUS");
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $result = $mysqli->query($sql) ) {
    $rc = 950;
    $value = $mysqli->error;
    return array($rc, $value);
  }
  if ( $record = $result->fetch_array(MYSQLI_ASSOC) ) {
    $aStatus = $record;
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $aStatus);
}

// ---------------------------------------------------------------------
function getShowSlaveStatus($mysqli)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  // Set defaults just in case this slave is not really a slave!!!
  $aStatus = array(
    'Master_Host'           => ''
  , 'Master_User'           => ''
  , 'Master_Port'           => ''
  , 'Master_Password'       => ''
  , 'Master_Log_File'       => ''
  , 'Master_Log_Pos'        => ''
  , 'Exec_Master_Log_Pos'   => ''
  , 'Slave_IO_Running'      => 'No'
  , 'Slave_SQL_Running'     => 'No'
  , 'Last_Errno'            => 999
  , 'Slave_IO_State'        => ''
  , 'Skip_Counter'          => 0
  , 'Seconds_Behind_Master' => 0
  , 'Last_IO_Errno'         => 0
  , 'Last_IO_Error'         => ''
  , 'Last_SQL_Errno'        => 0
  , 'Last_SQL_Error'        => ''
  , 'Last_Error'            => 'This is NOT a Slave yet at the moment!'
  );

	$sql = sprintf("SHOW SLAVE STATUS");
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

	if ( ! $result = $mysqli->query($sql) ) {
		$rc = 960;
		$aStatus = $mysqli->error;
	}
	else {

		if ( $record = $result->fetch_array(MYSQLI_ASSOC) ) {

			if ( count($record) == 0 ) {
				$rc = 962;
				$aStatus = 'Slave is not a Slave yet.';
			}
			else {
				$aStatus = $record;
			}
		}
	}

	$gIndention -= 2;
	logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
	return array($rc, $aStatus);
}

// ---------------------------------------------------------------------
function getAllGlobalVariables($mysqli)
// return array($rc, $aVariables)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $aVariables = array();

  $sql = sprintf("SHOW GLOBAL VARIABLES");
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $result = $mysqli->query($sql) ) {
    $rc = 930;
    $msg = $mysqli->error;
    return array($rc, $msg);
  }
  while ( $record = $result->fetch_array(MYSQLI_ASSOC) ) {
    $aVariables[$record['Variable_name']] = $record['Value'];
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $aVariables);
}

// ---------------------------------------------------------------------
function getPidFile($mysqli)
// return array($rc, $value)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  list($rc, $value) = getGlobalVariable($mysqli, 'pid_file');

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $value);
}

// ---------------------------------------------------------------------
function stopSqlThread($mysqli)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $sql = sprintf("STOP SLAVE SQL_THREAD");
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $mysqli->query($sql) ) {
    $rc = 707;
    $value = $mysqli->error;
    return array($rc, $value);
  }

  if ( $mysqli->warning_count > 0 ) {
    $rc = 708;
    $a = $mysqli->get_warnings();
    $value = $a->message;
  }
  else {
    $value = 'Everything OK';
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $value);
}

// ---------------------------------------------------------------------
function startSqlThread($mysqli)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $sql = sprintf("START SLAVE SQL_THREAD");
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $mysqli->query($sql) ) {
    $rc = 709;
    $value = $mysqli->error;
    return array($rc, $value);
  }
  if ( $mysqli->warning_count > 0 ) {
    $rc = 710;
    $a = $mysqli->get_warnings();
    $value = $a->message;
  }
  else {
    $value = 'Everything OK';
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $value);
}

// ---------------------------------------------------------------------
function stopIoThread($mysqli)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $sql = sprintf("STOP SLAVE IO_THREAD");
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $mysqli->query($sql) ) {
    $rc = 711;
    $value = $mysqli->error;
    return array($rc, $value);
  }
  if ( $mysqli->warning_count > 0 ) {
    $rc = 712;
    $a = $mysqli->get_warnings();
    $value = $a->message;
  }
  else {
    $value = 'Everything OK';
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $value);
}

// ---------------------------------------------------------------------
function startIoThread($mysqli)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $sql = sprintf("START SLAVE IO_THREAD");
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $mysqli->query($sql) ) {
    $rc = 713;
    $value = $mysqli->error;
    return array($rc, $value);
  }
  if ( $mysqli->warning_count > 0 ) {
    $rc = 714;
    $a = $mysqli->get_warnings();
    $value = $a->message;
  }
  else {
    $value = 'Everything OK';
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $value);
}

// ---------------------------------------------------------------------
function startSlave($mysqli)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $sql = sprintf("START SLAVE");
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $mysqli->query($sql) ) {
    $rc = 715;
    $value = $mysqli->error;
    return array($rc, $value);
  }
  if ( $mysqli->warning_count > 0 ) {
    $rc = 716;
    $a = $mysqli->get_warnings();
    $value = $a->message;
  }
  else {
    $value = 'Everything OK';
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $value);
}

// ---------------------------------------------------------------------
function stopSlaveDirect($mysqli)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $sql = sprintf("STOP SLAVE");
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $mysqli->query($sql) ) {
    $rc = 717;
    $value = $mysqli->error;
    return array($rc, $value);
  }
  if ( $mysqli->warning_count > 0 ) {
    $rc = 718;
    $a = $mysqli->get_warnings();
    $value = $a->message;
  }
  else {
    $value = 'Everything OK';
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $value);
}

// ---------------------------------------------------------------------
function stopSlaveSecure($mysqli)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  list($rc, $value) = stopSqlThread($mysqli);
  if ( $rc != 0 ) {
  }

  list($rc, $value) = getGlobalStatus($mysqli, 'Slave_open_temp_tables');

  $cnt = 1;
  while ( $value != 0 ) {

    if ( $cnt >= 10 ) {
      break;
    }

    list($rc, $value) = startSqlThread($mysqli);
    sleep($cnt);
    list($rc, $value) = stopSqlThread($mysqli);
    list($rc, $value) = getGlobalStatus($mysqli, 'Slave_open_temp_tables');
    $cnt++;
  }

  // We gave up
  if ( $value > 1 ) {
    list($rc, $value) = startSqlThread($mysqli);
  }
  else {
    list($rc, $value) = stopIoThread($mysqli);
    if ( $rc != 0 ) {
    }
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $value);
}

// ---------------------------------------------------------------------
function getAllGlobalStatus($mysqli)
// ---------------------------------------------------------------------
{
  // Implement later
}

// ---------------------------------------------------------------------
function getGlobalStatus($mysqli, $pStatusName)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $sql = sprintf("SHOW GLOBAL STATUS WHERE variable_name = '%s'", $pStatusName);
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $result = $mysqli->query($sql) ) {
    $rc = 719;
    $value = $mysqli->error;
    return array($rc, $value);
  }
  if ( $record = $result->fetch_array(MYSQLI_ASSOC) ) {
    $value = $record['Value'];
  }
  else {
    $rc = 720;
    $value = 'Error';
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $value);
}

// ---------------------------------------------------------------------
function skipSlaveEvent($mysqli, $pCount = 1)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $sql = sprintf("SET GLOBAL sql_slave_skip_counter = %d", $pCount);
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $mysqli->query($sql) ) {
    $rc = 721;
    $value = $mysqli->error;
    return array($rc, $value);
  }

  if ( $mysqli->warning_count > 0 ) {
    $rc = 722;
    $a = $mysqli->get_warnings();
    $value = $a->message;
  }
  else {
    $value = 'Everything OK';
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $value);
}

// ---------------------------------------------------------------------
function getSlaveHosts($mysqli)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $aSlaveHosts = array();

  $sql = sprintf("SHOW SLAVE HOSTS");
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $result = $mysqli->query($sql) ) {
    $rc = 723;
    $value = $mysqli->error;
    return array($rc, $value);
  }
  while ( $record = $result->fetch_array(MYSQLI_ASSOC) ) {
    $aSlaveHosts[$record['Server_id']] = $record;
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $aSlaveHosts);
}

// ---------------------------------------------------------------------
function setSlaveToMaster($mysqli, $pChangeMasterTo)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $sql = sprintf("CHANGE MASTER TO
  MASTER_HOST = '%s'
, MASTER_PORT = %d
, MASTER_USER = '%s'
, MASTER_PASSWORD = '%s'
, MASTER_LOG_FILE = '%s'
, MASTER_LOG_POS = %d"
, $pChangeMasterTo['master_host'], $pChangeMasterTo['master_port']
, $pChangeMasterTo['master_user'], $pChangeMasterTo['master_password']
, $pChangeMasterTo['master_log_file'], $pChangeMasterTo['master_log_pos']);
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $result = $mysqli->query($sql) ) {
    $rc = 552;
    $msg = $mysqli->error;
    return array($rc, $msg);
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, 'Everything OK.');
}

// ---------------------------------------------------------------------
function resetSlave($mysqli)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $sql = sprintf("RESET SLAVE");
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $result = $mysqli->query($sql) ) {
    $rc = 551;
    $msg = $mysqli->error;
    return array($rc, $msg);
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, 'Everything OK.');
}

// ---------------------------------------------------------------------
function getMasterInfo($mysqli, $aNode)
// Master.info can be a file or a table
// master_info_repository = FILE
// If table: mysql.slave_master_info
// If file: specified or not
// If specified: In my.cnf: --master-info-file
// If NOT specified: In $datadir/master.info
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  global $dbh;
  $rc = OK;
  $aMasterInfo = array();


	// Find out if master.info is FILE or TABLE?

	$sql = sprintf("SHOW GLOBAL VARIABLES WHERE variable_name = 'master_info_repository'");
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

  if ( ! $result = $mysqli->query($sql) ) {
    $rc = 923;
    $err = $mysqli->error . " (rc=$rc)";
	  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
    return array($rc, $err);
  }
  $mir = '';
  if ( $record = $result->fetch_array(MYSQLI_ASSOC) ) {
    $mir = $record['Value'];
  }


  // master.info.repository is FILE OR ''
  if ( ($mir == 'FILE') || ($mir == '') ) {

		// Find master.info location in my.cnf. It is NOT listed with
		// SHOW GLOBAL VARIABLES or similar!

		list($ret, $aServer) = getServerById($dbh, $aNode['server_id']);
		// todo: error handling
		list($ret, $file) = retrieveShortFile($aServer['os_user'], $aServer['name'], $aNode['my_cnf']);
		// todo: error handling

// master-info-file
// 
// 
// 
//     // find in my.cnf
//     if NOT found
//       get datadir/master.info
// 
//     get file



	}
	// master.info.repository is TABLE
	elseif ($mir == 'TABLE') {

		$sql = sprintf("SELECT Host AS Master_Host, User_name AS Master_User, User_password AS Master_Password, Port AS Master_Port, Master_log_name AS Master_Log_File, Master_log_pos AS Read_Master_Log_Pos FROM mysql.slave_master_info");
		logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));

		if ( ! $result = $mysqli->query($sql) ) {
			$rc = 925;
			$err = $mysqli->error . " (rc=$rc)";
		  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
			return array($rc, $err);
		}
		if ( $record = $result->fetch_array(MYSQLI_ASSOC) ) {
			$aMasterInfo = $record;
		}
  }
  // Unknown master.info.repository
  else {
    $rc = 924;
    $err = 'Unknown master_infor_repository ' . $mir;
	  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
    return array($rc, $err);
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $aMasterInfo);
}

?>
