<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

/*

  printCrontabFile()
  putTaskIntoCrontabFile($pTask)
  loadCrontabFromFile($pCrontabTmpFile)
  findTaskInCrontabFile($pTask)
  dumpCrontabToFile($pCrontabTmpFile)

*/

//   $this->lCrontabTmpFile = dirname($_SERVER['SCRIPT_FILENAME']) . '/tmp/crontab.tmp';
//   $this->lCheckNodesTask = dirname($_SERVER['SCRIPT_FILENAME']) . '/bin/check_nodes.php';

// No require/included here!

// ---------------------------------------------------------------------
function printCrontabFile()
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $cmd = "crontab -l 2>&1";
  $stdout = exec($cmd, $output, $ret);
  if ( $ret != 0 ) {
		logMessage(LOG_ERR, $stdout);
    $output = '';
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (ret=$ret).");
  return $output;
}

// ---------------------------------------------------------------------
function putTaskIntoCrontabFile($pTask)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

	try {
  
		if ( findTaskInCrontabFile($pTask) === true ) {
			$msg = "Task is already in crontab file.";
			print "<p>$msg</p>";
			throw new Exception($msg);
		}

		$lCrontabTmpFile = dirname($_SERVER['SCRIPT_FILENAME']) . '/tmp/crontab.tmp';
		$lCheckNodesTask = dirname($_SERVER['SCRIPT_FILENAME']) . '/bin/check_nodes.php';

		list($ret, $msg) = dumpCrontabToFile($lCrontabTmpFile);

		if ( $ret != OK ) {

			// no crontab so we touch it
			$fh = @fopen($lCrontabTmpFile, 'w');
			if ( $fh === false ) {
				// todo: how is the correct error message?
				$msg = 'Cannot create file ' . $lCrontabTmpFile . ' Missing privileges?';
				logMessage(LOG_ERR, $msg);
				throw new Exception($msg);
			}
			fclose($fh);
		}

		$fh = fopen($lCrontabTmpFile, 'a+');
		fputs($fh, "#\n");
		fputs($fh, "# MySQL Ops Center check job\n");
		fputs($fh, "#\n");
		fputs($fh, "*  *  *  *  *  " . $lCheckNodesTask . "\n");
		fputs($fh, "#\n");
		fclose($fh);
		loadCrontabFromFile($lCrontabTmpFile);
	}
	catch (Exception $e) {
		// noop
	}

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return $rc;
}

// ---------------------------------------------------------------------
function loadCrontabFromFile($pCrontabTmpFile)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $cmd = "crontab $pCrontabTmpFile";
  $stdout = exec($cmd, $output, $ret);
  if ( $ret != 0 ) {
    print "<p>$stdout</p>\n";
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$ret).");
  return OK;
}

// ---------------------------------------------------------------------
function findTaskInCrontabFile($pTask)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

	$rc = false;
  
  $lCrontabTmpFile = dirname($_SERVER['SCRIPT_FILENAME']) . '/tmp/crontab.tmp';

	try {
  
		list($ret, $msg) = dumpCrontabToFile($lCrontabTmpFile);

		if ( $ret != OK ) {
			$rc = 879;
			$msg = $msg . " (rc=$rc).";
			logMessage(LOG_ERR, $msg);
			print "<p>$msg</p>\n";
			$rc = false;
			throw new Exception($msg);
		}

		try {
			$fh = fopen($lCrontabTmpFile, 'r');
		}
		catch (Exception $e) {
			$rc = 878;
			$msg = $e->getMessage() . " (rc=$rc).";
			logMessage(LOG_ERR, $msg);
			print "<p>$msg</p>\n";
			$rc = false;
			throw new Exception($msg);
		}

		while ( ($line = fgets($fh)) ) {

			$pattern = '#.*' . $pTask . '.*#';

			if ( preg_match($pattern, $line, $matches) ) {
				fclose($fh);
				$rc = true;
				throw new Exception($msg);
			}
		}
		fclose($fh);
  }
  catch (Exception $e) {
		// noop
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return $rc;
}

// ---------------------------------------------------------------------
function dumpCrontabToFile($pCrontabTmpFile)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
	$msg = '';

  $cmd = "crontab -l > " . $pCrontabTmpFile;
  $stdout = exec($cmd, $output, $ret);

  if ( $ret != 0 ) {

    // no crontab for httpd user
    if ( $ret == 1 ) {
			$rc = 800;
      $msg = 'Error dumping crontab occured. Empty crontab.';
    }
    else {
			$rc = 809;
      $msg = 'Error dumping crontab occured. For example permission denied.';
    }
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__ . " (rc=$rc).");
  return array($rc, $msg);
}

?>
