<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

/*

  getClusterTypes()
  isDatabaseInCluster($dbh, $pNodeId)
  isDatabaseInOtherCluster($dbh, $pNodeId, $pClusterId)
  checkClusterNameExists($pName)
  checkBinLog()
  checkServerId()
  checkMasterInSlaves()
  checkDuplicateSlaves()
  testCluster($abort = false, $output = 'html')
  deleteAllNodesFromCluster($dbh, $pClusterId)
  getClustersWithFilter($dbh, $aFilter)
  addCluster($dbh, $paCluster)
  updateCluster($dbh, $aCluster)
  deleteCluster($dbh, $pClusterId)
  getClusterOfNode($dbh, $pNodeId)
  getMasterOfSlave($dbh, $pSlaveId)
  getClusterOfVipById($dbh, $pVipId)

*/

// No require/included here!

// ---------------------------------------------------------------------
function getClusterTypes()
// ---------------------------------------------------------------------
{
  return array(
    1 => 'Master/Slave'
  , 2 => 'Master/Master'
  , 3 => 'Galera Cluster'
  , 4 => 'Failover Cluster'
  , 5 => 'MySQL Cluster'
  );
}

// ---------------------------------------------------------------------
function isDatabaseInCluster($dbh, $pNodeId)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = false;

  list($rc, $aNodes) = getNodesWithFilter($dbh, array('node_id' => $pNodeId));
  if ( count($aNodes) == 1 ) {
    $aNode = array_shift($aNodes);
    if ( intval($aNode['server_id']) > 0 ) {
      $rc = true;
    }
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__);
  return $rc;
}

// ---------------------------------------------------------------------
function isDatabaseInOtherCluster($dbh, $pNodeId, $pClusterId)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = false;

  list($rc, $aNodes) = getNodesWithFilter($dbh, array('node_id' => $pNodeId));

  if ( count($aNodes) == 1 ) {
    $aNode = array_shift($aNodes);
    // A cluster is set and it is not the actual cluster
    if ( (intval($aNode['cluster_id']) > 0) && ($aNode['cluster_id'] != $pClusterId) ) {
      $rc = true;
    }
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__);
  return $rc;
}

// ---------------------------------------------------------------------
function checkClusterNameExists($pName)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  list($rc, $dbh) = openRepositoryDatabase();
  list($rc, $aSections) = getAllDatabaseNodes($dbh);
  closeRepositoryDatabase($dbh);

  if ( in_array($pName, $aSections) ) {
    throw new Exception("Name " . $pName . " already exist.");
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__);
}

// ---------------------------------------------------------------------
function checkBinLog()
// ---------------------------------------------------------------------
{
  print "checkBinLog<br />\n";
  return array(-1, 'checkBinLog');
}

// ---------------------------------------------------------------------
function checkServerId()
// ---------------------------------------------------------------------
{
  print "checkServerId<br />\n";
}

// ---------------------------------------------------------------------
function checkMasterInSlaves()
// ---------------------------------------------------------------------
{
  print "checkMasterInSlaves<br />\n";
}

// ---------------------------------------------------------------------
function checkDuplicateSlaves()
// ---------------------------------------------------------------------
{
  print "checkDuplicateSlaves<br />\n";
}

// -------------------------------------------------------------------
// similar to testNode!!
function testCluster($dbh, $aCluster, $abort = false)
// parameter: abort = {true|false}
// return   : array(failed_checks, array('check', array($rc, $msg)))
// -------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $aChecks = array();
  $failed_checks = 0;

  // list($ret, $aCluster) = getClusterById($dbh, $aCluster['cluster_id']);

  // Check if binary log is enabled

  $check = 'binary_log';
  list($ret, $msg) = checkBinLog($aCluster);
  $aChecks[$check] = array($ret, $msg);
  if ( $ret != OK ) {
    $failed_checks++;
    if ( $abort === true ) {
      return array($failed_checks, $aChecks);
    }
  }



//   checkServerId($aCluster);
//   checkMasterInSlaves($aCluster);
//   checkDuplicateSlaves(v);

  print "<pre>"; print_r($aChecks); print "</pre>";
  return array($failed_checks, $aChecks);






  // Open database connection for the following checks
  list($rc, $mysqli) = openDatabaseConnection($aNode['database_user'], $aNode['database_user_password'], $aNode['hostname'], $aNode['port']);
  if ( $rc != 0 ) {
    $aChecks[$check] = array($rc, $mysqli);
    $failed_checks++;
    if ( $abort === true ) {
      return array($failed_checks, $aChecks);
    }
  }


  // Check database privileges

  $check = 'database_privileges';
  if ( gettype($mysqli) == 'object' ) {

    list($rc, $msg) = checkDatabasePrivileges($mysqli, $aNode);
    $aChecks[$check] = array($rc, $msg);
    if ( $rc != 0 ) {
      $failed_checks++;
      if ( $abort === true ) {
        closeDatabaseConnection($mysqli);
        return array($failed_checks, $aChecks);
      }
    }
  }
  else {
    $failed_checks++;
    if ( $abort === true ) {
      // no closeDatabaseConnection
      return array($failed_checks, $aChecks);
    }
  }


  // Check database variables

  $check = 'database_variables';
  if ( gettype($mysqli) == 'object' ) {

    $aVariables = array(
      'datadir'  => $aNode['datadir']
    , 'basedir'  => $aNode['basedir']
    , 'port'     => $aNode['port']
    , 'hostname' => $aNode['hostname']
    );
    list($rc, $msg) = checkDatabaseVariables($mysqli, $aNode, $aVariables);
    $aChecks[$check] = array($rc, $msg);
    if ( $rc != 0 ) {
      $failed_checks++;
      if ( $abort === true ) {
        closeDatabaseConnection($mysqli);
        return array($failed_checks, $aChecks);
      }
    }
  }
  else {
    $failed_checks++;
    if ( $abort === true ) {
      // no closeDatabaseConnection
      return array($failed_checks, $aChecks);
    }
  }


  // Check my.cnf

  $check = 'my_cnf';
  if ( gettype($mysqli) == 'object' ) {
    list($rc, $msg) = checkMyCnf($aServer, $aNode);
    $aChecks[$check] = array($rc, $msg);
    if ( $rc != 0 ) {
      $failed_checks++;
      if ( $abort === true ) {
        closeDatabaseConnection($mysqli);
        return array($failed_checks, $aChecks);
      }
    }
  }
  else {
    $aChecks[$check] = array($rc, $mysqli);
    $failed_checks++;
    if ( $abort === true ) {
      return array($failed_checks, $aChecks);
    }
  }


  // Check if database is read_only

  $check = 'read_only';
  if ( gettype($mysqli) == 'object' ) {
    list($rc, $msg) = checkDatabaseReadOnly($mysqli, $aNode);
    $aChecks[$check] = array($rc, $msg);
    if ( $rc != 0 ) {
      $failed_checks++;
      if ( $abort === true ) {
        closeDatabaseConnection($mysqli);
        return array($failed_checks, $aChecks);
      }
    }
  }
  else {
    $aChecks[$check] = array($rc, $mysqli);
    $failed_checks++;
    if ( $abort === true ) {
      return array($failed_checks, $aChecks);
    }
  }

  // Close databse connection for all...
  if ( gettype($mysqli) == 'object' ) {
    closeDatabaseConnection($mysqli);
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__);
  return array($failed_checks, $aChecks);
}

// ---------------------------------------------------------------------
function deleteAllNodesFromCluster($dbh, $pClusterId)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $cnt = 0;

  $sql = "UPDATE nodes
   SET cluster_id = 0
     , role_id = 0
     , master_id = 0
 WHERE cluster_id = :cluster_id";

  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));
  $stmt = $dbh->prepare($sql);
  $stmt->bindValue(':cluster_id', $pClusterId);

  try {
    $stmt->execute();
    $cnt = $stmt->rowCount();
  }
  catch (PDOException $e) {
    $rc = 906;
    $cnt = $e->getMessage();
  }
  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__);
  return array($rc, $cnt);
}

// ---------------------------------------------------------------------
function getClustersWithFilter($dbh, $aFilter = array())
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $aClusters = array();

  $sql = "SELECT * FROM clusters WHERE 1\n";

  foreach ( $aFilter as $key => $value ) {
    $sql .= "  AND $key = :$key\n";
  }

  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));
  $stmt = $dbh->prepare($sql);

  foreach ( $aFilter as $key => $value ) {
    $stmt->bindValue(":$key", $value);
  }

  try {
    $stmt->execute();

    while ( $result = $stmt->fetch(PDO::FETCH_ASSOC) ) {
      $aClusters[$result['cluster_id']] = $result;
    }
  }
  catch (PDOException $e) {
    $rc = 754;
    logMessage(LOG_ERR, $e->getMessage() . " (rc=$rc)");
    $aClusters = $e->getMessage() . " (rc=$rc)";
  }
  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__);
  return array($rc, $aClusters);
}

// ---------------------------------------------------------------------
// Do NOT use anymore!
function getAllClusters($dbh, $pType = 0)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $aClusters = array();

  // Really all Clusters of all types
  if ( $pType == 0 ) {
    $aClusters = getClustersWithFilter($dbh, array());
  }
  // Only Clusters of one specific type
  else {
    $aClusters = getClustersWithFilter($dbh, array('type' => $pType));
  }

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__);
  return $aClusters;
}

// ---------------------------------------------------------------------
// Do NOT use anymore!
function getClusterByName($dbh, $pName)
// ---------------------------------------------------------------------
{
  list($ret, $aClusters) = getClustersWithFilter($dbh, array('name' => $pName));
  return array($ret, array_shift($aClusters));
}

// ---------------------------------------------------------------------
// Do NOT use anymore!
function getClusterById($dbh, $pId)
// ---------------------------------------------------------------------
{
  list($ret, $aClusters) = getClustersWithFilter($dbh, array('cluster_id' => $pId));
  return array($ret, array_shift($aClusters));
}

// ---------------------------------------------------------------------
function addCluster($dbh, $paCluster)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $cluster_id = 0;

  $paCluster['last_change_ts'] = time();

  if ( $paCluster['name'] == '' ) {
    $rc = 932;
    return array($rc, $cluster_id);
  }

  $sql = "INSERT INTO clusters ('name', 'last_change_ts', 'type') VALUES (:name, :ts, :type)";
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));
  $stmt = $dbh->prepare($sql);
  $stmt->bindValue(':name', $paCluster['name']);
  $stmt->bindValue(':ts', $paCluster['last_change_ts']);
  $stmt->bindValue(':type', $paCluster['type']);

  try {
    $stmt->execute();
    $cluster_id =  $dbh->lastInsertId();
  }
  catch (PDOException $e) {
    $rc = 941;
    print "<p>" . $e->getMessage() . " (rc=$rc)</p>\n";
  }
  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__);
  return array($rc, $cluster_id);
}

// ---------------------------------------------------------------------
function updateCluster($dbh, $aCluster)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $aCluster['last_change_ts'] = time();

  if ( $aCluster['name'] == '' ) {
    $rc = 913;
    print "<p>Cluster name is empty (rc=$rc).</p>\n";
    return $rc;
  }

  $sql = "UPDATE clusters
   SET name = :name
     , type = :type
     , last_change_ts = :last_change_ts
 WHERE cluster_id = :cluster_id";

  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));
  $stmt = $dbh->prepare($sql);
  $stmt->bindValue(':name', $aCluster['name']);
  $stmt->bindValue(':type', $aCluster['type']);
  $stmt->bindValue(':last_change_ts', $aCluster['last_change_ts']);
  $stmt->bindValue(':cluster_id', $aCluster['cluster_id']);

  try {
    $stmt->execute();
  }
  catch (PDOException $e) {
    $rc = 905;
    print "<p>" . $e->getMessage() . " (rc=$rc)</p>\n";
  }
  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__);
  return $rc;
}

// ---------------------------------------------------------------------
function deleteCluster($dbh, $pClusterId)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc  = OK;

  list($ret, $cnt) = deleteAllNodesFromCluster($dbh, $pClusterId);

  foreach ( array('vips', 'servers') as $table ) {

    // Remove cluster from {node, vip, server}
    $sql = "UPDATE " . $table . " SET cluster_id = NULL WHERE cluster_id = :cluster_id";

		logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));
    $stmt = $dbh->prepare($sql);
    $stmt->bindValue(':cluster_id', $pClusterId);

    try {
      $stmt->execute();
      // $cnt = $stmt->rowCount();
    }
    catch (PDOException $e) {
      $rc = 938;
      print "<p>" . $table . ' ' . $e->getMessage() . " (rc=$rc)</p>\n";
    }
    $stmt->closeCursor();
  }

  // Delete entries from clusters

  $sql = "DELETE FROM clusters WHERE cluster_id = :cluster_id";
  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));
  $stmt = $dbh->prepare($sql);
  $stmt->bindValue(':cluster_id', $pClusterId);

  try {
    $stmt->execute();
    // $cnt = $stmt->rowCount();
  }
  catch (PDOException $e) {
    $rc = 808;
    print "<p>" . $e->getMessage() . " (rc=$rc)</p>\n";
  }
  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__);
  return $rc;
}

// ---------------------------------------------------------------------
function getClusterOfNode($dbh, $pNodeId)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $aCluster = array();

  $sql = "SELECT c.*
  FROM clusters AS c
  JOIN nodes AS n ON c.cluster_id = n.cluster_id
  JOIN servers AS s on n.server_id = s.server_id
 WHERE n.node_id = :node_id";

  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));
  $stmt = $dbh->prepare($sql);
  $stmt->bindValue(':node_id', $pNodeId);

  try {
    $stmt->execute();
  }
  catch (PDOException $e) {
    $rc = 904;
    print "<p>" . $e->getMessage() . " (rc=$rc)</p>\n";
  }
  if ( $result = $stmt->fetch(PDO::FETCH_ASSOC) ) {
    $aCluster = $result;
  }
  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__);
  return array($rc, $aCluster);
}

// ---------------------------------------------------------------------
function getMasterOfSlave($dbh, $pSlaveId)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;
  $lMasterId = 0;

  // todo: This is wrong! It is not clear in a M/M/S set-up which slave belongs to which master!!!
  $sql = "SELECT mn.node_id AS node_id
  FROM nodes AS sn
  JOIN clusters AS c ON c.cluster_id = sn.cluster_id
  JOIN nodes AS mn ON mn.cluster_id = c.cluster_id
 WHERE sn.node_id = :slave_id
   AND mn.role_id = :role_id";

  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));
  $stmt = $dbh->prepare($sql);
  $stmt->bindValue(':slave_id', $pSlaveId);
  $stmt->bindValue(':role_id', MASTER);

  try {
    $stmt->execute();
  }
  catch (PDOException $e) {
    $rc = 939;
    $msg = $e->getMessage();
    return array($rc, $msg);
  }
  // todo: Can be more than one in M/M set-up
  $lNodeId = 0;
  if ( $result = $stmt->fetch(PDO::FETCH_ASSOC) ) {
    $lNodeId = intval($result['node_id']);
  }
  else {
    $rc = 922;
    $msg = "No Master found";
    return array($rc, $msg);
  }
  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__);
  return array($rc, $lNodeId);
}

// ---------------------------------------------------------------------
function getClusterOfVipById($dbh, $pVipId)
// ---------------------------------------------------------------------
{
  global $gIndention;
  logMessage(LOG_NOTICE, 'Begin function: ' . basename(__FILE__) . '/' . __FUNCTION__);
  $gIndention += 2;

  $rc = OK;

  $aCluster = array();

  $sql = "SELECT c.*
  FROM clusters AS c
  JOIN vips AS v ON v.cluster_id = c.cluster_id
 WHERE v.vip_id = :vip_id";

  logMessage(LOG_DEBUG, trim(preg_replace('/\s+/', ' ', $sql)));
  $stmt = $dbh->prepare($sql);
  $stmt->bindValue(':vip_id', $pVipId);

  try {
    $stmt->execute();
  }
  catch (PDOException $e) {
    $rc = 926;
    return array($rc, $e->getMessage());
  }
  if ( $result = $stmt->fetch(PDO::FETCH_ASSOC) ) {
     $aCluster = $result;
  }
  $stmt->closeCursor();

  $gIndention -= 2;
  logMessage(LOG_NOTICE, 'End function: ' . __FUNCTION__);
  return array($rc, $aCluster);
}

?>
