//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

function startAndTestNode(nodeId)
{
  startNodeLocal(nodeId);
  pingNodeRemote(nodeId);
  testNode(nodeId);
}

function startNodeLocal(nodeId)
{
  document.getElementById("start-message").hidden = false;

	var xmlhttp;

	if (window.XMLHttpRequest) {
		xmlhttp = new XMLHttpRequest();
	}

	xmlhttp.onreadystatechange = function() {

		if (xmlhttp.readyState == 4 && xmlhttp.status == 200 ) {
			document.getElementById("start-message").innerHTML = xmlhttp.responseText;
		}
	}
  // false -> synchronous!
	xmlhttp.open("GET", "/mocenter/frag/startNodeLocal.php?node_id=" + nodeId, false);
	xmlhttp.send();
}

function pingNodeRemote(nodeId)
{
  document.getElementById("ping-message").hidden = false;

	var xmlhttp;

	if (window.XMLHttpRequest) {
		xmlhttp = new XMLHttpRequest();
	}

	xmlhttp.onreadystatechange = function() {

		if (xmlhttp.readyState == 4 && xmlhttp.status == 200 ) {
			document.getElementById("ping-message").innerHTML = xmlhttp.responseText;
		}
	}
  // false -> synchronous!
	xmlhttp.open("GET", "/mocenter/frag/pingNodeRemote.php?node_id=" + nodeId, false);
	xmlhttp.send();
}


function testNode(nodeId)
{
  document.getElementById("test-message").hidden = false;

	var xmlhttp;

	if (window.XMLHttpRequest) {
		xmlhttp = new XMLHttpRequest();
	}

	xmlhttp.onreadystatechange = function() {

		if (xmlhttp.readyState == 4 && xmlhttp.status == 200 ) {
			document.getElementById("test-message").innerHTML = xmlhttp.responseText;
		}
	}
  // true -> asynchronous!
	xmlhttp.open("GET", "/mocenter/frag/testNode.php?node_id=" + nodeId, true);
	xmlhttp.send();
}
