<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

$gMyNameBase = dirname(__FILE__);
$gMode = 'demo';
$gIndention = 0;

session_start();

require('lib/Constants.inc');
require('lib/Configuration.inc');
require('lib/Log.inc');
require('lib/System.inc');
require('lib/Repository.inc');

require('lib/Install.inc');
require('lib/User.inc');
require('lib/Global.inc');
require('lib/Server.inc');
require('lib/Node.inc');
require('lib/Database.inc');
require('lib/Check.inc');
require('lib/Cluster.inc');
require('lib/Vip.inc');
include('lib/Menu.inc');

// phpinfo();
// var_dump($_REQUEST);

$hFunction = isset($_REQUEST['f'])  ? substr(strval($_REQUEST['f']), 0, 24) : '';
$hObject   = isset($_REQUEST['o'])  ? substr(strval($_REQUEST['o']), 0, 16) : '';
$hType     = isset($_REQUEST['t'])  ? substr(strval($_REQUEST['t']), 0, 32) : '';
$hSubMenu  = isset($_REQUEST['s'])  ? substr(strval($_REQUEST['s']), 0, 32) : '';
$hNodeId   = isset($_REQUEST['node_id']) ? intval($_REQUEST['node_id']) : 0;


// Check if installation is already done

$level = getInstallationLevel();

if ( $level != 'completed' ) {
  $hFunction = 'install';
  $hObject   = 'system';
}

if ( isset($_SESSION['logged_in']) && ($_SESSION['logged_in'] == 1 ) ) {
  $gMenuStructure['login'] = array('title' => 'Logout', 'link' => 'index.php?f=logout&amp;o=user', 'active' => true);
}
else {
  $gMenuStructure['login'] = array('title' => 'Login', 'link' => 'index.php?f=show&amp;o=user&amp;s=login-mask', 'active' => true);
}

if ( $level == 'completed' ) {

  list($ret, $dbh) = openRepositoryDatabase();

  if ( $ret != OK ) {
    $rc = 995;
    print "<p>Cannot open repository database (rc=$rc).</p>\n";
		print "<p>Please make sure PDO for sqlite is installed:\n";
		print "<pre>shell> sudo apt-get install php5-sqlite</pre>\n";
		print "Make sure user <code>" . whoami() . "</code> has access to file $gRepository.</p>\n";
    exit($rc);
  }
  else {

    // do Upgrade first
    $rc = upgradeRepositoryDatabase($dbh);
    if ( $rc != OK ) {
      $rc = 933;
      print "<p>Cannot upgrade repository database (rc=$rc).</p>\n";
      exit($rc);
    }

    list($ret, $encryptedLicense) = getEncryptedLicense($dbh);

    // Jump directly to License if level is completed and no license exists
    // and Function/Object/SubMenu is NOT upload/configuration/license_information
    // No licese found
    // Redirect to license page
    if ( $ret != OK ) {

      // 2 cases:
      // No license is there or license table is missing
      if ( $ret == 992 ) {
        $msg = "(Something realy went wrong: $encryptedLicense (rc=$ret)";
        logMessage(LOG_ERR, $msg);
        print "<p>$msg</p>";
        exit($ret);
      }

      if ( ($hFunction == 'upload')
        && ($hObject == 'configuration')
        && ($hSubMenu == 'license_information')
         ) {
        // uploading a license is an exception
      }
      else {
        $hFunction = 'show';
        $hObject   = 'configuration';
        $hSubMenu  = 'license_information';
      }
    }
    // License found
    else {

      $decryptedLicense = decryptLicense(getMocIdentifier($dbh), $encryptedLicense);

      if ( $decryptedLicense['type'] == 'demo' ) {
				$gMode = 'demo';
				$_SESSION['logged_in'] = 1;
      }
      elseif ( $decryptedLicense['type'] == 'production' ) {
				$gMode = 'production';

				// If NOT logged in AND it is a production license go to loggin screen
				if ( (! isset($_SESSION['logged_in'])) || ($_SESSION['logged_in'] == 0) ) {

					// Bypass if login user is wanted
					if ( ($hFunction == 'login')
						&& ($hObject == 'user')
						) {
						// login user is an exception
					}
					else {
						$hFunction = 'show';
						$hObject   = 'user';
						$hType     = 'login-mask';
						$hSubMenu  = 'login-mask';
					}
				}
      }
      else {
				$rc = 123;
				logMessage(LOG_ERR, "Internal error:  >" . $decryptedLicense['type'] . "< (rc=$rc).");
			}
    }
    closeRepositoryDatabase($dbh);
  }
}


?><!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<title>FromDual Ops Center for MySQL</title>

	<link rel="icon" type="image/png" href="img/fromdual.ico" />

	<link rel="stylesheet" href="/mocenter/css/themes/smoothness/jquery-ui.css" />
	<link rel="stylesheet" href="http://code.jquery.com/ui/1.10.3/themes/smoothness/jquery-ui.css">
	<script src="js/jquery.js"></script>
	<script src="js/jquery-ui.js"></script>
</head>
<body>

<?php

// Print horizontal Menu

$color = '#FFD3D1';
$https = false;
if ( ! empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off' || $_SERVER['SERVER_PORT'] == 443 ) {
	$https = true;
	$color = 'white';
}

?>

<table border="1" cellpadding="3" cellspacing="0" width="1024" align="center">
  <tr valign="top">
    <td width="25%" align="center"><a href="http://fromdual.com/mysql-ops-center" title="FromDual GmbH" target="_blank"><img src="<?php print $gThemePath; ?>/logo.png" alt="FromDual GmbH" title="FromDual GmbH" height="32" /></a></td>
    <td align="right" colspan="6">
			<?php
			if ( isset($_SESSION['logged_in']) && ($_SESSION['logged_in'] == 1) ) {
				?><a href="index.php?f=logout&amp;o=user">Logout</a><?php
			}
			?>
		</td>
  </tr>
</table>

<?php

// Print body

?>

<table border="1" cellpadding="3" cellspacing="0" width="1024" align="center">
	<tr valign="top">
		<?php
		if ( isset($_SESSION['logged_in']) && ($_SESSION['logged_in'] == 1 ) ) {
			?>
			<td width="25%">
				<?php

				if ( $level == 'completed' ) {
					printMenu();
				}
				?>
			</td>
			<?php
		}
		?>
    <td valign="top">
      <?php

      // Set default
      if ( $hObject == '' ) {
        $hObject = 'configuration';
      }

      if ( $hObject == 'configuration' ) {
        require_once("page/configuration.php");
      }
      elseif ( $hObject == 'node' ) {
        require_once("page/node.php");
      }
      elseif ( $hObject == 'replication' ) {
        require_once("page/replication.php");
      }
      elseif ( $hObject == 'master-master' ) {
        require_once("page/master-master.php");
      }
      elseif ( $hObject == 'slave' ) {
        require_once("page/slave.php");
      }
      elseif ( $hObject == 'cluster' ) {
        require_once("page/cluster.php");
      }
      elseif ( $hObject == 'public_key' ) {
        require_once("page/public_key.php");
      }
      elseif ( $hObject == 'crontab' ) {
        require_once("page/crontab.php");
      }
      elseif ( $hObject == 'vip' ) {
        require_once("page/vip.php");
      }
      elseif ( $hObject == 'system' ) {
        require_once("page/install.php");
      }
      elseif ( $hObject == 'server' ) {
        require_once("page/server.php");
      }
      elseif ( $hObject == 'user' ) {
        require_once("page/user.php");
      }
      elseif ( $hObject == 'load-balancer' ) {
        require_once("page/load-balancer.php");
      }
      else {
        $rc = 698;
        print "<p>Unknown object: $hObject (rc=$rc).</p>\n";
        exit($rc);
      }


			// Warn if expiration has been reached
			if ( isset($decryptedLicense['expiry_date']) && ($decryptedLicense['expiry_date'] < time()) ) {
				?><p><strong style="color:red;">You License has expired!</strong></p><?php
			}
			?>
			<p align="right"><?php print $gVersion; ?></p>
		</td>
	</tr>
</table>

<?php // print_r($_SESSION); ?>

</body>

</html>
