<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

// Must be the same base as in index.php
$gMyNameBase = dirname(dirname(__FILE__));

require('../lib/Constants.inc');
require('../lib/Configuration.inc');
require('../lib/Log.inc');
require('../lib/Repository.inc');

include('../lib/System.inc');
include('../lib/Server.inc');
include('../lib/Check.inc');

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
session_start();

$hServerId = isset($_REQUEST['server_id']) ? intval($_REQUEST['server_id']) : 0;

if ( isset($_SESSION['logged_in']) && ($_SESSION['logged_in'] == 1 ) ) {
  // noop
}
else {
  $rc = 898;
  logMessage(LOG_EMERG, "Not logged in! (rc=$rc)");
  exit($rc);
}

list($ret, $dbh) = openRepositoryDatabase();

list($ret, $aServers) = getServersWithFilter($dbh, array('server_id' => $hServerId));
$aServer = array_shift($aServers);
// print "<pre>"; print_r($aServer); print "</pre>";

closeRepositoryDatabase($dbh);


list($cnt, $aChecks) = testServer($dbh, $aServer, false);

foreach ( $aChecks as $check => $arr ) {

  switch ( $check ) {
  case 'hostname':
    printHostnameCheck($aServer, $arr);
    break;
  case 'host_ping':
    printHostPingCheck($aServer, $arr);
    break;
  case 'ssh_connect':
    printSshConnectCheck($aServer, $aServer, $arr);
    break;
  default:
    $rc = 689;
    print "Error: $check (rc=$rc)<br />\n";
    exit;
  }
}

if ( $cnt == 0 ) {
  print "Server " . $aServer['name'] . " is <span style='color:green;'><strong>OK</strong></span>.<br />\n";
}
else {
  print "<p>Testing server " . $aServer['name'] . " failed.</p>\n";
  print "<p>Server " . $aServer['name'] . " has $cnt <span style='color:red;'><strong>ERROR</strong></span>(s).</p>\n";
}

logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
 