<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

// Must be the same base as in index.php
$gMyNameBase = dirname(dirname(__FILE__));

require('../lib/Constants.inc');
require('../lib/Configuration.inc');
require('../lib/Log.inc');
require('../lib/Repository.inc');
include('../lib/Node.inc');
include('../lib/Database.inc');
include('../lib/Server.inc');
include('../lib/Check.inc');

logMessage(LOG_NOTICE, 'Begin fragment: ' . basename(__FILE__));
$gIndention += 2;

session_start();

$hNodeId   = isset($_REQUEST['node_id']) ? intval($_REQUEST['node_id']) : 0;

if ( isset($_SESSION['logged_in']) && ($_SESSION['logged_in'] == 1 ) ) {
  // noop
}
else {
  $rc = 897;
  logMessage(LOG_EMERG, "Not logged in! (rc=$rc)");
  exit($rc);
}

list($ret, $dbh) = openRepositoryDatabase();

list($ret, $aNodes) = getNodesWithFilter($dbh, $aFilter = array('node_id' => $hNodeId));
$aNode = array_shift($aNodes);

closeRepositoryDatabase($dbh);


list($cnt, $aChecks) = testNode($dbh, $aNode, false);

// testNode should always fail here!
if ( $cnt > 0 ) {

  if ( $aChecks['database_connect'][0] == 0 ) {
		$rc = 887;
		$msg = "Node " . $aNode['name'] . " is accessible.";
		logMessage(LOG_ERR, "$msg (rc=$rc)");
		logMessage(LOG_ERR, print_r($aChecks, true));
		print "<p>$msg</p>\n";
  }
  else {
		logMessage(LOG_ERR, $cnt);
		logMessage(LOG_ERR, print_r($aChecks, true));
		print "<p>Node seems to be down.</p>\n";
  }

	foreach ( $aChecks as $check => $arr ) {

		switch ( $check ) {
		case 'database_connect':
			printDatabaseConnectCheck($aNode, $arr);
			break;
		case 'database_privileges':
			printDatabasePrivilegesCheck($aNode, $arr);
			break;
		case 'database_variables':
			printDatabaseVariablesCheck($aNode, $arr);
			break;
		case 'my_cnf':
			printMyCnfCheck($aNode, $arr);
			break;
		case 'read_only':
			printReadOnlyCheck($aNode, $arr[0], $arr[1]);
			break;
		default:
			$rc = 679;
			print "Error: $check (rc=$rc)<br />\n";
		}
	}

	print "<p>Testing node " . $aNode['name'] . " failed.</p>\n";
	print "<p>Node " . $aNode['name'] . " has $cnt <span style='color:red;'><strong>ERROR</strong></span>(s).</p>\n";
}
else {
  $rc = 877;
  $msg = "Node " . $aNode['name'] . " is accessible.";
  logMessage(LOG_ERR, "$msg (rc=$rc)");
  logMessage(LOG_DEBUG, print_r($aChecks, true));
  print "<p>$msg</p>\n";
	print "<p>Node " . $aNode['name'] . " is <span style='color:green;'><strong>OK</strong></span>.</p>\n";
}

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
