<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

// Must be the same base as in index.php
$gMyNameBase = dirname(dirname(__FILE__));

require('../lib/Constants.inc');
require('../lib/Configuration.inc');
require('../lib/Log.inc');
require('../lib/Repository.inc');
include('../lib/Node.inc');
include('../lib/Database.inc');
include('../lib/Server.inc');
include('../lib/System.inc');

logMessage(LOG_NOTICE, 'Begin fragment: ' . basename(__FILE__));
$gIndention += 2;

session_start();
// print "<pre>"; print_r($_SESSION); print "</pre>";

$hNodeId   = isset($_REQUEST['node_id']) ? intval($_REQUEST['node_id']) : 0;

if ( isset($_SESSION['logged_in']) && ($_SESSION['logged_in'] == 1 ) ) {
  // noop
}
else {
  $rc = 876;
  logMessage(LOG_EMERG, "Not logged in! (rc=$rc)");
  exit($rc);
}

list($ret, $dbh) = openRepositoryDatabase();

list($ret, $aNodes) = getNodesWithFilter($dbh, $aFilter = array('node_id' => $hNodeId));
$aNode = array_shift($aNodes);

list($ret, $aServers) = getServersWithFilter($dbh, array('server_id' => $aNode['server_id']));
$aServer = array_shift($aServers);

closeRepositoryDatabase($dbh);


$ret = stopNodeRemote($aServer, $aNode);

if ($ret != OK ) {
  $rc = 112;
  print "<p>(ret=$ret / rc=$rc).</p>\n";
}

$gIndention -= 2;
logMessage(LOG_NOTICE, 'End fragment: ' . basename(__FILE__));

?>
