<?php

//
// Copyright (C) 2013, 2014 FromDual GmbH
//
// This program is commercial software. Use of this software is governed
// by your applicable license agreement with FromDual GmbH
//

// Must be the same base as in index.php
$gMyNameBase = dirname(dirname(__FILE__));

require('../lib/Constants.inc');
require('../lib/Configuration.inc');
require('../lib/Log.inc');
require('../lib/Repository.inc');
include('../lib/Node.inc');
include('../lib/Database.inc');
include('../lib/Server.inc');
include('../lib/System.inc');
include('../lib/Check.inc');

logMessage(LOG_NOTICE, 'Begin page: ' . basename(__FILE__));
session_start();

$hNodeId   = isset($_REQUEST['node_id']) ? intval($_REQUEST['node_id']) : 0;

if ( isset($_SESSION['logged_in']) && ($_SESSION['logged_in'] == 1 ) ) {
  // noop
}
else {
  $rc = 895;
  logMessage(LOG_EMERG, "Not logged in! (rc=$rc)");
  exit($rc);
}

list($ret, $dbh) = openRepositoryDatabase();

list($ret, $aNodes) = getNodesWithFilter($dbh, $aFilter = array('node_id' => $hNodeId));
$aNode = array_shift($aNodes);

list($ret, $aServers) = getServersWithFilter($dbh, array('server_id' => $aNode['server_id']));
$aServer = array_shift($aServers);

closeRepositoryDatabase($dbh);


?><p>Starting node via ssh (local)...</p><?php

list($ret, $msg) = startNodeLocal($aServer, $aNode);
if ( $ret != OK ) {
  $rc = 884;
  print "<p>$msg (rc=$rc)</p>\n";
  if ( substr($msg, 0, 17) == 'Permission denied' ) {
    // production create public key if none is there
    $whoami = whoami();
    print "<p>You have to put the public key (~/.ssh/id_?sa.pub) of user $whoami@localhost into the ~/.ssh/authorized_keys file of user " . $this->aSection['os_user'] . '@' . $this->aSection['hostname'] . ".</p>\n";
    print "<p><input type='button' value='Create public key' disabled='disabled' title='This feature is available for production version only.' /></p>";
  }
  else {
    $js = 'window.location="index.php?f=show&amp;o=node&amp;node_id=' . $aNode['node_id'] . '";';
    print "<p><input type='button' value='Continue' onclick='$js' /></p>\n";
  }
}

logMessage(LOG_NOTICE, 'End page: ' . basename(__FILE__));

?>
